/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cx_reader;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.internal.cx_reader.CytoscapeCxFileFilter;
import org.cytoscape.io.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CytoscapeCx2FileFilter
extends CytoscapeCxFileFilter {
    private static final String[] cx2Extensions = new String[]{"cx2"};
    private static final String cx2Description = "CX2 JSON";
    public static final Pattern CX2_HEADER_PATTERN = Pattern.compile("\\s*\\[\\s*\\{\\s*\"\\s*CXVersion\"\\s*:\\s*\"2.0\"");

    private CytoscapeCx2FileFilter(String[] extensions, String[] contentTypes, String description, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, streamUtil);
    }

    public CytoscapeCx2FileFilter(StreamUtil streamUtil) {
        this(cx2Extensions, types, cx2Description, streamUtil);
    }

    @Override
    public boolean accepts(InputStream stream, DataCategory dataCategory) {
        if (!dataCategory.equals((Object)DataCategory.NETWORK)) {
            return false;
        }
        try {
            return CytoscapeCx2FileFilter.getCX2startElement(stream) != null;
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("Error while checking header", (Throwable)e);
            return false;
        }
    }

    protected static String getCX2startElement(InputStream stream) {
        String header = CytoscapeCx2FileFilter.getHeaderCharacters(stream, 400);
        Matcher matcher = CX2_HEADER_PATTERN.matcher(header);
        String root = null;
        if (matcher.find()) {
            root = matcher.group(0);
        }
        return root;
    }
}

