/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ndexbio.cxio.aspects.datamodels.CyTableVisualPropertiesElement;
import org.ndexbio.cxio.aspects.readers.CartesianLayoutFragmentReader;
import org.ndexbio.cxio.aspects.readers.CyGroupsFragmentReader;
import org.ndexbio.cxio.aspects.readers.CyTableColumnFragmentReader;
import org.ndexbio.cxio.aspects.readers.CyVisualPropertiesFragmentReader;
import org.ndexbio.cxio.aspects.readers.EdgeAttributesFragmentReader;
import org.ndexbio.cxio.aspects.readers.EdgesFragmentReader;
import org.ndexbio.cxio.aspects.readers.GeneralAspectFragmentReader;
import org.ndexbio.cxio.aspects.readers.HiddenAttributesFragmentReader;
import org.ndexbio.cxio.aspects.readers.NetworkAttributesFragmentReader;
import org.ndexbio.cxio.aspects.readers.NetworkRelationsFragmentReader;
import org.ndexbio.cxio.aspects.readers.NodeAttributesFragmentReader;
import org.ndexbio.cxio.aspects.readers.NodesFragmentReader;
import org.ndexbio.cxio.aspects.readers.SubNetworkFragmentReader;
import org.ndexbio.cxio.aspects.writers.CartesianLayoutFragmentWriter;
import org.ndexbio.cxio.aspects.writers.CyGroupsFragmentWriter;
import org.ndexbio.cxio.aspects.writers.CyTableColumnFragmentWriter;
import org.ndexbio.cxio.aspects.writers.EdgeAttributesFragmentWriter;
import org.ndexbio.cxio.aspects.writers.EdgesFragmentWriter;
import org.ndexbio.cxio.aspects.writers.GeneralAspectFragmentWriter;
import org.ndexbio.cxio.aspects.writers.HiddenAttributesFragmentWriter;
import org.ndexbio.cxio.aspects.writers.NetworkAttributesFragmentWriter;
import org.ndexbio.cxio.aspects.writers.NetworkRelationsFragmentWriter;
import org.ndexbio.cxio.aspects.writers.NodeAttributesFragmentWriter;
import org.ndexbio.cxio.aspects.writers.NodesFragmentWriter;
import org.ndexbio.cxio.aspects.writers.SubNetworkFragmentWriter;
import org.ndexbio.cxio.aspects.writers.VisualPropertiesFragmentWriter;
import org.ndexbio.cxio.core.interfaces.AspectFragmentReader;
import org.ndexbio.cxio.core.interfaces.AspectFragmentWriter;

public class AspectSet {
    private static final List<String> cx2Aspects = Arrays.asList("attributeDeclarations", "networkAttributes", "nodes", "edges", "visualProperties", "nodeBypasses", "edgeBypasses", "visualEditorProperties", "tableVisualProperties");
    private static final List<String> cxAspects = Arrays.asList("nodes", "edges", "cartesianLayout", "edgeAttributes", "nodeAttributes", "networkAttributes", "cySubNetworks", "cyVisualProperties", "cyNetworkRelations", "cyGroups", "cyHiddenAttributes", "cyTableColumn", "tableVisualProperties");

    private AspectSet() {
    }

    public static final List<String> getAspectNames() {
        return cxAspects;
    }

    public static final List<String> getCx2AspectNames() {
        return cx2Aspects;
    }

    public static final Set<AspectFragmentWriter> getAspectFragmentWriters(Collection<String> _aspects) {
        HashSet<AspectFragmentWriter> writers = new HashSet<AspectFragmentWriter>();
        Iterator<String> iterator = _aspects.iterator();
        block30: while (iterator.hasNext()) {
            String aspect;
            switch (aspect = iterator.next()) {
                case "cartesianLayout": {
                    writers.add((AspectFragmentWriter)CartesianLayoutFragmentWriter.createInstance());
                    continue block30;
                }
                case "edgeAttributes": {
                    writers.add((AspectFragmentWriter)EdgeAttributesFragmentWriter.createInstance());
                    continue block30;
                }
                case "edges": {
                    writers.add((AspectFragmentWriter)EdgesFragmentWriter.createInstance());
                    continue block30;
                }
                case "networkAttributes": {
                    writers.add((AspectFragmentWriter)NetworkAttributesFragmentWriter.createInstance());
                    continue block30;
                }
                case "nodeAttributes": {
                    writers.add((AspectFragmentWriter)NodeAttributesFragmentWriter.createInstance());
                    continue block30;
                }
                case "cyHiddenAttributes": {
                    writers.add((AspectFragmentWriter)HiddenAttributesFragmentWriter.createInstance());
                    continue block30;
                }
                case "nodes": {
                    writers.add((AspectFragmentWriter)NodesFragmentWriter.createInstance());
                    continue block30;
                }
                case "cyVisualProperties": {
                    writers.add((AspectFragmentWriter)VisualPropertiesFragmentWriter.createInstance());
                    continue block30;
                }
                case "cySubNetworks": {
                    writers.add((AspectFragmentWriter)SubNetworkFragmentWriter.createInstance());
                    continue block30;
                }
                case "cyNetworkRelations": {
                    writers.add((AspectFragmentWriter)NetworkRelationsFragmentWriter.createInstance());
                    continue block30;
                }
                case "cyGroups": {
                    writers.add((AspectFragmentWriter)CyGroupsFragmentWriter.createInstance());
                    continue block30;
                }
                case "cyTableColumn": {
                    writers.add((AspectFragmentWriter)CyTableColumnFragmentWriter.createInstance());
                    continue block30;
                }
                case "tableVisualProperties": {
                    writers.add((AspectFragmentWriter)new GeneralAspectFragmentWriter("tableVisualProperties"));
                    continue block30;
                }
            }
            throw new IllegalArgumentException("Cannot get writer for unknown aspect: " + aspect);
        }
        return writers;
    }

    public static final Set<AspectFragmentReader> getAspectFragmentReaders(Collection<String> _aspects) {
        HashSet<AspectFragmentReader> readers = new HashSet<AspectFragmentReader>();
        Iterator<String> iterator = _aspects.iterator();
        block30: while (iterator.hasNext()) {
            String aspect;
            switch (aspect = iterator.next()) {
                case "cartesianLayout": {
                    readers.add((AspectFragmentReader)CartesianLayoutFragmentReader.createInstance());
                    continue block30;
                }
                case "edgeAttributes": {
                    readers.add((AspectFragmentReader)EdgeAttributesFragmentReader.createInstance());
                    continue block30;
                }
                case "edges": {
                    readers.add((AspectFragmentReader)EdgesFragmentReader.createInstance());
                    continue block30;
                }
                case "networkAttributes": {
                    readers.add((AspectFragmentReader)NetworkAttributesFragmentReader.createInstance());
                    continue block30;
                }
                case "nodeAttributes": {
                    readers.add((AspectFragmentReader)NodeAttributesFragmentReader.createInstance());
                    continue block30;
                }
                case "cyHiddenAttributes": {
                    readers.add((AspectFragmentReader)HiddenAttributesFragmentReader.createInstance());
                    continue block30;
                }
                case "nodes": {
                    readers.add((AspectFragmentReader)NodesFragmentReader.createInstance());
                    continue block30;
                }
                case "cyVisualProperties": {
                    readers.add((AspectFragmentReader)CyVisualPropertiesFragmentReader.createInstance());
                    continue block30;
                }
                case "cySubNetworks": {
                    readers.add((AspectFragmentReader)SubNetworkFragmentReader.createInstance());
                    continue block30;
                }
                case "cyNetworkRelations": {
                    readers.add((AspectFragmentReader)NetworkRelationsFragmentReader.createInstance());
                    continue block30;
                }
                case "cyGroups": {
                    readers.add((AspectFragmentReader)CyGroupsFragmentReader.createInstance());
                    continue block30;
                }
                case "cyTableColumn": {
                    readers.add((AspectFragmentReader)CyTableColumnFragmentReader.createInstance());
                    continue block30;
                }
                case "tableVisualProperties": {
                    readers.add((AspectFragmentReader)new GeneralAspectFragmentReader("tableVisualProperties", CyTableVisualPropertiesElement.class));
                    continue block30;
                }
            }
            throw new IllegalArgumentException("Cannot get writer for unknown aspect: " + aspect);
        }
        return readers;
    }
}

