/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.diffusion.internal.ui.AbstractSliderPanel;
import org.cytoscape.diffusion.internal.ui.HeatSelectionPanel;
import org.cytoscape.diffusion.internal.ui.NoResultPanel;
import org.cytoscape.diffusion.internal.ui.RankSelectionPanel;
import org.cytoscape.diffusion.internal.ui.SubnetCreatorPanel;
import org.cytoscape.diffusion.internal.util.DiffusionResult;
import org.cytoscape.diffusion.internal.util.DiffusionTable;
import org.cytoscape.diffusion.internal.util.DiffusionTableManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.create.NewNetworkSelectedNodesOnlyTaskFactory;
import org.cytoscape.task.read.LoadVizmapFileTaskFactory;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.vizmap.VisualMappingManager;

public class OutputPanel
extends JPanel
implements CytoPanelComponent2,
SetCurrentNetworkListener,
NetworkAboutToBeDestroyedListener {
    public static String IDENTIFIER = "diffusion";
    private JComboBox<String> columnNameComboBox;
    private JPanel selectionPanel;
    private JPanel bottomPanel;
    private final CyApplicationManager appManager;
    private final DiffusionTableManager tableManager;
    private final RenderingEngineManager renderingEngineMgr;
    private final CySwingApplication swingApplication;
    private final VisualMappingManager vmm;
    private final LoadVizmapFileTaskFactory vizmapLoader;
    private final CyServiceRegistrar registrar;
    private final NoResultPanel emptyPanel;
    private JPanel mainPanel;
    private SubnetCreatorPanel subnetPanel;
    final NewNetworkSelectedNodesOnlyTaskFactory createSubnetworkFactory;

    public OutputPanel(CyServiceRegistrar registrar, DiffusionTableManager tableManager, LoadVizmapFileTaskFactory vizmapLoader, CyApplicationManager appManager, VisualMappingManager vmm, NewNetworkSelectedNodesOnlyTaskFactory createSubnetworkFactory, RenderingEngineManager renderingEngineMgr, CySwingApplication swingApplication) {
        this.registrar = registrar;
        this.appManager = appManager;
        this.vizmapLoader = vizmapLoader;
        this.vmm = vmm;
        this.tableManager = tableManager;
        this.createSubnetworkFactory = createSubnetworkFactory;
        this.renderingEngineMgr = renderingEngineMgr;
        this.emptyPanel = new NoResultPanel();
        this.swingApplication = swingApplication;
        this.setBackground(Color.white);
        this.initPanel();
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.mainPanel);
        this.add(this.subnetPanel);
    }

    private final void initPanel() {
        this.selectionPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.subnetPanel = new SubnetCreatorPanel(this.tableManager, this.vizmapLoader, this.vmm, this.createSubnetworkFactory, this.appManager, this.renderingEngineMgr);
        this.subnetPanel.setOpaque(false);
        this.subnetPanel.setMaximumSize(new Dimension(5000, 56));
        this.subnetPanel.setMinimumSize(new Dimension(380, 56));
        this.bottomPanel = new JPanel();
        this.bottomPanel.setBackground(Color.white);
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)this.selectionPanel, "Center");
        JPanel columnSelectorPanel = this.createSelector();
        columnSelectorPanel.setOpaque(false);
        this.mainPanel.setMinimumSize(new Dimension(380, 155));
        this.mainPanel.setMaximumSize(new Dimension(5000, 155));
        Border padding = BorderFactory.createEmptyBorder(0, 5, 0, 5);
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createTitledBorder("Node Selector"));
        columnSelectorPanel.setBorder(padding);
        this.bottomPanel.setBorder(padding);
        this.mainPanel.add((Component)columnSelectorPanel, "North");
        this.mainPanel.add((Component)this.bottomPanel, "Center");
    }

    public void setPanelVisible(final boolean visible) {
        final OutputPanel outputPanel = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int compIndex;
                Component panel;
                CytoPanel cytoPanel = OutputPanel.this.swingApplication.getCytoPanel(CytoPanelName.EAST);
                if (visible && cytoPanel.indexOfComponent(IDENTIFIER) < 0) {
                    OutputPanel.this.registrar.registerService((Object)outputPanel, CytoPanelComponent.class, new Properties());
                    if (cytoPanel.getState() == CytoPanelState.HIDE) {
                        cytoPanel.setState(CytoPanelState.DOCK);
                    }
                    int componentCount = cytoPanel.getCytoPanelComponentCount();
                    int targetPanelIdx = 0;
                    for (int i = 0; i < componentCount; ++i) {
                        CytoPanelComponent2 cp2;
                        String panelId;
                        Component panelComponent = cytoPanel.getComponentAt(i);
                        if (!(panelComponent instanceof CytoPanelComponent2) || (panelId = (cp2 = (CytoPanelComponent2)panelComponent).getIdentifier()) == null || !panelId.equals(IDENTIFIER)) continue;
                        Dimension defSize = new Dimension(300, 400);
                        panelComponent.setPreferredSize(defSize);
                        panelComponent.setSize(defSize);
                        targetPanelIdx = i;
                        break;
                    }
                    cytoPanel.setSelectedIndex(targetPanelIdx);
                    cytoPanel.getThisComponent().repaint();
                } else if (!visible && cytoPanel.indexOfComponent(IDENTIFIER) >= 0 && (panel = cytoPanel.getComponentAt(compIndex = cytoPanel.indexOfComponent(IDENTIFIER))) == outputPanel) {
                    OutputPanel.this.registrar.unregisterService((Object)outputPanel, CytoPanelComponent.class);
                }
                ((JComponent)outputPanel).updateUI();
            }
        });
    }

    private final JPanel createSelector() {
        JPanel selectorPanel = new JPanel();
        selectorPanel.setBackground(Color.white);
        selectorPanel.setLayout(new BorderLayout());
        this.configureColumnNameComboBox();
        JLabel selectorLabel = new JLabel("Range Column: ");
        selectorPanel.add((Component)selectorLabel, "Before");
        selectorPanel.add(this.columnNameComboBox, "Center");
        return selectorPanel;
    }

    private void configureColumnNameComboBox() {
        DiffusionTable currentTable = this.tableManager.getCurrentTable();
        if (currentTable == null) {
            this.columnNameComboBox = new JComboBox<String>(new String[0]);
        } else {
            String[] cols = currentTable.getAvailableOutputColumns();
            this.columnNameComboBox.removeAllItems();
            for (String col : cols) {
                this.columnNameComboBox.addItem(col);
            }
        }
        this.columnNameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OutputPanel.this.columnNameComboBox.getSelectedIndex() == -1) {
                    return;
                }
                String columnName = OutputPanel.this.getColumnName();
                OutputPanel.this.columnNameComboBox.setSelectedItem(columnName);
                OutputPanel.this.columnNameSelected(columnName);
            }
        });
    }

    private void columnNameSelected(String columnName) {
        CyNetwork network = this.appManager.getCurrentNetwork();
        DiffusionTable diffusionTable = this.tableManager.getTable(network.getSUID());
        if (columnName.endsWith("_rank")) {
            String base = columnName.replace("_rank", "");
            diffusionTable.setCurrentDiffusionResult(base);
            this.setSelectionPanel(new RankSelectionPanel(diffusionTable, "Rank"));
        } else if (columnName.endsWith("_heat")) {
            String base = columnName.replace("_heat", "");
            diffusionTable.setCurrentDiffusionResult(base);
            this.setSelectionPanel(new HeatSelectionPanel(diffusionTable, "Heat"));
        } else {
            this.setSelectionPanel(new JPanel());
        }
    }

    private void setSelectionPanel(JPanel panel) {
        this.bottomPanel.remove(this.selectionPanel);
        this.selectionPanel = panel;
        this.bottomPanel.add((Component)this.selectionPanel, "Center");
        this.validate();
        this.repaint();
    }

    public void setColumnName(String columnName) {
        this.columnNameComboBox.setModel(new DefaultComboBoxModel<String>(this.tableManager.getCurrentTable().getAvailableOutputColumns()));
        this.columnNameComboBox.setSelectedItem(columnName);
        this.columnNameSelected(columnName);
    }

    private String getColumnName() {
        return (String)this.columnNameComboBox.getSelectedItem();
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.EAST;
    }

    public String getTitle() {
        return "Diffusion Output";
    }

    public Icon getIcon() {
        return null;
    }

    public DiffusionTable loadNetworkResults(CyNetwork network) {
        this.subnetPanel.updateStyles();
        DiffusionTable table = this.tableManager.createTable(network);
        HashSet<String> bases = new HashSet<String>();
        for (String column : table.getAvailableOutputColumns()) {
            String base = column.substring(0, column.length() - 5);
            if (bases.contains(base)) continue;
            bases.add(base);
            DiffusionResult result = new DiffusionResult(network, base + "_rank", base + "_heat");
            table.setDiffusionResult(base, result);
        }
        return table;
    }

    public void handleEvent(SetCurrentNetworkEvent evt) {
        CyNetwork network = evt.getNetwork();
        if (network == null) {
            this.setPanelVisible(false);
            return;
        }
        DiffusionTable table = null;
        table = this.tableManager.getTable(network.getSUID());
        if (table == null) {
            table = this.loadNetworkResults(network);
        }
        if (table.getAvailableOutputColumns().length == 0) {
            this.setPanelVisible(false);
            return;
        }
        this.subnetPanel.updateStyles();
        this.tableManager.setCurrentTable(table);
        String[] cols = table.getAvailableOutputColumns();
        if (cols == null || cols.length == 0) {
            this.columnNameComboBox.setEnabled(false);
            this.setPanelVisible(false);
        } else {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(cols);
            this.columnNameComboBox.setModel(model);
            this.columnNameComboBox.setEnabled(true);
            this.columnNameSelected(cols[0]);
            this.setPanelVisible(true);
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent arg0) {
        if (arg0.getNetwork() != null) {
            this.tableManager.removeNetwork(arg0.getNetwork());
            if (this.selectionPanel instanceof AbstractSliderPanel && arg0.getNetwork() == ((AbstractSliderPanel)this.selectionPanel).getNetwork()) {
                this.setSelectionPanel(this.emptyPanel);
            }
        }
    }
}

