/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.cytoscape.diffusion.internal.ui.SliderValueSetterPanel;
import org.cytoscape.diffusion.internal.util.DiffusionTable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public abstract class AbstractSliderPanel
extends JPanel
implements PropertyChangeListener {
    protected final DiffusionTable diffusionTable;
    protected final JSlider thresholdSlider;
    protected final SliderValueSetterPanel valuePanel;

    AbstractSliderPanel(DiffusionTable diffusionTable, String title, String prefix, String suffix) {
        this.diffusionTable = diffusionTable;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(Color.white);
        JLabel label = new JLabel(prefix + title + suffix + ":");
        label.setFont(new Font("SansSerif", 1, 14));
        JPanel labelPanel = new JPanel();
        labelPanel.setMaximumSize(new Dimension(1000, 20));
        labelPanel.setOpaque(false);
        labelPanel.setLayout(new BorderLayout());
        labelPanel.add((Component)label, "Before");
        this.valuePanel = new SliderValueSetterPanel(title);
        this.valuePanel.setOpaque(false);
        this.valuePanel.setMaximumSize(new Dimension(1000, 30));
        this.valuePanel.addPropertyChangeListener(this);
        this.thresholdSlider = this.createSlider();
        this.add(labelPanel);
        this.add(this.thresholdSlider);
        this.add(this.valuePanel);
    }

    protected void selectNodesOverThreshold(String heatColumn, Double threshold) {
        CyNetwork network = this.diffusionTable.getAssociatedNetwork();
        CyTable localTable = network.getTable(CyNode.class, "LOCAL_ATTRS");
        for (CyRow row : localTable.getAllRows()) {
            Double heatValue = (Double)row.get(heatColumn, Double.class);
            if (heatValue >= threshold) {
                row.set("selected", (Object)Boolean.TRUE);
                continue;
            }
            row.set("selected", (Object)Boolean.FALSE);
        }
    }

    protected abstract JSlider createSlider();

    public CyNetwork getNetwork() {
        return this.diffusionTable.getAssociatedNetwork();
    }
}

