/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.task;

import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.diffusion.internal.ViewWriterFactoryManager;
import org.cytoscape.diffusion.internal.client.DiffusionServiceClient;
import org.cytoscape.diffusion.internal.task.DiffuseSelectedTask;
import org.cytoscape.diffusion.internal.task.DiffuseSelectedWithOptionsTask;
import org.cytoscape.diffusion.internal.ui.OutputPanel;
import org.cytoscape.diffusion.internal.util.DiffusionTableManager;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNodeViewTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TunableSetter;

public class DiffusionContextMenuTaskFactory
extends AbstractNodeViewTaskFactory
implements NetworkViewTaskFactory {
    private final ViewWriterFactoryManager factoryManager;
    private final OutputPanel outputPanel;
    private final CySwingApplication swingApplication;
    private final CyApplicationManager appManager;
    private final DiffusionServiceClient client;
    private final TunableSetter setter;
    private final DiffusionTableManager tableManager;
    private Boolean withOptions = false;

    public DiffusionContextMenuTaskFactory(CyServiceRegistrar registrar, DiffusionTableManager tableManager, OutputPanel outputPanel, ViewWriterFactoryManager factoryManager, CySwingApplication swingApplication, CyApplicationManager appManager, DiffusionServiceClient client, TunableSetter setter) {
        this(registrar, tableManager, outputPanel, factoryManager, swingApplication, appManager, client, setter, false);
    }

    public DiffusionContextMenuTaskFactory(CyServiceRegistrar registrar, DiffusionTableManager tableManager, OutputPanel outputPanel, ViewWriterFactoryManager factoryManager, CySwingApplication swingApplication, CyApplicationManager appManager, DiffusionServiceClient client, TunableSetter setter, Boolean withOptions) {
        this.outputPanel = outputPanel;
        this.factoryManager = factoryManager;
        this.swingApplication = swingApplication;
        this.appManager = appManager;
        this.client = client;
        this.setter = setter;
        this.withOptions = withOptions;
        this.tableManager = tableManager;
    }

    public TaskIterator createTaskIterator(CyNetworkView networkView) {
        return this.create((CyNetwork)networkView.getModel());
    }

    public TaskIterator createTaskIterator(View<CyNode> nodeView, CyNetworkView networkView) {
        return this.create((CyNetwork)networkView.getModel());
    }

    public boolean isReady(View<CyNode> nodeView, CyNetworkView networkView) {
        return this.isReady(networkView);
    }

    public boolean isReady(CyNetworkView networkView) {
        if (networkView == null) {
            return false;
        }
        List selNodes = CyTableUtil.getNodesInState((CyNetwork)((CyNetwork)networkView.getModel()), (String)"selected", (boolean)true);
        return selNodes != null && selNodes.size() > 0;
    }

    private final TaskIterator create(CyNetwork network) {
        CyNetworkViewWriterFactory writerFactory = this.factoryManager.getCxFactory();
        if (writerFactory == null) {
            throw new IllegalStateException("CXWriterFactory is not available.  Please make sure you have proper dependencies");
        }
        if (this.withOptions.booleanValue()) {
            return new TaskIterator(new Task[]{new DiffuseSelectedWithOptionsTask(this.tableManager, network, writerFactory, this.outputPanel, this.swingApplication, this.appManager, this.client, this.setter)});
        }
        return new TaskIterator(new Task[]{new DiffuseSelectedTask(this.tableManager, network, writerFactory, this.outputPanel, this.swingApplication, this.appManager, this.client, this.setter)});
    }
}

