/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.task;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.cytoscape.diffusion.internal.task.HttpClientFactory;
import org.cytoscape.diffusion.internal.task.HttpClientFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffusionCallable
implements Callable {
    public static final String HEAT_COLUMN_PARAM = "input_attribute_name";
    public static final String TIME_PARAM = "time";
    private static final Logger logger = LoggerFactory.getLogger(DiffusionCallable.class);
    private HttpClient _client = null;
    private final String _cx;
    private final String _inputHeatCol;
    private final Double _time;
    private final String _diffusionURL;
    private HttpClientFactory _httpClientFactory;

    public DiffusionCallable(String cx, String inputHeatCol, Double time, String diffusionURL) {
        this._cx = cx;
        this._inputHeatCol = inputHeatCol;
        this._time = time;
        this._diffusionURL = diffusionURL;
        this._httpClientFactory = new HttpClientFactoryImpl();
    }

    protected void setAlternateHttpClientFactory(HttpClientFactory clientFactory) {
        this._httpClientFactory = clientFactory;
    }

    public String call() throws Exception {
        try {
            URI uri = this.getRequestURI(this._inputHeatCol, this._time);
            HttpPost post = new HttpPost(uri.toString());
            StringEntity cxEntity = new StringEntity(this._cx);
            post.setEntity((HttpEntity)cxEntity);
            post.setHeader("Content-type", "application/json");
            HttpResponse response = this._httpClientFactory.getHttpClient().execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new IOException(this.createConnectionError("Response from diffusion service is null."));
            }
            String result = EntityUtils.toString((HttpEntity)entity);
            return result;
        }
        catch (Exception e) {
            logger.error("Connection error contacting the heat diffusions service");
            logger.error(this.createConnectionError(e.toString()), (Throwable)new IOException());
            throw new IOException(this.createConnectionError(e.toString()));
        }
    }

    private URI getRequestURI(String inputHeatCol, Object time) throws URISyntaxException {
        ArrayList<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
        if (time != null) {
            postParams.add(new BasicNameValuePair(TIME_PARAM, time.toString()));
        }
        if (inputHeatCol != null) {
            postParams.add(new BasicNameValuePair(HEAT_COLUMN_PARAM, inputHeatCol));
        }
        postParams.add(new BasicNameValuePair("threshold", "-1"));
        URIBuilder uriBuilder = new URIBuilder(this._diffusionURL);
        uriBuilder.addParameters(postParams);
        return uriBuilder.build();
    }

    private String createConnectionError(String errorMessage) {
        return String.format("Oops! An error occurred while connecting to the heat diffusion service in the cloud.\n\n You may be disconnected from the internet, the service may be unavailable, or some other problem with the connection might have occurred.\nCheck your connection, check that you can resolve the host name diffuse.cytoscape.io, and check your firewall settings before retying.\nAfter checking that everything is ok, wait a while and try again, or if the problem persists, contact the app author for help.\n\nCytoscape encountered this error while connecting:\n %s", errorMessage);
    }
}

