/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.task;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.cxio.aspects.datamodels.ATTRIBUTE_DATA_TYPE;
import org.cxio.aspects.datamodels.NodeAttributesElement;
import org.cxio.core.interfaces.AspectElement;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.diffusion.internal.client.DiffusionResultParser;
import org.cytoscape.diffusion.internal.client.DiffusionServiceClient;
import org.cytoscape.diffusion.internal.client.DiffusionServiceException;
import org.cytoscape.diffusion.internal.client.NodeAttributes;
import org.cytoscape.diffusion.internal.rest.DiffusionResultColumns;
import org.cytoscape.diffusion.internal.ui.OutputPanel;
import org.cytoscape.diffusion.internal.util.DiffusionResult;
import org.cytoscape.diffusion.internal.util.DiffusionTable;
import org.cytoscape.diffusion.internal.util.DiffusionTableManager;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.task.AbstractNetworkTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.json.JSONResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffuseSelectedTask
extends AbstractNetworkTask
implements ObservableTask {
    private static final String heatSuffix = "_heat";
    private static final String rankSuffix = "_rank";
    private static final String ORIGINAL_HEAT_ATTR_NAME = "diffusion_output_heat";
    private static final String ORIGINAL_RANK_ATTR_NAME = "diffusion_output_rank";
    public static final String DIFFUSION_INPUT_COL_NAME = "diffusion_input";
    private static final String DIFFUSION_OUTPUT_COL_NAME = "diffusion_output";
    protected DiffusionResultParser resultParser;
    protected OutputPanel outputPanel;
    private final CySwingApplication swingApplication;
    protected final DiffusionServiceClient client;
    protected final CyApplicationManager appManager;
    protected final DiffusionTableManager tableManager;
    protected TaskMonitor tm;
    private static final Logger logger = LoggerFactory.getLogger(DiffuseSelectedTask.class);
    private DiffusionResultColumns diffusionResultColumns = null;

    public DiffuseSelectedTask(DiffusionTableManager tableManager, CyNetwork network, CyNetworkViewWriterFactory writerFactory, OutputPanel outputPanel, CySwingApplication swingApplication, CyApplicationManager appManager, DiffusionServiceClient client, TunableSetter setter) {
        super(network);
        this.tableManager = tableManager;
        this.resultParser = new DiffusionResultParser(writerFactory, setter);
        this.outputPanel = outputPanel;
        this.swingApplication = swingApplication;
        this.client = client;
        this.appManager = appManager;
    }

    public void run(TaskMonitor tm) throws Exception {
        this.tm = tm;
        tm.setTitle("Running Heat Diffusion");
        tm.setStatusMessage("Running heat diffusion service.  Please wait...");
        this.diffuse(null, null);
    }

    protected void diffuse(String columnName, Double time) throws Exception {
        String inputCol = columnName;
        this.tm.setStatusMessage("Creating heat columns");
        if (columnName == null) {
            inputCol = DIFFUSION_INPUT_COL_NAME;
            this.setInputHeatValues(inputCol);
        }
        String cx = this.resultParser.encode(this.network, inputCol);
        this.tm.setStatusMessage("Running diffusion");
        String responseJSONString = this.client.diffuse(cx, columnName, time, this);
        if (responseJSONString == null && this.cancelled) {
            this.tm.setStatusMessage("User canceled task");
            return;
        }
        this.tm.setStatusMessage("Decoding response");
        Map<String, List<AspectElement>> response = null;
        try {
            response = this.resultParser.decode(responseJSONString);
        }
        catch (DiffusionServiceException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not parse the following Diffusion service response: " + responseJSONString);
            throw new IllegalStateException("Could not parse the Diffusion service response", e);
        }
        this.tm.setStatusMessage("Loading Result");
        String outputColumnName = this.getNextAvailableColumnName(DIFFUSION_OUTPUT_COL_NAME);
        List<AspectElement> nodeAttributes = response.get("nodeAttributes");
        this.setResult(outputColumnName, nodeAttributes);
        this.diffusionResultColumns = new DiffusionResultColumns();
        this.diffusionResultColumns.heatColumn = String.format("%s_heat", outputColumnName);
        this.diffusionResultColumns.rankColumn = String.format("%s_rank", outputColumnName);
        this.appManager.setCurrentNetwork(this.network);
        this.outputPanel.setColumnName(String.format("%s_rank", outputColumnName));
        this.outputPanel.setPanelVisible(true);
        this.showResult();
        this.tm.setStatusMessage("Cleaning up");
    }

    private final void setInputHeatValues(String columnName) {
        this.ensureEmptyTableExists(columnName);
        List nodes = CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true);
        for (CyNode node : nodes) {
            Long suid = node.getSUID();
            CyRow row = this.getNodeTable().getRow((Object)suid);
            row.set(columnName, (Object)1.0);
        }
    }

    private void ensureEmptyTableExists(String columnName) {
        this.getNodeTable().deleteColumn(columnName);
        this.getNodeTable().createColumn(columnName, Double.class, false, (Object)0.0);
    }

    private void createColumns(String base) {
        String rankName = this.formatColumnName(base, rankSuffix);
        String heatName = this.formatColumnName(base, heatSuffix);
        this.getNodeTable().deleteColumn(rankName);
        this.getNodeTable().createColumn(rankName, Integer.class, false);
        this.getNodeTable().deleteColumn(heatName);
        this.getNodeTable().createColumn(heatName, Double.class, false, (Object)0.0);
    }

    private final void setResult(String baseColumnName, List<AspectElement> nodeAttrs) {
        CyTable table = this.getNodeTable();
        if (table == null) {
            throw new IllegalStateException("Table does not exist yet.");
        }
        this.createColumns(baseColumnName);
        String rankColumnName = this.formatColumnName(baseColumnName, rankSuffix);
        String heatColumnName = this.formatColumnName(baseColumnName, heatSuffix);
        DiffusionTable diffTable = this.tableManager.getTable(this.network.getSUID());
        if (diffTable == null) {
            diffTable = this.tableManager.createTable(this.network);
        }
        DiffusionResult result = new DiffusionResult(this.network, rankColumnName, heatColumnName);
        diffTable.setDiffusionResult(baseColumnName, result);
        for (AspectElement attr : nodeAttrs) {
            NodeAttributesElement nodeAttr = (NodeAttributesElement)attr;
            Long suid = (Long)nodeAttr.getPropertyOf().get(0);
            CyRow row = this.getNodeTable().getRow((Object)suid);
            String attrName = nodeAttr.getName();
            String valueStr = nodeAttr.getValue();
            if (attrName.equals(ORIGINAL_HEAT_ATTR_NAME)) {
                row.set(heatColumnName, this.parseValue(ATTRIBUTE_DATA_TYPE.DOUBLE, valueStr));
                continue;
            }
            if (!attrName.equals(ORIGINAL_RANK_ATTR_NAME)) continue;
            row.set(rankColumnName, this.parseValue(ATTRIBUTE_DATA_TYPE.INTEGER, valueStr));
        }
    }

    private final Object parseValue(ATTRIBUTE_DATA_TYPE type, String valueStr) {
        if (type.equals((Object)ATTRIBUTE_DATA_TYPE.STRING)) {
            return valueStr;
        }
        if (type.equals((Object)ATTRIBUTE_DATA_TYPE.INTEGER)) {
            return Integer.parseInt(valueStr);
        }
        if (type.equals((Object)ATTRIBUTE_DATA_TYPE.LONG)) {
            return Long.parseLong(valueStr);
        }
        if (type.equals((Object)ATTRIBUTE_DATA_TYPE.DOUBLE) || type.equals((Object)ATTRIBUTE_DATA_TYPE.FLOAT)) {
            return Double.parseDouble(valueStr);
        }
        if (type.equals((Object)ATTRIBUTE_DATA_TYPE.BOOLEAN)) {
            return Boolean.parseBoolean(valueStr);
        }
        throw new IllegalArgumentException("don't know how to deal with type '" + type.toString() + "'");
    }

    public void setResults(String base, Map<String, NodeAttributes> nodes) {
        CyTable table = this.getNodeTable();
        if (table == null) {
            throw new IllegalStateException("Table does not exists yet.");
        }
        this.createColumns(base);
        for (Map.Entry<String, NodeAttributes> entry : nodes.entrySet()) {
            Long suid = Long.parseLong(entry.getKey());
            CyRow row = this.getNodeTable().getRow((Object)suid);
            row.set(this.formatColumnName(base, heatSuffix), (Object)entry.getValue().getHeat());
            row.set(this.formatColumnName(base, rankSuffix), (Object)entry.getValue().getRank());
        }
    }

    public String[] getAvailableOutputColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        CyTable table = this.getNodeTable();
        if (table == null) {
            return new String[0];
        }
        for (CyColumn column : this.getNodeTable().getColumns()) {
            if (!column.getType().equals(Double.class) && !column.getType().equals(Integer.class) || !this.hasDiffusionSuffix(column.getName()).booleanValue()) continue;
            columns.add(column.getName());
        }
        return columns.toArray(new String[columns.size()]);
    }

    private Boolean hasDiffusionSuffix(String columnName) {
        return columnName.endsWith(heatSuffix) || columnName.endsWith(rankSuffix);
    }

    public String getNextAvailableColumnName(String baseName) {
        String desiredName = baseName;
        int index = 1;
        while (this.columnsExist(desiredName).booleanValue()) {
            desiredName = this.formatColumnName(baseName, index);
            ++index;
        }
        return desiredName;
    }

    private Boolean columnsExist(String base) {
        CyTable table = this.getNodeTable();
        if (table == null) {
            return false;
        }
        Boolean heatExists = this.getNodeTable().getColumn(this.formatColumnName(base, heatSuffix)) != null;
        Boolean rankExists = this.getNodeTable().getColumn(this.formatColumnName(base, rankSuffix)) != null;
        return heatExists != false || rankExists != false;
    }

    private final CyTable getNodeTable() {
        return this.network.getTable(CyNode.class, "LOCAL_ATTRS");
    }

    private String formatColumnName(String base, Integer index) {
        return String.format("%s_%d", base, index);
    }

    private String formatColumnName(String base, String typeSuffix) {
        return String.format("%s%s", base, typeSuffix);
    }

    protected void showResult() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CytoPanel panel = DiffuseSelectedTask.this.swingApplication.getCytoPanel(CytoPanelName.EAST);
                panel.setState(CytoPanelState.DOCK);
                int componentCount = panel.getCytoPanelComponentCount();
                int targetPanelIdx = 0;
                for (int i = 0; i < componentCount; ++i) {
                    CytoPanelComponent2 cp2;
                    String panelId;
                    Component panelComponent = panel.getComponentAt(i);
                    if (!(panelComponent instanceof CytoPanelComponent2) || (panelId = (cp2 = (CytoPanelComponent2)panelComponent).getIdentifier()) == null || !panelId.equals("diffusion")) continue;
                    Dimension defSize = new Dimension(300, 400);
                    panelComponent.setPreferredSize(defSize);
                    panelComponent.setSize(defSize);
                    targetPanelIdx = i;
                    break;
                }
                panel.setSelectedIndex(targetPanelIdx);
                panel.getThisComponent().repaint();
            }
        });
    }

    protected String createServiceError(String errorMessage) {
        return String.format("Oops! Could not complete diffusion. The heat diffusion service in the cloud told us something went wrong while processing your request.\nHere is the error message we received from the service, email the service author with this message if you need assistance.\n\nError:\n %s", errorMessage);
    }

    private static final String getResultString(DiffusionResultColumns diffusionResultColumns) {
        return diffusionResultColumns != null ? "Created result columns: (" + diffusionResultColumns.heatColumn + "),(" + diffusionResultColumns.rankColumn + ")" : "No result columns available";
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(String.class)) {
            return (R)DiffuseSelectedTask.getResultString(this.diffusionResultColumns);
        }
        if (type.equals(DiffusionResultColumns.class)) {
            return (R)this.diffusionResultColumns;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> DiffuseSelectedTask.getJson(this.diffusionResultColumns);
            return (R)res;
        }
        return null;
    }

    public static final String getJson(DiffusionResultColumns diffusionResultColumns) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)diffusionResultColumns);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Class<?>> getResultClasses() {
        return Collections.unmodifiableList(Arrays.asList(String.class, DiffusionResultColumns.class, JSONResult.class));
    }

    public boolean isCanceled() {
        return this.cancelled;
    }
}

