/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.model;

import javafx.beans.binding.Binding;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;

public class NodeUtil {
    static boolean verbose = true;

    public static void centerAt(ImageView view, double x, double y) {
        view.setX(x - view.getFitWidth() / 2.0);
        view.setY(y + view.getFitHeight() / 2.0);
    }

    public static void forceWidth(Region n, int w) {
        n.setPrefWidth((double)w);
        n.setMinWidth((double)w);
        n.setMaxWidth((double)w);
    }

    public static void forceHeight(Region n, int h) {
        n.setPrefHeight((double)h);
        n.setMinHeight((double)h);
        n.setMaxHeight((double)h);
    }

    public static void forceSize(Region n, int w, int h) {
        NodeUtil.forceWidth(n, w);
        NodeUtil.forceHeight(n, h);
    }

    public static void invalOnActionOrFocusLost(Node n, Binding b) {
        n.addEventHandler(ActionEvent.ACTION, evt -> b.invalidate());
        n.focusedProperty().addListener((obs, old, isFocused) -> {
            if (!isFocused.booleanValue()) {
                b.invalidate();
            }
        });
    }

    public static String shortClassname(String class1) {
        return class1.substring(1 + class1.lastIndexOf(46));
    }

    public static void showKids(Parent parent, String indent) {
        block5: {
            block6: {
                block4: {
                    String id = parent.getId();
                    if (verbose) {
                        System.out.println(indent + NodeUtil.shortClassname(parent.getClass().toString()) + ":  " + (id == null ? "-" : id));
                    }
                    if (!(parent instanceof SplitPane)) break block4;
                    for (Node n : ((SplitPane)parent).getItems()) {
                        if (!(n instanceof Parent)) continue;
                        NodeUtil.showKids((Parent)n, indent + "    ");
                    }
                    break block5;
                }
                if (!(parent instanceof ScrollPane)) break block6;
                Node content = ((ScrollPane)parent).getContent();
                if (content instanceof Parent) {
                    NodeUtil.showKids((Parent)content, indent + "    ");
                }
                if (!verbose) break block5;
                System.out.println(indent + NodeUtil.shortClassname(content.getClass().toString()) + ":  " + (content.getId() == null ? "-" : content.getId()));
                break block5;
            }
            for (Node n : parent.getChildrenUnmodifiable()) {
                if (!(n instanceof Parent)) continue;
                NodeUtil.showKids((Parent)n, indent + "    ");
            }
        }
    }

    public static void reset(Node ... nodes) {
        for (Node n : nodes) {
            n.setOpacity(1.0);
            n.setTranslateX(0.0);
            n.setTranslateY(0.0);
            n.setTranslateZ(0.0);
            n.setRotate(0.0);
            n.setScaleX(1.0);
            n.setScaleY(1.0);
        }
    }
}

