/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.model;

import java.io.File;
import org.cytoscape.cyChart.internal.model.StatisticRequest;

public class GraphRequest
extends StatisticRequest {
    Graph type;
    File output;
    String x;
    String y = ".";
    String z = ".";
    String[] children;

    public GraphRequest(Graph typ, String xDim, String yDim, String mom, String ... kids) {
        super(mom);
        this.x = xDim;
        this.y = yDim;
        this.children = kids;
        this.type = typ;
    }

    public String firstChild() {
        return this.children == null || this.children.length == 0 ? "" : this.children[0];
    }

    public int nLayers() {
        return this.children.length;
    }

    public String[] getLayers() {
        return this.children;
    }

    String getId() {
        return this.type.toString() + this.x + this.y + this.z + this.population;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    public boolean isHistogram() {
        return this.type == Graph.HISTOGRAM;
    }

    public boolean isScatter() {
        return this.type == Graph.SCATTER;
    }

    public boolean isDensity() {
        return this.type == Graph.DENSITY;
    }

    public boolean isContour() {
        return this.type == Graph.CONTOUR;
    }

    public static enum Graph {
        HISTOGRAM,
        SCATTER,
        DENSITY,
        CONTOUR;

    }
}

