/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.charts.twoD;

import java.text.DecimalFormat;
import java.util.Objects;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import org.cytoscape.cyChart.internal.charts.oneD.FrameScaleConverter;
import org.cytoscape.cyChart.internal.charts.twoD.ScatterChartController;
import org.cytoscape.cyChart.internal.model.LinearRegression;
import org.cytoscape.cyChart.internal.model.LogarithmicAxis;
import org.cytoscape.cyChart.internal.model.Range;
import org.cytoscape.cyChart.internal.model.RectangleUtil;
import org.cytoscape.cyChart.internal.view.Cursors;

public class SelectableScatterChart
extends AnchorPane {
    FrameScaleConverter converter = new FrameScaleConverter();
    private ScatterChart<Number, Number> scatter;
    private final ScatterChartController controller;
    private ValueAxis<Number> xAxis;
    private ValueAxis<Number> yAxis;
    private Rectangle selectionRectangleScaleDef = new Rectangle(0.0, 0.0, 0.0, 0.0);
    private Rectangle selectionRectangle = new Rectangle(0.0, 0.0, 1.0, 1.0);
    private Rectangle mirrorRectangle = new Rectangle(0.0, 0.0, 1.0, 1.0);
    private Point2D selRectStart = null;
    private Point2D selRectEnd = null;
    private static final String STYLE_CLASS_SELECTION_BOX = "chart-selection-rectangle";
    Range xRange = null;
    Range yRange = null;
    boolean resizing = false;
    double offsetX = 0.0;
    double offsetY = 0.0;
    private Line regressionLine = null;
    private Label regressionLabel = null;
    private double regressionSlope = Double.NaN;
    private double regressionIntercept = Double.NaN;
    private double regressionCorrelation = Double.NaN;

    public FrameScaleConverter getConverter() {
        return this.converter;
    }

    public ScatterChart<Number, Number> getScatterChart() {
        return this.scatter;
    }

    public SelectableScatterChart(ScatterChartController ctlr) {
        this.controller = ctlr;
        AnchorPane.setTopAnchor((Node)this, (Double)5.0);
        AnchorPane.setBottomAnchor((Node)this, (Double)5.0);
        AnchorPane.setLeftAnchor((Node)this, (Double)5.0);
        AnchorPane.setRightAnchor((Node)this, (Double)5.0);
        this.addLayer("X", "Y", 0);
        this.getChildren().addAll((Object[])new Node[]{this.scatter});
        this.selectionLayerBuilder();
        this.clearRegression();
    }

    private void addLayer(String xName, String yName, int transitionType) {
        boolean xLog = this.controller.isXLog();
        boolean yLog = this.controller.isYLog();
        LogarithmicAxis xAxis = xLog ? new LogarithmicAxis() : new NumberAxis();
        xAxis.setLabel(xName);
        xAxis.setLowerBound(-100.0);
        LogarithmicAxis yAxis = yLog ? new LogarithmicAxis() : new NumberAxis();
        yAxis.setLabel(yName);
        this.scatter = new ScatterChart((Axis)xAxis, (Axis)yAxis);
        this.controller.anchor((Node)this.scatter);
        this.controller.setChart((XYChart<Number, Number>)this.scatter);
        String rootStr = ".root {\n    -fx-font-size: 24pt;\n -fx-font-family: \"Courier New\";\n -fx-base: rgb(132, 145, 47);\n   -fx-background: rgb(240, 240, 240);\n -fx-legend-visible: false; }";
        Node chartPlotArea = this.controller.getPlotAreaNode();
        if (chartPlotArea == null) {
            return;
        }
        Region rgn = (Region)chartPlotArea;
        rgn.setStyle("-fx-background-color: #FCFCFC;");
        ChangeListener paneSizeListener = (obs, oldV, newV) -> this.controller.resized();
        this.scatter.widthProperty().addListener(paneSizeListener);
        this.scatter.heightProperty().addListener(paneSizeListener);
        this.scatter.setStyle(rootStr);
    }

    public void setDataSeries(XYChart.Series<Number, Number> series1) {
        StackPane stack = (StackPane)series1.getNode();
        if (stack != null) {
            stack.setMaxSize(2.0, 2.0);
        }
        this.scatter.getData().add(series1);
    }

    public void setAxes(String x, String y) {
        this.scatter.getXAxis().setLabel(x);
        this.scatter.getYAxis().setLabel(y);
    }

    private boolean isRectangleSizeTooSmall() {
        if (this.selectionRectangle == null) {
            return true;
        }
        if (this.selectionRectangle.getWidth() < 10.0) {
            return true;
        }
        return this.selectionRectangle.getHeight() < 10.0;
    }

    public void selectionLayerBuilder() {
        this.xAxis = (ValueAxis)this.scatter.getXAxis();
        this.yAxis = (ValueAxis)this.scatter.getYAxis();
        this.makeSelectionRectangle();
        this.addDragSelectionMechanism(this.controller.getPlotAreaNode());
        StackPane.setAlignment((Node)this.selectionRectangle, (Pos)Pos.TOP_LEFT);
        StackPane.setAlignment((Node)this.mirrorRectangle, (Pos)Pos.TOP_LEFT);
    }

    private void makeSelectionRectangle() {
        this.selectionRectangle = new Rectangle();
        this.selectionRectangle.setOnMouseEntered(event -> this.setCursor(this.selectionRectangle, (MouseEvent)event));
        this.selectionRectangle.setOnMouseMoved(event -> this.setCursor(this.selectionRectangle, (MouseEvent)event));
        this.selectionRectangle.setOnMouseExited(event -> this.setCursor(Cursor.DEFAULT));
        this.selectionRectangle.setManaged(false);
        this.selectionRectangle.setOpacity(0.3);
        this.selectionRectangle.setFill((Paint)Color.CYAN);
        this.selectionRectangle.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_SELECTION_BOX});
        this.selectionRectangle.setStroke((Paint)Color.SADDLEBROWN);
        this.selectionRectangle.setStrokeWidth(2.0);
        RectangleUtil.setupCursors(this.selectionRectangle);
        this.selectionRectangle.setOnMousePressed(event -> {
            Pos pos = RectangleUtil.getPos(event, this.selectionRectangle);
            this.resizing = RectangleUtil.inCorner(pos);
            if (this.resizing) {
                this.selRectStart = RectangleUtil.oppositeCorner(event, this.selectionRectangle);
            } else {
                this.selRectStart = new Point2D(event.getX(), event.getY());
                this.offsetX = event.getX() - this.selectionRectangle.getX();
                this.offsetY = event.getY() - this.selectionRectangle.getY();
            }
            event.consume();
        });
        this.selectionRectangle.setOnMouseDragged(event -> {
            this.onDragged((MouseEvent)event);
            event.consume();
        });
        this.selectionRectangle.setOnMouseReleased(event -> {
            this.selectionRectangleScaleDef = this.rectDef(this.selectionRectangle, this.getPlotFrame());
            this.setAxisBounds();
            this.selRectEnd = null;
            this.selRectStart = null;
            this.requestFocus();
            event.consume();
        });
        this.mirrorRectangle.setManaged(false);
        this.mirrorRectangle.setOpacity(0.3);
        this.mirrorRectangle.setFill((Paint)Color.CYAN);
        this.mirrorRectangle.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_SELECTION_BOX});
        this.mirrorRectangle.setStroke((Paint)Color.SADDLEBROWN);
        this.mirrorRectangle.setStrokeWidth(2.0);
    }

    private void onDragged(MouseEvent event) {
        if (event.isSecondaryButtonDown()) {
            return;
        }
        boolean option = event.isAltDown();
        double offsetX = this.controller.getPlotAreaNode().getLayoutX();
        if (this.resizing) {
            this.selRectEnd = this.computeRectanglePoint(event.getX(), event.getY());
            if (this.selRectStart == null) {
                this.selRectStart = RectangleUtil.oppositeCorner(event, this.selectionRectangle);
            }
            if (this.selRectStart == null) {
                return;
            }
            double x = Math.min(this.selRectStart.getX(), this.selRectEnd.getX());
            double y = Math.min(this.selRectStart.getY(), this.selRectEnd.getY());
            double width = Math.abs(this.selRectStart.getX() - this.selRectEnd.getX());
            double height = Math.abs(this.selRectStart.getY() - this.selRectEnd.getY());
            this.drawSelectionRectangle(x, y, width, height, option, offsetX);
        } else {
            double oldX = this.selRectStart.getX();
            double oldY = this.selRectStart.getY();
            double dx = event.getX() - oldX;
            double dy = event.getY() - oldY;
            Bounds chartPlotArea = this.controller.getPlotBounds();
            double minAllowedX = chartPlotArea.getMinX() + 12.0;
            double maxAllowedX = minAllowedX + chartPlotArea.getWidth() + 12.0;
            double minAllowedY = chartPlotArea.getMinY() + 12.0;
            double maxAllowedY = minAllowedY + chartPlotArea.getHeight() + 12.0;
            double newLeft = this.selectionRectangle.getX() + dx;
            double newRight = newLeft + this.selectionRectangle.getWidth();
            double newTop = this.selectionRectangle.getY() + dy;
            double newBottom = newTop + this.selectionRectangle.getHeight();
            if (dx != 0.0 && (newLeft < minAllowedX || newRight > maxAllowedX)) {
                return;
            }
            if (newTop < minAllowedY || newBottom > maxAllowedY) {
                return;
            }
            this.selectionRectangle.setX(this.selectionRectangle.getX() + dx);
            this.selectionRectangle.setY(this.selectionRectangle.getY() + dy);
            this.drawSelectionRectangleAt(event.getX() - offsetX, event.getY() - this.offsetY, option, offsetX);
            this.selRectStart = new Point2D(event.getX(), event.getY());
        }
        if (this.controller.isInteractive()) {
            this.setAxisBounds();
        }
    }

    Rectangle getAxisScale() {
        double xmin = this.xAxis.getLowerBound();
        double ymin = this.yAxis.getLowerBound();
        double xmax = this.xAxis.getUpperBound();
        double ymax = this.yAxis.getUpperBound();
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    Rectangle getPlotFrame() {
        Node chartPlotArea = this.controller.getPlotAreaNode();
        if (chartPlotArea == null) {
            return new Rectangle(0.0, 0.0, 0.0, 0.0);
        }
        double w = chartPlotArea.getLayoutBounds().getWidth();
        double h = chartPlotArea.getLayoutBounds().getHeight();
        return new Rectangle(chartPlotArea.getLayoutX(), chartPlotArea.getLayoutY(), w, h);
    }

    private void addDragSelectionMechanism(Node chartRegion) {
        chartRegion.setOnMousePressed(ev -> {
            if (ev.isSecondaryButtonDown()) {
                return;
            }
            if (!this.getChildren().contains((Object)this.selectionRectangle)) {
                this.getChildren().add((Object)this.selectionRectangle);
                this.getChildren().add((Object)this.mirrorRectangle);
            }
            this.selectionRectangle.toFront();
            double offsetX = chartRegion.getLayoutX();
            double offsetY = chartRegion.getLayoutY();
            this.selRectStart = this.computeRectanglePoint(ev.getX() + offsetX, ev.getY() + offsetY);
            ev.consume();
        });
        chartRegion.setOnMouseDragged(ev -> {
            if (ev.isSecondaryButtonDown()) {
                return;
            }
            boolean optionDrag = ev.isAltDown();
            double offsetX = chartRegion.getLayoutX();
            double offsetY = chartRegion.getLayoutY();
            this.selRectEnd = this.computeRectanglePoint(ev.getX() + offsetX, ev.getY() + offsetY);
            Rectangle2D r = this.union(this.selRectStart, this.selRectEnd);
            this.drawSelectionRectangle(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight(), optionDrag, offsetX);
            this.selectionRectangleScaleDef = this.rectDef(this.selectionRectangle, this.getPlotFrame());
            if (this.controller.isInteractive()) {
                this.setAxisBounds();
            }
            ev.consume();
        });
        chartRegion.setOnMouseReleased(ev -> {
            if (this.selRectStart == null || this.selRectEnd == null) {
                this.clearSelection();
                return;
            }
            if (this.isRectangleSizeTooSmall()) {
                this.clearSelection();
                return;
            }
            this.setAxisBounds();
            this.selRectEnd = null;
            this.selRectStart = null;
            this.selectionRectangleScaleDef = this.rectDef(this.selectionRectangle, this.getPlotFrame());
            this.requestFocus();
            ev.consume();
        });
    }

    private void clearSelection() {
        this.selectionRectangle.setWidth(0.0);
        this.selectionRectangle.setHeight(0.0);
        this.setAxisBounds();
    }

    private Point2D computeRectanglePoint(double eventX, double eventY) {
        double lowerBoundX = this.computeOffsetInChart((Node)this.xAxis, false);
        double upperBoundX = lowerBoundX + this.xAxis.getWidth();
        double lowerBoundY = this.computeOffsetInChart((Node)this.yAxis, true);
        double upperBoundY = lowerBoundY + this.yAxis.getHeight();
        double offsetX = 0.0;
        double offsetY = 0.0;
        double x = Math.max(lowerBoundX, Math.min(eventX + offsetX, upperBoundX));
        double y = Math.max(lowerBoundY, Math.min(eventY + offsetY, upperBoundY));
        return new Point2D(x, y);
    }

    private double computeOffsetInChart(Node node, boolean vertical) {
        double offset = 0.0;
        do {
            offset += vertical ? node.getLayoutY() : node.getLayoutX();
        } while ((node = node.getParent()) != null && node != this.scatter);
        return offset;
    }

    public void drawSelectionRectangle(Point2D a, Point2D b, boolean optionDrag) {
        double wid = Math.abs(b.getX() - a.getX());
        double hght = Math.abs(b.getY() - a.getY());
        double x = Math.min(a.getX(), b.getX());
        double y = Math.min(a.getY(), b.getY());
        this.drawSelectionRectangle(x, y, wid, hght, optionDrag, 0.0);
    }

    public void drawSelectionRectangle(double x, double y, double width, double height, boolean optionDrag, double offsetX) {
        this.selectionRectangle.setVisible(true);
        this.set(this.selectionRectangle, x, y, width, height);
        if (optionDrag) {
            Range xRange = this.controller.getXRange();
            if (xRange.min() < 0.0 && xRange.max() > 0.0) {
                double xScale = this.converter.frameToScale(x - offsetX, (XYChart<Number, Number>)this.scatter, false);
                double rightScale = this.converter.frameToScale(x + width - offsetX, (XYChart<Number, Number>)this.scatter, false);
                boolean spans0 = xScale < 0.0 != rightScale < 0.0;
                this.mirrorRectangle.setVisible(!spans0);
                double ghostX = offsetX + this.converter.scaleToFrame(-1.0 * xScale, (XYChart<Number, Number>)this.scatter, false);
                if (xScale >= 0.0) {
                    ghostX -= width;
                }
                if (ghostX < offsetX) {
                    width -= offsetX - ghostX;
                    ghostX = offsetX;
                }
                this.set(this.mirrorRectangle, ghostX, y, width, height);
            }
        } else {
            this.mirrorRectangle.setVisible(false);
        }
        this.drawRegressionLine();
    }

    void set(Rectangle r, double x, double y, double width, double height) {
        r.setX(x);
        r.setY(y);
        r.setWidth(width);
        r.setHeight(height);
    }

    private void drawSelectionRectangleAt(double x, double y, boolean optionDrag, double xOffset) {
        this.drawSelectionRectangle(x, y, this.selectionRectangle.getWidth(), this.selectionRectangle.getHeight(), optionDrag, xOffset);
    }

    private void disableAutoRanging() {
        this.xAxis.setAutoRanging(false);
        this.yAxis.setAutoRanging(false);
    }

    private void showInfo(int found, int total, double xMin, double xMax, double yMin, double yMax) {
        DecimalFormat fmt = new DecimalFormat("0.00");
        String s = found + " / " + total + " in range X: [ " + fmt.format(xMin) + " - " + fmt.format(xMax) + "] Y: [ " + fmt.format(yMin) + " - " + fmt.format(yMax) + "]";
        this.xRange = new Range(xMin, xMax);
        this.yRange = new Range(yMin, yMax);
        this.controller.setStatus(s, this.xRange, this.yRange);
    }

    public void resizedRangeFields() {
    }

    public void setAxisBounds() {
        this.disableAutoRanging();
        if (this.selRectStart == null || this.selRectEnd == null) {
            this.selRectStart = new Point2D(this.selectionRectangle.getX(), this.selectionRectangle.getY() + this.selectionRectangle.getHeight());
            this.selRectEnd = new Point2D(this.selectionRectangle.getX() + this.selectionRectangle.getWidth(), this.selectionRectangle.getY());
        }
        Rectangle bounds = this.getPlotFrame();
        double xBase = bounds.getX();
        double yBase = bounds.getY();
        double selectionMinX = Math.min(this.selRectStart.getX(), this.selRectEnd.getX()) - xBase;
        double selectionMaxX = Math.max(this.selRectStart.getX(), this.selRectEnd.getX()) - xBase;
        double selectionMinY = Math.min(this.selRectStart.getY(), this.selRectEnd.getY()) - yBase;
        double selectionMaxY = Math.max(this.selRectStart.getY(), this.selRectEnd.getY()) - yBase;
        double xMin = this.converter.frameToScale(selectionMinX, (XYChart<Number, Number>)this.scatter, false);
        double xMax = this.converter.frameToScale(selectionMaxX, (XYChart<Number, Number>)this.scatter, false);
        double yMin = this.converter.frameToScale(selectionMaxY, (XYChart<Number, Number>)this.scatter, true);
        double yMax = this.converter.frameToScale(selectionMinY, (XYChart<Number, Number>)this.scatter, true);
        int found = this.countInRect((XYChart<Number, Number>)this.scatter, xMin, xMax, yMin, yMax);
        int total = this.getDataSize((XYChart<Number, Number>)this.scatter);
        String xName = this.xAxis.getLabel();
        String yName = this.yAxis.getLabel();
        this.controller.selectRange(xName, xMin, xMax, yName, yMin, yMax);
        this.showInfo(found, total, xMin, xMax, yMin, yMax);
    }

    private int countInRect(XYChart<Number, Number> chart, double xMin, double xMax, double yMin, double yMax) {
        Objects.requireNonNull(chart);
        if (chart.getData().size() == 0) {
            return 0;
        }
        XYChart.Series data = (XYChart.Series)chart.getData().get(0);
        Objects.requireNonNull(data);
        int ct = 0;
        for (XYChart.Data n : data.getData()) {
            double x = ((Number)n.getXValue()).doubleValue();
            double y = ((Number)n.getYValue()).doubleValue();
            if (!(x >= xMin) || !(x < xMax) || !(y >= yMin) || !(y < yMax)) continue;
            ++ct;
        }
        return ct;
    }

    private int getDataSize(XYChart<Number, Number> chart) {
        if (chart.getData().size() == 0) {
            return 0;
        }
        XYChart.Series data = (XYChart.Series)chart.getData().get(0);
        return data.getData().size();
    }

    void setCursor(Rectangle r, MouseEvent event) {
        Pos pos = RectangleUtil.getPos(event, r);
        r.setCursor(Cursors.getResizeCursor(pos));
    }

    private Rectangle2D union(Point2D a, Point2D b) {
        if (a == null || b == null) {
            return Rectangle2D.EMPTY;
        }
        double x = Math.min(a.getX(), b.getX());
        double y = Math.min(a.getY(), b.getY());
        double width = Math.abs(a.getX() - b.getX());
        double height = Math.abs(a.getY() - b.getY());
        return new Rectangle2D(x, y, width, height);
    }

    Rectangle getScaleRect(Rectangle def, Rectangle frame) {
        double frameWidth = frame.getWidth();
        double frameHeight = frame.getHeight();
        Rectangle scaler = new Rectangle(frame.getX() + def.getX() * frameWidth, frame.getY() + def.getY() * frameHeight, def.getWidth() * frameWidth, def.getHeight() * frameHeight);
        return scaler;
    }

    Rectangle rectDef(Rectangle child, Rectangle frame) {
        double frameWidth = frame.getWidth();
        double frameHeight = frame.getHeight();
        Rectangle r = new Rectangle((child.getX() - frame.getX()) / frameWidth, (child.getY() - frame.getY()) / frameHeight, child.getWidth() / frameWidth, child.getHeight() / frameHeight);
        return r;
    }

    void setRegression(LinearRegression r) {
        this.regressionSlope = r.slope();
        this.regressionIntercept = r.intercept();
        this.regressionCorrelation = r.R2();
    }

    void clearRegression() {
        if (this.regressionLine != null) {
            this.getChildren().remove((Object)this.regressionLine);
        }
        if (this.regressionLabel != null) {
            this.getChildren().remove((Object)this.regressionLabel);
        }
        this.regressionCorrelation = Double.NaN;
        this.regressionIntercept = Double.NaN;
        this.regressionSlope = Double.NaN;
        this.regressionLine = null;
        this.regressionLabel = null;
    }

    double getSlope() {
        return this.regressionSlope;
    }

    double getIntercept() {
        return this.regressionIntercept;
    }

    double getCorrelation() {
        return this.regressionCorrelation;
    }

    private void drawRegressionLine() {
        if (!Double.isNaN(this.regressionSlope)) {
            double xMin = this.xAxis.getLowerBound();
            double xMax = this.xAxis.getUpperBound();
            double yMin = this.yAxis.getLowerBound();
            double yMax = this.yAxis.getUpperBound();
            double y1 = xMin * this.regressionSlope + this.regressionIntercept;
            double y2 = xMax * this.regressionSlope + this.regressionIntercept;
            double x1 = 0.0;
            double x2 = 0.0;
            if (y1 < yMin) {
                x1 = (yMin - this.regressionIntercept) / this.regressionSlope;
                y1 = yMin;
            } else if (y1 > yMax) {
                x1 = (yMax - this.regressionIntercept) / this.regressionSlope;
                y1 = yMax;
            } else {
                x1 = xMin;
            }
            if (y2 < yMin) {
                x2 = (yMin - this.regressionIntercept) / this.regressionSlope;
                y2 = yMin;
            } else if (y2 > yMax) {
                x2 = (yMax - this.regressionIntercept) / this.regressionSlope;
                y2 = yMax;
            } else {
                x2 = xMax;
            }
            double startX = this.converter.scaleToFrame(x1, (XYChart<Number, Number>)this.scatter, false);
            double startY = this.converter.scaleToFrame(y1, (XYChart<Number, Number>)this.scatter, true);
            double endX = this.converter.scaleToFrame(x2, (XYChart<Number, Number>)this.scatter, false);
            double endY = this.converter.scaleToFrame(y2, (XYChart<Number, Number>)this.scatter, true);
            if (this.regressionLine == null) {
                this.regressionLine = new Line();
                this.regressionLabel = new Label();
            } else {
                this.getChildren().remove((Object)this.regressionLine);
                this.getChildren().remove((Object)this.regressionLabel);
            }
            Bounds b = this.controller.getPlotBounds();
            double left = b.getMinX();
            double top = b.getMinY();
            this.regressionLine.setStartX(startX + left);
            this.regressionLine.setStartY(startY + top);
            this.regressionLine.setEndX(endX + left);
            this.regressionLine.setEndY(endY + top);
            this.regressionLine.setOpacity(0.8);
            this.regressionLine.setStroke((Paint)Color.PURPLE);
            this.regressionLine.setStrokeWidth(4.0);
            this.getChildren().add((Object)this.regressionLine);
            String text = String.format("m=%.2f, b=%.2f \n R=%.4f", this.regressionSlope, this.regressionIntercept, this.regressionCorrelation);
            double textWidth = 100.0;
            double offset = 50.0;
            this.regressionLabel.setText(text);
            this.regressionLabel.setTranslateX(endX + left - textWidth);
            this.regressionLabel.setTranslateY(endY + top + (this.regressionSlope > 0.0 ? offset : -offset));
            this.regressionLabel.setVisible(true);
            this.getChildren().add((Object)this.regressionLabel);
        }
    }
}

