/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.charts.twoD;

import java.math.BigDecimal;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import org.cytoscape.cyChart.internal.charts.AbstractChartController;
import org.cytoscape.cyChart.internal.charts.StringUtil;
import org.cytoscape.cyChart.internal.charts.twoD.SelectableScatterChart;
import org.cytoscape.cyChart.internal.model.CyChartManager;
import org.cytoscape.cyChart.internal.model.LinearRegression;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;

public class ScatterChartController
extends AbstractChartController {
    static int DOT_SIZE = 4;
    private SelectableScatterChart scatterChartHome;

    public ScatterChartController(StackPane parent, CyServiceRegistrar reg, CyChartManager mgr) {
        super(parent, reg, true, mgr);
        CyColumn xcol = mgr.getXColumn();
        CyColumn ycol = mgr.getYColumn();
        if (xcol != null) {
            this.xAxisChoices.getSelectionModel().select((Object)xcol.getName());
        } else {
            this.xAxisChoices.getSelectionModel().select(0);
        }
        if (ycol != null) {
            this.yAxisChoices.getSelectionModel().select((Object)ycol.getName());
        } else {
            this.yAxisChoices.getSelectionModel().select(1);
        }
    }

    @Override
    public void setParameters() {
        if (this.chartBox != null) {
            this.curveFit.setSelected(false);
            this.chartBox.getChildren().clear();
            String x = (String)this.xAxisChoices.getSelectionModel().getSelectedItem();
            String y = (String)this.yAxisChoices.getSelectionModel().getSelectedItem();
            if (StringUtil.isEmpty(x) || StringUtil.isEmpty(y)) {
                return;
            }
            XYChart.Series<Number, Number> series1 = this.getDataSeries(x, y);
            this.scatterChartHome = new SelectableScatterChart(this);
            AnchorPane.setLeftAnchor((Node)this.scatterChartHome, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.scatterChartHome, (Double)0.0);
            if (series1 != null) {
                this.scatterChartHome.setDataSeries(series1);
                for (XYChart.Data dataVal : series1.getData()) {
                    StackPane stackPane = (StackPane)dataVal.getNode();
                    if (stackPane == null) continue;
                    stackPane.setPrefSize((double)DOT_SIZE, (double)DOT_SIZE);
                }
            }
            this.scatterChartHome.setAxes(x, y);
            if (this.xAxis == null) {
                this.xAxis = (ValueAxis)this.scatterChartHome.getScatterChart().getXAxis();
            }
            if (this.yAxis == null) {
                this.yAxis = (ValueAxis)this.scatterChartHome.getScatterChart().getYAxis();
            }
            this.logXTransform.setDisable(this.xAxis == null || this.xAxis.getLowerBound() <= 0.0);
            this.logYTransform.setDisable(this.yAxis == null || this.yAxis.getLowerBound() <= 0.0);
            this.setChart((XYChart<Number, Number>)this.scatterChartHome.getScatterChart());
            this.chartBox.getChildren().add((Object)this.scatterChartHome);
            Node legend = this.scatterChartHome.lookup(".chart-legend");
            if (legend != null && legend.isVisible()) {
                legend.setVisible(false);
            }
        }
    }

    private XYChart.Series<Number, Number> getDataSeries(String xName, String yName) {
        this.table = this.manager.getCurrentTable();
        if (this.table == null) {
            return null;
        }
        CyColumn xcol = this.table.getColumn(xName);
        if (xcol == null) {
            return null;
        }
        CyColumn ycol = this.table.getColumn(yName);
        if (ycol == null) {
            return null;
        }
        List<Double> xvalues = this.getColumnValues(xcol);
        List<Double> yvalues = this.getColumnValues(ycol);
        XYChart.Series series = new XYChart.Series();
        series.nameProperty().set((Object)"");
        try {
            ObservableList data = series.getData();
            int size = xvalues.size();
            for (int i = 0; i < size; ++i) {
                Double y;
                Double x = xvalues.get(i);
                if (x == null || (y = yvalues.get(i)) == null) continue;
                if (this.isYLog) {
                    y = -1.0 * this.safelog(y);
                }
                data.add((Object)new XYChart.Data((Object)x, (Object)y));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return series;
    }

    @Override
    public void resized() {
        if (this.scatterChartHome != null) {
            double x = this.xMin.getNumber().doubleValue();
            double y = this.yMin.getNumber().doubleValue();
            double maxX = this.xMax.getNumber().doubleValue();
            double maxY = this.yMax.getNumber().doubleValue();
            CyColumn xcol = this.manager.getXColumn();
            CyColumn ycol = this.manager.getYColumn();
            this.selectRange(xcol, x, maxX, ycol, y, maxY);
            this.modelToView();
        }
    }

    public void selectRange(String xname, double xMin, double xMax, String yname, double yMin, double yMax) {
        this.startX = xMin;
        this.endX = xMax;
        this.startY = yMin;
        this.endY = yMax;
        CyColumn xcol = this.findColumn(xname);
        CyColumn ycol = this.findColumn(yname);
        if (xcol == null || ycol == null) {
            return;
        }
        this.selectRange(xcol, xMin, xMax, ycol, yMin, yMax);
    }

    public void selectRange(CyColumn col, double xMin, double xMax, CyColumn ycol, double yMin, double yMax) {
        if (this.table == null) {
            return;
        }
        int ct = 0;
        List rows = this.table.getAllRows();
        for (CyRow row : rows) {
            boolean selectedX = this.rowMatch(row, col, xMin, xMax);
            boolean selectedY = this.rowMatch(row, ycol, yMin, yMax);
            boolean selected = selectedX && selectedY;
            row.set("selected", (Object)selected);
            if (!selected) continue;
            ++ct;
        }
        this.setStatus(ct + " / " + rows.size());
    }

    private boolean rowMatch(CyRow row, CyColumn col, double xMin, double xMax) {
        if (row == null) {
            return false;
        }
        if (col == null) {
            return false;
        }
        Object val = row.get(col.getName(), col.getType());
        if (val == null) {
            return false;
        }
        if (val instanceof Double) {
            Double v = (Double)val;
            if (this.isXLog) {
                v = this.safelog(v);
            }
            boolean hit = xMin <= v && xMax >= v;
            return hit;
        }
        if (val instanceof Integer) {
            double v = 1.0 * (double)((Integer)val).intValue();
            if (this.isXLog) {
                v = this.safelog(v);
            }
            boolean hit = xMin <= v && xMax >= v;
            return hit;
        }
        return false;
    }

    @Override
    public void fieldEdited(String fldId, BigDecimal newValue) {
        super.fieldEdited(fldId, newValue);
        this.modelToView();
    }

    private void modelToView() {
        this.xColumn = this.manager.getXColumn();
        this.yColumn = this.manager.getYColumn();
        double xMinVal = this.xMin.getNumber().doubleValue();
        double xMaxVal = this.xMax.getNumber().doubleValue();
        double yMinVal = this.yMin.getNumber().doubleValue();
        double yMaxVal = this.yMax.getNumber().doubleValue();
        this.selectRange(this.xColumn, xMinVal, xMaxVal, this.yColumn, yMinVal, yMaxVal);
        Point2D a = new Point2D(xMinVal, yMinVal);
        Point2D b = new Point2D(xMaxVal, yMaxVal);
        Point2D A = this.scaleToFramePt(a);
        Point2D B = this.scaleToFramePt(b);
        this.scatterChartHome.drawSelectionRectangle(A, B, false);
    }

    private Point2D scaleToFramePt(Point2D a) {
        return this.scatterChartHome.getConverter().scaleToFrame(a, (XYChart<Number, Number>)this.scatterChartHome.getScatterChart());
    }

    @Override
    public void resizeRangeFields() {
        if (this.scatterChartHome != null) {
            this.scatterChartHome.resizedRangeFields();
        }
    }

    @Override
    protected void regression(boolean visible) {
        String y;
        if (!visible) {
            this.scatterChartHome.clearRegression();
            return;
        }
        String x = (String)this.xAxisChoices.getSelectionModel().getSelectedItem();
        XYChart.Series<Number, Number> series1 = this.getDataSeries(x, y = (String)this.yAxisChoices.getSelectionModel().getSelectedItem());
        if (series1 == null) {
            return;
        }
        int seriesSize = series1.getData().size();
        double[] X = new double[seriesSize];
        double[] Y = new double[seriesSize];
        for (int i = 0; i < seriesSize; ++i) {
            XYChart.Data d = (XYChart.Data)series1.getData().get(i);
            X[i] = (Double)((Number)d.getXValue());
            Y[i] = (Double)((Number)d.getYValue());
        }
        this.scatterChartHome.setRegression(new LinearRegression(X, Y));
        this.resized();
    }
}

