/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.charts.oneD;

import java.text.DecimalFormat;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import org.cytoscape.cyChart.internal.charts.oneD.FrameScaleConverter;
import org.cytoscape.cyChart.internal.charts.oneD.Histogram1D;
import org.cytoscape.cyChart.internal.charts.oneD.HistogramChartController;
import org.cytoscape.cyChart.internal.model.Range;

public class SubRangeLayer1D {
    private final StackPane stackPane;
    private LineChart<Number, Number> chart;
    private ValueAxis<Number> xAxis;
    private ValueAxis<Number> yAxis;
    double chartOffsetX;
    double chartOffsetY;
    private HistogramChartController controller;
    private Group selectionGroup;
    private Label positionLabel;
    FrameScaleConverter converter = new FrameScaleConverter();
    private double selectionAnchor = -1.0;
    private double selectionMovingEnd = -1.0;
    private static final String STYLE_CLASS_SELECTION_BOX = "chart-selection-rectangle";
    double previousH = -1.0;
    boolean dragging = false;
    int hitSpot;
    private Group groupH = new Group();
    private Line leftBar;
    private Line crossBar;
    private Line rightBar;
    private Rectangle selection;
    int resizing = 0;
    double dragStart = -1.0;
    double SLOP = 9.0;
    double yValue = 0.0;

    public StackPane getPane() {
        return this.stackPane;
    }

    public void clear() {
        this.stackPane.getChildren().clear();
    }

    public boolean isSelectionSizeTooSmall() {
        return 10.0 > Math.abs(this.selectionMovingEnd - this.selectionAnchor);
    }

    public SubRangeLayer1D(LineChart<Number, Number> inChart, StackPane inPane, HistogramChartController ctrol) {
        this.stackPane = inPane;
        this.chart = inChart;
        this.controller = ctrol;
        this.xAxis = (ValueAxis)this.chart.getXAxis();
        this.yAxis = (ValueAxis)this.chart.getYAxis();
        this.selectionGroup = this.getSubRangeGroup();
        this.selectionGroup.setVisible(true);
        this.selectionGroup.setManaged(false);
        this.update(0.0, false);
        this.selectionGroup.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_SELECTION_BOX});
        this.selectionGroup.setStyle("-fx-fillcolor: CYAN; -fx-strokewidth: 4;");
        this.stackPane.getChildren().add((Object)this.selectionGroup);
        this.addDragSelectionMechanism();
        this.addInfoLabel();
        ChangeListener paneSizeListener = (obs, oldV, newV) -> this.chartBoundsChanged();
        this.stackPane.widthProperty().addListener(paneSizeListener);
        this.stackPane.heightProperty().addListener(paneSizeListener);
        this.hideSelection();
    }

    private void addInfoLabel() {
        this.positionLabel = new Label("positionLabel");
        this.stackPane.getChildren().add((Object)this.positionLabel);
        StackPane.setAlignment((Node)this.positionLabel, (Pos)Pos.TOP_RIGHT);
        this.positionLabel.setVisible(false);
    }

    public void showStatus() {
        double xMin = this.controller.getSelectionStart();
        double xMax = this.controller.getSelectionEnd();
        Histogram1D histo = this.controller.getCurrentHistogram();
        int minBin = histo.rangeToBin(xMin);
        int maxBin = histo.rangeToBin(xMax);
        int rangeArea = histo.getArea(minBin, maxBin);
        int totalArea = histo.getArea();
        DecimalFormat fmt = new DecimalFormat("0.00");
        String s = rangeArea + " / " + totalArea + " are between " + fmt.format(xMin) + " and " + fmt.format(xMax);
        Range xRange = new Range(xMin, xMax);
        this.controller.setStatus(s, xRange, null);
    }

    boolean BETWEEN(double a, double min, double max) {
        return a >= min && a <= max;
    }

    private void addDragSelectionMechanism() {
        Node chartPlotArea = this.controller.getPlotAreaNode();
        chartPlotArea.setOnMouseMoved(event -> this.onMouseMoved((MouseEvent)event));
        chartPlotArea.setOnMouseExited(event -> this.positionLabel.setVisible(false));
        chartPlotArea.setOnMousePressed(event -> this.onPressed((MouseEvent)event));
        chartPlotArea.setOnMouseDragged(event -> this.onDragged((MouseEvent)event));
        chartPlotArea.setOnMouseReleased(event -> this.onReleased((MouseEvent)event));
        chartPlotArea.setOnKeyReleased(event -> {});
    }

    private Point2D getPosition(MouseEvent event) {
        double h = event.getX();
        double v = event.getY();
        double x = this.converter.frameToScale(h, (XYChart<Number, Number>)this.chart, false);
        double y = this.converter.frameToScale(v, (XYChart<Number, Number>)this.chart, true);
        return new Point2D(x, y);
    }

    public void reportPosition(MouseEvent event) {
        this.reportPosition(this.getPosition(event));
    }

    public void reportPosition(Point2D pt) {
        this.positionLabel.setText(String.format("%.1f , %.3f ", pt.getX(), pt.getY()));
        this.positionLabel.setVisible(true);
    }

    public void reportRange() {
        if (this.selectionAnchor > 0.0 && this.selectionMovingEnd > 0.0) {
            double min = Math.min(this.selectionAnchor, this.selectionMovingEnd);
            double max = Math.max(this.selectionAnchor, this.selectionMovingEnd);
            double x0 = this.converter.frameToScale(min, (XYChart<Number, Number>)this.chart, false);
            double x1 = this.converter.frameToScale(max, (XYChart<Number, Number>)this.chart, false);
            this.controller.setXRange(new Range(x0, x1));
            String msg = String.format("%.1f - %.1f ", x0, x1);
            this.positionLabel.setText(msg);
            this.positionLabel.setVisible(true);
            this.showStatus();
        } else {
            this.positionLabel.setVisible(false);
        }
    }

    public void dumpPosition(MouseEvent event) {
        Point2D pt = this.getPosition(event);
    }

    private void onMouseMoved(MouseEvent event) {
        double x = event.getX() + this.chartOffsetX;
        this.hitSpot = this.testHit(x);
        Cursor c = Cursor.DEFAULT;
        if (this.selectionGroup.isVisible()) {
            switch (this.hitSpot) {
                case 1: {
                    c = Cursor.H_RESIZE;
                    break;
                }
                case 2: {
                    c = Cursor.OPEN_HAND;
                    break;
                }
                case 3: {
                    c = Cursor.H_RESIZE;
                }
            }
        }
        this.getPane().getScene().setCursor(c);
        this.reportPosition(event);
        event.consume();
    }

    private void onPressed(MouseEvent event) {
        Node chartPlotArea = this.controller.getPlotAreaNode();
        this.chartOffsetX = chartPlotArea.getLayoutX();
        this.chartOffsetY = chartPlotArea.getLayoutY();
        double x = event.getX();
        double y = event.getY();
        if (event.isSecondaryButtonDown()) {
            return;
        }
        double scaleStart = this.controller.getSelectionStart();
        double scaleEnd = this.controller.getSelectionEnd();
        this.selectionAnchor = this.converter.scaleToFrame(this.hitSpot == 1 ? scaleEnd : scaleStart, (XYChart<Number, Number>)this.chart, false);
        this.selectionMovingEnd = this.converter.scaleToFrame(this.hitSpot == 1 ? scaleStart : scaleEnd, (XYChart<Number, Number>)this.chart, false);
        boolean vis = this.selectionGroup.isVisible();
        this.hitSpot = this.testHit(x + this.chartOffsetX);
        double left = Math.min(this.selectionAnchor, this.selectionMovingEnd);
        double right = Math.max(this.selectionAnchor, this.selectionMovingEnd);
        if (vis) {
            this.previousH = x;
            this.dragging = true;
            if (this.hitSpot == 1) {
                this.setSelection(right, x);
            } else if (this.hitSpot == 2) {
                this.setSelection(left, right);
            } else if (this.hitSpot == 3) {
                this.setSelection(left, x);
            } else if (x < this.leftBar.getStartX() - this.SLOP) {
                this.setSelection(x, x - 1.0);
            } else if (x > this.rightBar.getStartX() + this.SLOP) {
                this.setSelection(x + 1.0, x);
            }
        } else {
            this.selectionGroup.setVisible(true);
            this.dragging = true;
            this.setSelection(event.getX() - 2.0, event.getX() + 2.0);
            this.update(y, this.controller.isInteractive());
        }
        event.consume();
    }

    private void setSelection(double anchor, double movingEnd) {
        this.selectionAnchor = anchor;
        this.selectionMovingEnd = movingEnd;
    }

    private void onDragged(MouseEvent event) {
        boolean inVRange;
        boolean inRange;
        Point2D scalePos = this.getPosition(event);
        this.reportPosition(scalePos);
        if (event.isSecondaryButtonDown()) {
            return;
        }
        event.consume();
        if (!this.dragging) {
            return;
        }
        if (this.hitSpot == 0) {
            double curH = event.getX();
            if (curH < this.previousH) {
                this.setSelection(this.previousH, curH);
                this.hitSpot = 1;
            } else {
                this.setSelection(this.previousH, curH);
                this.hitSpot = 3;
            }
        }
        Node chartPlotArea = this.controller.getPlotAreaNode();
        double minAllowed = -1.0;
        double maxAllowed = chartPlotArea.getLayoutX() + chartPlotArea.getBoundsInLocal().getWidth();
        double h = event.getX();
        boolean tooLow = h < minAllowed;
        boolean tooHigh = h > maxAllowed;
        boolean bl = inRange = !tooLow && !tooHigh;
        if (!inRange) {
            return;
        }
        double v = event.getY();
        double minYAllowed = 0.0;
        double maxYAllowed = chartPlotArea.getLayoutBounds().getHeight();
        boolean bl2 = inVRange = v >= minYAllowed && v <= maxYAllowed;
        if (!inVRange) {
            return;
        }
        double delta = h - this.previousH;
        if (delta == 0.0) {
            return;
        }
        if (this.hitSpot == 2) {
            this.offsetSelection(delta);
        } else {
            this.selectionMovingEnd = h;
        }
        this.update(v, this.controller.isInteractive());
        this.reportRange();
        this.previousH = h;
    }

    private void offsetSelection(double delta) {
        Node chartPlotArea = this.controller.getPlotAreaNode();
        double minAllowed = 0.0;
        double maxAllowed = chartPlotArea.getLayoutBounds().getWidth();
        double left = Math.min(this.selectionAnchor, this.selectionMovingEnd) + delta;
        double right = Math.max(this.selectionAnchor, this.selectionMovingEnd) + delta;
        if (left <= minAllowed) {
            this.selectionAnchor = minAllowed;
        } else if (right > maxAllowed) {
            this.selectionAnchor = maxAllowed;
        } else {
            this.selectionAnchor += delta;
            this.selectionMovingEnd += delta;
        }
    }

    private void onReleased(MouseEvent event) {
        boolean inVRange;
        boolean ok;
        if (!this.dragging) {
            return;
        }
        boolean bl = ok = this.selectionAnchor > 0.0 && this.selectionMovingEnd > 0.0;
        if (ok && this.isSelectionSizeTooSmall()) {
            ok = false;
        }
        double width = this.controller.getPlotAreaNode().getBoundsInParent().getWidth();
        double h = Math.max(Math.min(event.getX(), width), 0.0);
        if (this.hitSpot != 2) {
            this.selectionMovingEnd = h;
        }
        double v = event.getY();
        double minYAllowed = 0.0;
        Node chartPlotArea = this.controller.getPlotAreaNode();
        double maxYAllowed = chartPlotArea.getLayoutBounds().getHeight();
        boolean bl2 = inVRange = v >= minYAllowed && v <= maxYAllowed;
        if (!inVRange) {
            return;
        }
        if (ok) {
            this.update(v, true);
            this.reportRange();
            this.setSelection(-1.0, -1.0);
            this.previousH = -1.0;
        }
        this.stackPane.requestFocus();
        this.dragging = false;
        event.consume();
    }

    public void setRangeValues() {
        Range r = this.converter.frameToScaleRange(this.selectionAnchor, this.selectionMovingEnd, (XYChart<Number, Number>)this.chart);
        this.controller.setRangeValues(r);
    }

    public void setRangeValues(double v) {
    }

    public void setRangeValues(double selAnchorH, double selEndH, double v) {
        double x0 = this.converter.frameToScale(selAnchorH, (XYChart<Number, Number>)this.chart, false);
        double x1 = this.converter.frameToScale(selEndH, (XYChart<Number, Number>)this.chart, false);
        double y1 = this.converter.frameToScale(v, (XYChart<Number, Number>)this.chart, true);
        this.controller.setRangeValues(x0, x1, y1, y1);
        this.controller.selectRange(this.xAxis.getLabel(), x0, x1);
    }

    private void disableAutoRanging() {
        this.xAxis.setAutoRanging(false);
        this.yAxis.setAutoRanging(false);
    }

    public void chartBoundsChanged() {
        this.disableAutoRanging();
        if (this.selectionAnchor < 0.0 || this.selectionMovingEnd < 0.0) {
            this.selectionAnchor = this.selectionGroup.getLayoutX();
            this.selectionMovingEnd = this.selectionGroup.getLayoutX() + this.selectionGroup.getBoundsInLocal().getWidth();
        }
        boolean legalRange = false;
        double xMin = this.controller.getSelectionStart();
        double xMax = this.controller.getSelectionEnd();
        if (Double.isNaN(xMin) || Double.isNaN(xMax)) {
            return;
        }
        if (Double.isInfinite(xMin) || Double.isInfinite(xMax)) {
            return;
        }
        legalRange = xMax > xMin;
        double h0 = this.converter.scaleToFrame(xMin, (XYChart<Number, Number>)this.chart, false);
        double h1 = this.converter.scaleToFrame(xMax, (XYChart<Number, Number>)this.chart, false);
        double v0 = this.converter.scaleToFrame(this.controller.getSelectionTop(), (XYChart<Number, Number>)this.chart, true);
        if (this.hitSpot == 1) {
            this.setSelection(h1, h0);
        } else {
            this.setSelection(h0, h1);
        }
        this.selectionGroup.setVisible(legalRange);
        this.update(v0, false);
    }

    private int getRangeCount(XYChart<Number, Number> chart, double xMin, double xMax) {
        int ct = 0;
        ObservableList dataList = chart.getData();
        if (dataList == null || dataList.isEmpty()) {
            return 0;
        }
        XYChart.Series data = (XYChart.Series)dataList.get(0);
        if (data.getData().isEmpty()) {
            return 0;
        }
        for (XYChart.Data n : data.getData()) {
            double x = ((Number)n.getXValue()).doubleValue();
            if (!this.BETWEEN(x, xMin, xMax)) continue;
            ++ct;
        }
        return ct;
    }

    public void hideSelection() {
        this.selectionMovingEnd = -1.0;
        this.selectionAnchor = -1.0;
        this.selectionGroup.setVisible(false);
    }

    public double getYValue() {
        return this.yValue;
    }

    public Group getSubRangeGroup() {
        this.leftBar = new Line(20.0, 10.0, 20.0, 399.0);
        this.crossBar = new Line(20.0, 100.0, 220.0, 100.0);
        this.rightBar = new Line(220.0, 10.0, 220.0, 399.0);
        this.selection = new Rectangle(20.0, 100.0, 220.0, 100.0);
        Color c = Color.CYAN;
        this.leftBar.setStrokeWidth(2.0);
        this.leftBar.setStroke((Paint)c);
        this.crossBar.setStrokeWidth(4.0);
        this.crossBar.setStroke((Paint)c);
        this.rightBar.setStrokeWidth(2.0);
        this.rightBar.setStroke((Paint)c);
        if (this.selection != null) {
            this.selection.setStrokeWidth(4.0);
            this.selection.setStroke((Paint)c);
            this.selection.setFill((Paint)c);
        }
        this.groupH.getChildren().clear();
        this.groupH.getChildren().addAll((Object[])new Node[]{this.leftBar, this.crossBar, this.rightBar});
        if (this.selection != null) {
            this.groupH.getChildren().add((Object)this.selection);
        }
        this.groupH.setOpacity(0.25);
        this.groupH.setMouseTransparent(true);
        return this.groupH;
    }

    public void update(double v, boolean interactive) {
        Bounds bounds = this.controller.getPlotBounds();
        double offX = bounds.getMinX() + 6.0;
        double offY = bounds.getMinY();
        double top = 14.0;
        double bottom = top + bounds.getHeight();
        double vMargin = 12.0;
        v = this.pinValue(vMargin, bottom - vMargin, v);
        double left = 0.0;
        double right = left + bounds.getWidth();
        this.selectionMovingEnd = this.pinValue(left, right, this.selectionMovingEnd);
        double a1 = this.selectionAnchor;
        double a2 = this.selectionMovingEnd;
        double x1 = offX + Math.min(a1, a2);
        double x2 = offX + Math.max(a1, a2);
        double y = v + offY;
        this.setLine(this.leftBar, x1, top, x1, bottom);
        this.setLine(this.rightBar, x2, top, x2, bottom);
        this.setLine(this.crossBar, x1, y, x2, y);
        this.selection.setX(x1);
        this.selection.setLayoutY(top - 100.0);
        this.selection.setWidth(x2 - x1);
        this.selection.setHeight(bottom - top - 6.0);
        double min = Math.min(this.selectionAnchor, this.selectionMovingEnd);
        double max = Math.max(this.selectionAnchor, this.selectionMovingEnd);
        if (interactive) {
            this.setRangeValues(min, max, v);
        }
    }

    private void setLine(Line bar, double x1, double y1, double x2, double y2) {
        bar.setStartX(x1);
        bar.setStartY(y1);
        bar.setEndX(x2);
        bar.setEndY(y2);
    }

    private double pinValue(double top, double bottom, double v) {
        return Math.min(Math.max(v, top), bottom);
    }

    public int testHit(double x) {
        if (this.leftBar == null || this.rightBar == null) {
            return 0;
        }
        if (Math.abs(x - this.leftBar.getStartX()) < this.SLOP) {
            return 1;
        }
        if (Math.abs(x - this.rightBar.getStartX()) < this.SLOP) {
            return 3;
        }
        if (x > this.leftBar.getStartX() && x < this.rightBar.getStartX()) {
            return 2;
        }
        return 0;
    }
}

