/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.charts.oneD;

import java.math.BigDecimal;
import java.util.ArrayList;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.cytoscape.cyChart.internal.FilterBuilder;
import org.cytoscape.cyChart.internal.charts.AbstractChartController;
import org.cytoscape.cyChart.internal.charts.StringUtil;
import org.cytoscape.cyChart.internal.charts.oneD.Histogram1D;
import org.cytoscape.cyChart.internal.charts.oneD.SubRangeLayer1D;
import org.cytoscape.cyChart.internal.model.CyChartManager;
import org.cytoscape.cyChart.internal.model.LinearRegression;
import org.cytoscape.cyChart.internal.model.LogarithmicAxis;
import org.cytoscape.cyChart.internal.model.Range;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;

public class HistogramChartController
extends AbstractChartController {
    private static final int INTERACTIVE = 500;
    private LineChart<Number, Number> histogramChart;
    private SubRangeLayer1D subrangeLayer;
    private Histogram1D histogram;
    boolean verbose = false;

    public Histogram1D getCurrentHistogram() {
        return this.histogram;
    }

    public HistogramChartController(StackPane parent, CyServiceRegistrar reg, CyChartManager mgr) {
        super(parent, reg, false, mgr);
    }

    @Override
    protected void makeFilter() {
        if (this.registrar != null) {
            String x = (String)this.xAxisChoices.getSelectionModel().getSelectedItem();
            FilterBuilder builder = new FilterBuilder(x, new Range(this.startX, this.endX));
            builder.makeSingleFilter(this.registrar);
            this.selectFilterPanel();
        }
    }

    @Override
    public void setParameters() {
        this.setXParameter((String)this.xAxisChoices.getSelectionModel().getSelectedItem());
    }

    private void setXParameter(String name) {
        this.xColumn = this.findColumn(name);
        if (this.xColumn == null) {
            this.noHistogram();
            return;
        }
        this.histogram = this.getHistogram(name, this.isXLog);
        if (this.histogram == null) {
            this.noHistogram();
            return;
        }
        this.chartBox.getChildren().clear();
        if (this.subrangeLayer != null) {
            this.subrangeLayer.hideSelection();
        }
        if (this.isXLog) {
            this.logXTransform.setSelected(false);
            return;
        }
        this.xAxis = this.isXLog ? new LogarithmicAxis() : new NumberAxis();
        this.xAxis.setLabel(name);
        this.yAxis = new NumberAxis();
        this.histogramChart = new LineChart((Axis)this.xAxis, (Axis)this.yAxis);
        this.histogramChart.setCreateSymbols(false);
        this.anchor((Node)this.histogramChart);
        this.setChart((XYChart<Number, Number>)this.histogramChart);
        this.chartBox.getChildren().add(this.histogramChart);
        this.subrangeLayer = new SubRangeLayer1D(this.histogramChart, this.chartContainer, this);
        Node chartPlotArea = this.getPlotAreaNode();
        String rootStr = ".root {\n    -fx-font-size: 24pt;\n -fx-font-family: \"Courier New\";\n -fx-base: rgb(132, 145, 47);\n   -fx-background: rgb(240, 240, 240);\n -fx-legend-visible: false; }";
        if (chartPlotArea != null) {
            Region rgn = (Region)chartPlotArea;
            rgn.setStyle(".root { -fx-background-color: #F8F0F8;  -fx-legend-visible: false; }");
        }
        this.histogramChart.setStyle(rootStr);
        Group groupH = this.subrangeLayer.getSubRangeGroup();
        Bounds bounds = this.getPlotAreaNode().getBoundsInParent();
        groupH.setTranslateX(bounds.getMinX());
        groupH.setTranslateY(36.0);
        if (StringUtil.isEmpty(name)) {
            return;
        }
        if (this.histogram == null) {
            return;
        }
        Range histoRange = this.histogram.getRange();
        this.histogramChart.getData().clear();
        boolean isInt = this.xColumn != null && this.xColumn.getType().equals(Integer.class);
        double area = isInt ? 1.0 : (double)this.histogram.getArea();
        XYChart.Series<Number, Number> data = this.histogram.getDataSeries(name, 0.0, area);
        this.histogramChart.getData().add(data);
        int minX = (int)histoRange.min();
        int maxX = (int)histoRange.max();
        this.xAxis.setLowerBound((double)minX);
        this.xAxis.setUpperBound((double)maxX);
        boolean disableLog = histoRange.contains(0.0);
        this.logXTransform.setDisable(disableLog);
        this.yAxis.setLowerBound(0.0);
        double top = this.histogram.getMode();
        if (!isInt) {
            top = 0.5 * top / (double)this.histogram.getSize();
        }
        this.yAxis.setUpperBound(top);
        int size = this.getDataSize();
        this.interactive.setSelected(size > 0 && size < 500);
        boolean showRegression = this.curveFit.isSelected();
        if (showRegression) {
            ArrayList<Double> xs = new ArrayList<Double>();
            ArrayList<Double> ys = new ArrayList<Double>();
            for (int i = minX; i < maxX; ++i) {
                double count = this.histogram.get(i);
                if (count <= 0.0) continue;
                xs.add(Double.valueOf(i));
                ys.add(Math.log(count));
                if (!this.verbose) continue;
                System.out.println(Double.valueOf(i) + "\t" + count);
            }
            LinearRegression foo = new LinearRegression(xs, ys);
            if (this.verbose) {
                System.out.println(foo.toString());
            }
            XYChart.Series regression = new XYChart.Series();
            this.histogramChart.getData().add((Object)regression);
            regression.nameProperty().set((Object)"Log Regression");
            for (int i = minX; i < maxX; ++i) {
                double xi = i;
                double yi = foo.predict(xi);
                double powx = Math.pow(Math.E, xi);
                double powy = Math.pow(Math.E, yi);
                if (this.verbose) {
                    System.out.println(" -> " + xi + ", " + powy + " - " + yi);
                }
                regression.getData().add((Object)new XYChart.Data((Object)xi, (Object)powy));
            }
        }
    }

    private void noHistogram() {
        this.logXTransform.setDisable(true);
        this.xMin.setDisable(true);
        this.xMax.setDisable(true);
    }

    private Histogram1D getHistogram(String item, Boolean isLog) {
        try {
            this.table = this.manager.getCurrentTable();
            ArrayList<Double> values = null;
            CyColumn column = this.table.getColumn(item);
            if (column == null) {
                System.err.println("column is null for " + item);
                return null;
            }
            if (column.getType() == Double.class) {
                values = this.table.getColumn(item).getValues(Double.class);
                if (values == null || values.isEmpty()) {
                    return null;
                }
                if (isLog.booleanValue()) {
                    for (int i = 0; i < values.size(); ++i) {
                        Double dub = (Double)values.get(i);
                        if (dub == null) continue;
                        values.set(i, this.safelog(dub));
                    }
                }
                return new Histogram1D(item, values);
            }
            if (column.getType() == Integer.class) {
                int min = Integer.MAX_VALUE;
                int max = Integer.MIN_VALUE;
                values = new ArrayList<Double>();
                for (Integer i : column.getValues(Integer.class)) {
                    if (i == null) continue;
                    if (i < min) {
                        min = i;
                    }
                    if (i > max) {
                        max = i;
                    }
                    double d = isLog != false ? this.safelog(i.intValue()) : new Double(i.intValue()).doubleValue();
                    values.add(d);
                }
                Range r = new Range(min, max);
                Histogram1D hi = new Histogram1D(item, r, max - min + 1);
                for (Integer i : column.getValues(Integer.class)) {
                    hi.count(i.intValue());
                }
                return hi;
            }
        }
        catch (Exception ex) {
            System.err.println("Exception " + ex.toString());
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public void resized() {
        if (this.subrangeLayer != null) {
            this.subrangeLayer.chartBoundsChanged();
            this.setStatus("");
        }
    }

    @Override
    protected void regression(boolean vis) {
        this.setParameters();
    }

    boolean inBounds(double x) {
        double low = this.xAxis.getLowerBound();
        double up = this.xAxis.getUpperBound();
        return x >= low && x <= up;
    }

    public void selectRange(String name, double xMin, double xMax) {
        CyColumn col;
        if (name == null) {
            name = this.xAxis.getLabel();
        }
        if ((col = this.findColumn(name)) != null) {
            this.selectRange(col, xMin, xMax);
        }
    }

    public void selectRange(CyColumn col, double xMin, double xMax) {
        for (CyRow row : this.table.getAllRows()) {
            boolean selected = this.rowMatch(row, col, xMin, xMax);
            row.set("selected", (Object)selected);
        }
    }

    private boolean rowMatch(CyRow row, CyColumn col, double xMin, double xMax) {
        if (row == null) {
            System.err.println("row is null");
            return false;
        }
        if (col == null) {
            System.err.println("col is null");
            return false;
        }
        Object val = row.get(col.getName(), col.getType());
        if (val == null) {
            return false;
        }
        if (val instanceof Double) {
            double v = (Double)val;
            if (this.isXLog) {
                v = this.safelog(v);
            }
            boolean hit = xMin <= v && xMax >= v;
            return hit;
        }
        if (val instanceof Integer) {
            Integer i = (Integer)val;
            double d = i.intValue();
            if (this.isXLog) {
                d = this.safelog(d);
            }
            boolean hit = xMin <= d && xMax >= d;
            return hit;
        }
        return false;
    }

    @Override
    public void fieldEdited(String fldId, BigDecimal newValue) {
        super.fieldEdited(fldId, newValue);
        this.subrangeLayer.chartBoundsChanged();
        this.subrangeLayer.reportRange();
    }

    @Override
    public void resizeRangeFields() {
        if (this.subrangeLayer != null) {
            this.subrangeLayer.reportRange();
            this.subrangeLayer.chartBoundsChanged();
        }
    }
}

