/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.charts;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.input.KeyEvent;
import javafx.scene.paint.Color;

public class StringUtil {
    private static int counter = 0;
    List<TYPES> types = new ArrayList<TYPES>();
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\\s*\\n\\s*");
    static char DEC_PT = (char)46;

    public static String inject(String full, String after, String until, String insert) {
        int idx1 = full.indexOf(after) + after.length();
        int idx2 = full.indexOf(until, idx1);
        return full.substring(0, idx1) + insert + full.substring(idx2);
    }

    public static String insertAt(String full, int index, String insert) {
        return full.substring(0, index) + insert + full.substring(index);
    }

    public static String chopExtension(String in) {
        int idx = in.lastIndexOf(".");
        return idx < 0 ? in : in.substring(0, idx);
    }

    public static String chopLast(String in) {
        return in.substring(0, in.length() - 1);
    }

    public static String chopLast2(String in) {
        return in.substring(0, in.length() - 2);
    }

    public static void launchURL(String urlString) {
        try {
            Desktop.getDesktop().browse(new URI(urlString));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String callURL(String urlString, boolean addNL) {
        StringBuilder buffer = new StringBuilder();
        try {
            String eol;
            URL url = new URL(urlString);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            String strTemp = "";
            String string = eol = addNL ? "\n" : "";
            while (null != (strTemp = br.readLine())) {
                buffer.append(strTemp).append(eol);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(urlString + " failed to load");
        }
        return buffer.toString();
    }

    public static boolean isEmpty(TYPES t) {
        return t == TYPES.EMPTY;
    }

    public static boolean isString(TYPES t) {
        return t == TYPES.STRING;
    }

    public static boolean isNumber(TYPES t) {
        return t == TYPES.DOUBLE;
    }

    public static boolean iColor(TYPES t) {
        return t == TYPES.COLOR;
    }

    public static boolean iBool(TYPES t) {
        return t == TYPES.BOOLEAN;
    }

    public static TYPES inferType(String s) {
        if (s.isEmpty()) {
            return TYPES.EMPTY;
        }
        if (StringUtil.isColor(s)) {
            return TYPES.COLOR;
        }
        if (StringUtil.isDate(s)) {
            return TYPES.DATE;
        }
        if (StringUtil.isNumber(s)) {
            return TYPES.DOUBLE;
        }
        if (StringUtil.isBool(s)) {
            return TYPES.BOOLEAN;
        }
        return TYPES.STRING;
    }

    public static String gensym() {
        return (counter++ + "." + Math.random()).substring(0, 8);
    }

    public static String decapitalize(String s) {
        return s.substring(0, 1) + s.substring(1).toLowerCase();
    }

    public static List<TYPES> inferTypes(String[] s) {
        ArrayList<TYPES> types = new ArrayList<TYPES>();
        for (String str : s) {
            types.add(StringUtil.inferType(str));
        }
        return types;
    }

    public static boolean isBool(String s) {
        if (s.length() > 5) {
            return false;
        }
        return "true".equals(s.toLowerCase()) || "false".equals(s.toLowerCase());
    }

    public static boolean isColor(String s) {
        if (s == null) {
            return false;
        }
        try {
            Color color = Color.web((String)s);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean isDate(String s) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE;
            LocalDate.parse(s, formatter);
            return true;
        }
        catch (DateTimeParseException formatter) {
            String[] sections = s.split("/");
            if (sections.length == 3) {
                int mon = StringUtil.toInteger(sections[0]);
                if (!StringUtil.inclRange(mon, 1, 12)) {
                    return false;
                }
                int day = StringUtil.toInteger(sections[1]);
                if (!StringUtil.inclRange(day, 1, 31)) {
                    return false;
                }
                int yr = StringUtil.toInteger(sections[2]);
                if (StringUtil.inclRange(yr, 0, 50) || StringUtil.inclRange(yr, 2000, 2050)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static boolean isValidIPAddress(String s) {
        String[] sections = s.split("\\.");
        int len = sections.length;
        if (len == 4 || len == 6) {
            for (String section : sections) {
                if (StringUtil.isNumber(section)) {
                    int num = StringUtil.toInteger(section);
                    if (StringUtil.inclRange(num, 0, 255)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean inclRange(int num, int i, int j) {
        return num >= i && num <= j;
    }

    public static boolean isInteger(String s) {
        return StringUtil.isNumber(s) && s.indexOf(".") < 0;
    }

    public static boolean isNumber(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static double toDouble(String s) {
        if (s == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static int toInteger(String s) {
        if (s == null) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int toInteger(String s, int deflt) {
        if (StringUtil.isEmpty(s)) {
            return deflt;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return deflt;
        }
    }

    static char getChar(KeyEvent ev) {
        String s = ev.getCharacter();
        if (s.isEmpty()) {
            return '\u001a';
        }
        return s.charAt(0);
    }

    public static boolean hasText(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean isEmpty(String s) {
        return !StringUtil.hasText(s);
    }

    public static boolean anyEmpty(String ... s) {
        for (String a : s) {
            if (!StringUtil.isEmpty(a)) continue;
            return true;
        }
        return false;
    }

    public static String capitalize(String s) {
        if (s != null && s.length() > 0) {
            char[] chars = s.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars).intern();
        }
        return s;
    }

    public static String toPropertyExpression(String s) {
        char[] chars = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        char previousChar = ' ';
        for (char aChar : chars) {
            if (aChar != '_') {
                if (previousChar == '_') {
                    sb.append(Character.toUpperCase(aChar));
                } else {
                    sb.append(Character.toLowerCase(aChar));
                }
            }
            previousChar = aChar;
        }
        return sb.toString();
    }

    public static String toUnderscoreCase(String s) {
        char[] chars = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        char previousChar = '\u0000';
        for (char aChar : chars) {
            if (Character.isUpperCase(aChar)) {
                if (previousChar != '\u0000') {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(aChar));
            } else {
                sb.append(aChar);
            }
            previousChar = aChar;
        }
        return sb.toString();
    }

    public static String join(String delimiter, Object ... elements) {
        StringBuilder sb = new StringBuilder();
        for (Object part : elements) {
            if (part == null) continue;
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(part.toString());
        }
        return sb.toString();
    }

    public static String join(String delimiter, Collection<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        return StringUtil.join(delimiter, elements.toArray(new Object[elements.size()]));
    }

    public static String toSingleLineString(Object object) {
        if (object != null) {
            String s = object.toString().trim();
            Matcher matcher = LINE_BREAK_PATTERN.matcher(s);
            return matcher.replaceAll(" \\\\ ");
        }
        return null;
    }

    public static String stripQuotes(String string) {
        return string.trim().replaceAll("\"", "");
    }

    public static Object singleQuote(String content) {
        return "'" + content.replaceAll("'", "") + "'";
    }

    public static String getSuperscript(char input) {
        switch (input) {
            case '0': {
                return "\u2070";
            }
            case '1': {
                return "\u00b9";
            }
            case '2': {
                return "\u00b2";
            }
            case '3': {
                return "\u00b3";
            }
            case '4': {
                return "\u2074";
            }
            case '5': {
                return "\u2075";
            }
            case '6': {
                return "\u2076";
            }
            case '7': {
                return "\u2077";
            }
            case '8': {
                return "\u2078";
            }
            case '9': {
                return "\u2079";
            }
        }
        return "";
    }

    public static String beforeColon(String rawString) {
        int idx = rawString.indexOf(":");
        if (idx < 0) {
            return rawString;
        }
        return rawString.substring(0, idx).trim();
    }

    public static String afterColon(String rawString) {
        int idx = rawString.indexOf(":");
        if (idx < 0) {
            return "";
        }
        return rawString.substring(idx + 1).trim();
    }

    public static String clearQuotes(String s) {
        String t = s.trim();
        if (t.startsWith("\"") && t.endsWith("\"")) {
            return t.substring(1, t.length() - 2);
        }
        return t;
    }

    public static String asciiWrap(String inputStr, int lineLen) {
        if (inputStr == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        int curLineStart = 0;
        int inputLen = inputStr.length();
        int idx = 0;
        int prevSpace = 0;
        while (idx < inputLen) {
            int nextSpace = inputStr.indexOf(32, idx);
            if (nextSpace < 0) {
                out.append(inputStr.substring(prevSpace)).append("\n");
                idx = inputLen;
                continue;
            }
            if (nextSpace - curLineStart > lineLen) {
                out.append(inputStr.substring(curLineStart, prevSpace)).append("\n");
                prevSpace = curLineStart = prevSpace + 1;
                idx = curLineStart;
                continue;
            }
            prevSpace = nextSpace;
            idx = nextSpace + 1;
        }
        return out.toString();
    }

    public static String firstWord(String value) {
        int idx = value.indexOf(32);
        if (idx < 0) {
            return value;
        }
        return value.substring(0, idx);
    }

    public static Integer readClosestInt(String string) {
        if (!StringUtil.isNumber(string)) {
            return 0;
        }
        if (StringUtil.isInteger(string)) {
            return StringUtil.toInteger(string);
        }
        return (int)(StringUtil.toDouble(string) + 0.5);
    }

    public static String readTag(String markup, String tagName) {
        String result = "";
        int idx = markup.indexOf(tagName);
        int idx2 = markup.indexOf(tagName, idx + 1);
        if (idx > 0 && idx2 > 0) {
            int start = 1 + markup.indexOf(">", idx + tagName.length());
            int end = idx2 - 2;
            result = markup.substring(start, end);
        }
        return result;
    }

    public static enum TYPES {
        EMPTY,
        BOOLEAN,
        DATE,
        DOUBLE,
        STRING,
        COLOR;

    }
}

