/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.charts;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.FileChooser;
import javax.imageio.ImageIO;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.cyChart.internal.FilterBuilder;
import org.cytoscape.cyChart.internal.model.CyChartManager;
import org.cytoscape.cyChart.internal.model.Range;
import org.cytoscape.cyChart.internal.view.Borders;
import org.cytoscape.cyChart.internal.view.NumberField;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;

public abstract class AbstractChartController
implements SetCurrentNetworkListener {
    protected CyApplicationManager applicationManager = null;
    protected CyServiceRegistrar registrar;
    protected CyNetwork myNetwork = null;
    protected CyChartManager manager;
    protected CyTable table;
    protected NumberField xMin;
    protected NumberField xMax;
    protected NumberField yMin;
    protected NumberField yMax;
    protected Label statusLabel = new Label();
    protected CyColumn xColumn;
    protected CyColumn yColumn;
    protected AnchorPane chartBox;
    protected StackPane chartContainer;
    protected ChoiceBox<String> xAxisChoices;
    protected CheckBox logXTransform;
    protected ChoiceBox<String> yAxisChoices;
    protected CheckBox logYTransform;
    protected CheckBox interactive;
    protected ValueAxis<Number> xAxis;
    protected ValueAxis<Number> yAxis;
    protected XYChart<Number, Number> theChart;
    protected HBox header1;
    protected HBox footer1;
    protected HBox footer2;
    protected HBox footer3;
    static Font numberFont = new Font("SansSerif", 10.0);
    Label tip = new Label("");
    StackPane parentStackPane;
    protected Button makeFilter;
    protected Button copyImage;
    protected CheckBox curveFit;
    protected boolean isXLog = false;
    protected boolean isYLog = false;
    protected double startX;
    protected double endX;
    protected double startY;
    protected double endY;

    public boolean isInteractive() {
        return this.interactive.isSelected();
    }

    public void setChart(XYChart<Number, Number> c) {
        this.theChart = c;
    }

    protected XYChart<Number, Number> getChart() {
        return this.theChart;
    }

    public Node getPlotAreaNode() {
        return this.theChart == null ? null : this.theChart.lookup(".chart-plot-background");
    }

    public Bounds getPlotBounds() {
        return this.theChart == null ? null : this.getPlotAreaNode().getBoundsInParent();
    }

    public int getDataSize() {
        if (this.theChart == null) {
            return 0;
        }
        ObservableList data = this.theChart.getData();
        if (data.size() == 0) {
            return 0;
        }
        XYChart.Series series = (XYChart.Series)data.get(0);
        if (series == null) {
            return 0;
        }
        return series.getData().size();
    }

    public abstract void setParameters();

    public AbstractChartController(StackPane parent, CyServiceRegistrar reg, boolean is2D, CyChartManager mgr) {
        this.chartContainer = parent;
        this.manager = mgr;
        if (reg == null) {
            this.applicationManager = null;
            this.table = null;
        } else {
            this.registrar = reg;
            this.applicationManager = (CyApplicationManager)this.registrar.getService(CyApplicationManager.class);
            this.table = this.manager.getCurrentTable();
            this.myNetwork = this.applicationManager.getCurrentNetwork();
        }
        HBox top = this.makeHeader(is2D);
        this.chartBox = new AnchorPane();
        this.anchor((Node)this.chartBox);
        VBox bottom = this.makeFooter(is2D);
        BorderPane page = new BorderPane();
        page.setTop((Node)top);
        page.setCenter((Node)this.chartBox);
        page.setBottom((Node)bottom);
        bottom.setPadding(new Insets(2.0, 10.0, 2.0, 10.0));
        parent.getChildren().add((Object)page);
        this.anchor((Node)parent);
        this.xColumn = this.manager.getXColumn();
        this.yColumn = this.manager.getYColumn();
        this.initialize();
        this.parentStackPane = parent;
        this.parentStackPane.getChildren().add((Object)this.tip);
        this.tip.setVisible(false);
    }

    public void handleEvent(SetCurrentNetworkEvent e) {
        CyNetwork currentNet = ((CyApplicationManager)e.getSource()).getCurrentNetwork();
        boolean active = currentNet == null ? false : currentNet == this.myNetwork;
        this.parentStackPane.setDisable(!active);
        this.parentStackPane.setOpacity(active ? 1.0 : 0.5);
        Platform.runLater(() -> {
            Object s = "This window is disabled \nbecause no network is active.";
            if (currentNet != null) {
                CyTable networkTable = this.myNetwork.getDefaultNetworkTable();
                String title = networkTable == null ? "this" : currentNet.getDefaultNetworkTable().getTitle();
                s = "This window is disabled because " + title + "\nis not the active network.";
            }
            this.tip.setText((String)s);
            this.tip.setVisible(!active);
        });
    }

    public String getTitle() {
        CyTable networkTable;
        String title = "Untitled";
        CyTable table = this.manager.getCurrentTable();
        if (table != null) {
            title = table.getTitle();
        } else if (this.myNetwork != null && (networkTable = this.myNetwork.getDefaultNetworkTable()) != null) {
            title = this.myNetwork.getDefaultNetworkTable().getTitle();
        }
        return title;
    }

    public void initialize() {
        assert (this.chartContainer != null);
        ChangeListener<Number> xListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> obs, Number oldV, Number newV) {
                AbstractChartController.this.setXParameters(newV);
            }
        };
        ChangeListener<Number> yListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> obs, Number oldV, Number newV) {
                AbstractChartController.this.setYParameters(newV);
            }
        };
        this.populateColumnChoices();
        int xIndex = 0;
        SingleSelectionModel xSelector = this.xAxisChoices.getSelectionModel();
        SingleSelectionModel ySelector = this.yAxisChoices.getSelectionModel();
        if (this.xColumn != null) {
            xSelector.select((Object)this.xColumn.getName());
        } else {
            xSelector.select(xIndex);
        }
        if (this.yColumn == null) {
            ySelector.select(1);
            this.manager.setYColumnName((String)ySelector.getSelectedItem());
        } else {
            ySelector.select((Object)this.yColumn.getName());
        }
        this.setParameters();
        xSelector.selectedIndexProperty().addListener((ChangeListener)xListener);
        ySelector.selectedIndexProperty().addListener((ChangeListener)yListener);
        this.registrar.registerService((Object)this, SetCurrentNetworkListener.class, new Properties());
    }

    public void unregister() {
        this.registrar.unregisterService((Object)this, SetCurrentNetworkListener.class);
    }

    private HBox makeHeader(boolean is2D) {
        this.makeFilter = new Button("Create Filter");
        this.makeFilter.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AbstractChartController.this.makeFilter();
            }
        });
        this.copyImage = new Button("Export Image...");
        this.copyImage.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AbstractChartController.this.snapshot();
            }
        });
        this.interactive = new CheckBox("Interactive");
        this.interactive.setAlignment(Pos.CENTER);
        this.interactive.setTranslateY(4.0);
        this.curveFit = new CheckBox("Regression");
        ChangeListener<Boolean> regressCheckChange = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean val) {
                AbstractChartController.this.regression(val);
            }
        };
        this.curveFit.selectedProperty().addListener((ChangeListener)regressCheckChange);
        this.curveFit.setTranslateY(4.0);
        this.header1 = new HBox(8.0, new Node[]{this.makeFilter, this.copyImage, this.interactive, this.curveFit});
        this.header1.setMinHeight(30.0);
        this.header1.setMaxHeight(30.0);
        this.header1.setBorder(Borders.emptyBorder);
        AnchorPane.setLeftAnchor((Node)this.header1, (Double)12.0);
        return this.header1;
    }

    private VBox makeFooter(boolean is2D) {
        this.xAxisChoices = new ChoiceBox();
        ChangeListener<Boolean> logXChange = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                AbstractChartController.this.setLogXDistribution(new_val);
            }
        };
        this.logXTransform = new CheckBox("Log");
        this.logXTransform.selectedProperty().addListener((ChangeListener)logXChange);
        this.logXTransform.setAlignment(Pos.CENTER);
        this.logXTransform.setDisable(false);
        this.logXTransform.setVisible(true);
        this.xMin = this.makeNumberField("xMin");
        this.xMax = this.makeNumberField("xMax");
        this.yAxisChoices = new ChoiceBox();
        ChangeListener<Boolean> logYChange = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                AbstractChartController.this.setLogYDistribution(new_val);
            }
        };
        this.logYTransform = new CheckBox("Log");
        this.logYTransform.selectedProperty().addListener((ChangeListener)logYChange);
        this.logYTransform.setAlignment(Pos.CENTER);
        this.logYTransform.setDisable(false);
        this.logYTransform.setVisible(true);
        this.yMin = this.makeNumberField("yMin");
        this.yMax = this.makeNumberField("yMax");
        this.footer1 = this.makeNumberRangeLine(this.xAxisChoices, this.logXTransform, this.xMin, this.xMax);
        this.footer2 = this.makeNumberRangeLine(this.yAxisChoices, this.logYTransform, this.yMin, this.yMax);
        this.footer3 = new HBox(new Node[]{this.statusLabel});
        VBox bottom = new VBox();
        ObservableList children = bottom.getChildren();
        children.add(this.footer1);
        if (is2D) {
            children.add(this.footer2);
        }
        children.add(this.footer3);
        return bottom;
    }

    private HBox makeNumberRangeLine(ChoiceBox<?> choices, CheckBox log, NumberField minFld, NumberField maxFld) {
        Label min = new Label("Min:");
        Label max = new Label("Max:");
        min.setFont(numberFont);
        min.setAlignment(Pos.BASELINE_RIGHT);
        min.setTranslateY(4.0);
        max.setFont(numberFont);
        max.setAlignment(Pos.BASELINE_RIGHT);
        max.setTranslateY(4.0);
        return new HBox(8.0, new Node[]{choices, log, min, minFld, max, maxFld});
    }

    private NumberField makeNumberField(String id) {
        NumberField fld = new NumberField(this);
        fld.setId(id);
        fld.setAlignment(Pos.BASELINE_RIGHT);
        fld.setFont(numberFont);
        fld.setMaxWidth(55.0);
        fld.focusedProperty().addListener((obs, old, nVal) -> {
            if (!nVal.booleanValue()) {
                this.fieldChanged(fld.getText(), fld.getId());
            }
        });
        return fld;
    }

    public void fieldChanged(String newValue, String fieldId) {
        BigDecimal newXmin = this.xMin == null ? new BigDecimal(0) : this.xMin.getNumber();
        BigDecimal newXmax = this.xMax == null ? new BigDecimal(0) : this.xMax.getNumber();
        BigDecimal newYmin = this.yMin == null ? new BigDecimal(0) : this.yMin.getNumber();
        BigDecimal newYmax = this.yMax == null ? new BigDecimal(0) : this.yMax.getNumber();
        double val = 0.0;
        try {
            val = Double.parseDouble(newValue);
        }
        catch (NumberFormatException e) {
            return;
        }
        if ("xMin".equals(fieldId)) {
            this.setXRange(new Range(val, newXmax.doubleValue()));
        }
        if ("xMax".equals(fieldId)) {
            this.setXRange(new Range(newXmin.doubleValue(), val));
        }
        if ("yMin".equals(fieldId)) {
            this.setYRange(new Range(val, newYmax.doubleValue()));
        }
        if ("yMax".equals(fieldId)) {
            this.setYRange(new Range(newYmin.doubleValue(), val));
        }
    }

    public abstract void resizeRangeFields();

    public abstract void resized();

    protected void makeFilter() {
        if (this.registrar == null) {
            System.err.println("No registrar found");
            return;
        }
        String x = (String)this.xAxisChoices.getSelectionModel().getSelectedItem();
        String y = (String)this.yAxisChoices.getSelectionModel().getSelectedItem();
        FilterBuilder builder = new FilterBuilder(x, new Range(this.startX, this.endX), y, new Range(this.startY, this.endY));
        builder.makeCompositeFilter(this.registrar);
        this.selectFilterPanel();
    }

    protected void clearRegression() {
        this.curveFit.setSelected(false);
    }

    protected abstract void regression(boolean var1);

    protected void selectFilterPanel() {
        CySwingApplication desktopApp = (CySwingApplication)this.registrar.getService(CySwingApplication.class);
        if (desktopApp == null) {
            return;
        }
        CytoPanel cytoPanelWest = desktopApp.getCytoPanel(CytoPanelName.WEST);
        if (cytoPanelWest == null) {
            return;
        }
        int index = cytoPanelWest.indexOfComponent("org.cytoscape.Filter");
        if (index >= 0) {
            cytoPanelWest.setSelectedIndex(index);
        }
    }

    private void snapshot() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("png files (*.png)", new String[]{"*.png"}));
        fileChooser.setInitialFileName(this.getTitle());
        File file = fileChooser.showSaveDialog(null);
        if (file != null) {
            try {
                this.header1.setVisible(false);
                this.footer1.setVisible(false);
                this.footer2.setVisible(false);
                this.footer3.setVisible(true);
                int width = (int)this.chartContainer.getWidth() + 20;
                int height = (int)this.chartContainer.getHeight() + 20;
                WritableImage writableImage = new WritableImage(width, height);
                this.chartContainer.snapshot(null, writableImage);
                BufferedImage renderedImage = SwingFXUtils.fromFXImage((Image)writableImage, null);
                ImageIO.write((RenderedImage)renderedImage, "png", file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.header1.setVisible(true);
        this.footer1.setVisible(true);
        this.footer2.setVisible(true);
        this.footer3.setVisible(true);
    }

    public boolean isXLog() {
        return this.isXLog;
    }

    public boolean isYLog() {
        return this.isYLog;
    }

    protected void populateColumnChoices() {
        if (this.table != null && !this.table.getColumns().isEmpty()) {
            for (CyColumn col : this.table.getColumns()) {
                if (!this.isNumericColumn(col)) continue;
                this.xAxisChoices.getItems().add((Object)col.getName());
                this.yAxisChoices.getItems().add((Object)col.getName());
            }
            this.xAxisChoices.getSelectionModel().select(0);
        }
    }

    protected CyColumn findColumn(String name) {
        if (name == null) {
            return null;
        }
        if (this.table == null) {
            return null;
        }
        for (CyColumn column : this.table.getColumns()) {
            if (!name.equals(column.getName())) continue;
            return column;
        }
        return null;
    }

    public void setXParameters(Number val) {
        this.xAxisChoices.getSelectionModel().select(val.intValue());
        this.setParameters();
    }

    protected void setLogXDistribution(Boolean new_val) {
        this.isXLog = new_val;
        this.setXParameters(this.xAxisChoices.getSelectionModel().getSelectedIndex());
    }

    public void setYParameters(Number val) {
        this.yAxisChoices.getSelectionModel().select(val.intValue());
        this.setParameters();
    }

    protected void setLogYDistribution(Boolean new_val) {
        this.isYLog = new_val;
        this.setYParameters(this.yAxisChoices.getSelectionModel().getSelectedIndex());
    }

    public void setStatus(String s) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(s);
        }
    }

    public void setStatus(String s, Range xRange, Range yRange) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(s);
        }
        this.setXRange(xRange);
        this.setYRange(yRange);
    }

    public void setXmin(double d) {
        if (!Double.isNaN(d)) {
            this.xMin.setNumber(d);
        }
    }

    public void setXmax(double d) {
        this.xMax.setNumber(d);
    }

    public void setYmin(double d) {
        this.yMin.setNumber(d);
    }

    public void setYmax(double d) {
        this.yMax.setNumber(d);
    }

    public void setXRange(Range r) {
        if (r == null) {
            return;
        }
        this.startX = r.min();
        this.setXmin(this.startX);
        this.endX = r.max();
        this.setXmax(this.endX);
    }

    public void setYRange(Range r) {
        if (r == null) {
            return;
        }
        this.startY = r.min();
        this.setYmin(this.startY);
        this.endY = r.max();
        this.setYmax(this.endY);
    }

    public int getDataSize(XYChart<Number, Number> chart) {
        ObservableList dataList = chart.getData();
        if (dataList == null || dataList.isEmpty()) {
            return 0;
        }
        XYChart.Series data = (XYChart.Series)dataList.get(0);
        return data.getData().size();
    }

    protected boolean isNumericColumn(CyColumn col) {
        return col.getType() == Double.class || col.getType() == Integer.class;
    }

    protected List<Double> getColumnValues(CyColumn col) {
        if (col.getType() == Double.class) {
            return col.getValues(Double.class);
        }
        if (col.getType() == Integer.class) {
            List intvalues = col.getValues(Integer.class);
            ArrayList<Double> dubvalues = new ArrayList<Double>();
            for (Integer i : intvalues) {
                if (i == null) continue;
                dubvalues.add(new Double(i.intValue()));
            }
            return dubvalues;
        }
        return null;
    }

    protected double safelog(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        if (Double.isNaN(d)) {
            return 0.0;
        }
        return Math.log(d);
    }

    public double getSelectionStart() {
        return this.startX;
    }

    public double getSelectionEnd() {
        return this.endX;
    }

    public double getSelectionTop() {
        return this.startY;
    }

    public double getSelectionBottom() {
        return this.endY;
    }

    public Range getXRange() {
        this.xAxis = (ValueAxis)this.theChart.getXAxis();
        return new Range(this.xAxis.getLowerBound(), this.xAxis.getUpperBound());
    }

    public Range getYRange() {
        if (this.yAxis == null) {
            this.yAxis = (ValueAxis)this.theChart.getYAxis();
        }
        return new Range(this.yAxis.getLowerBound(), this.yAxis.getUpperBound());
    }

    public void setRangeValues(Range r) {
        if (r == null) {
            return;
        }
        this.setRangeValues(r.min(), r.max());
    }

    public void setRangeValues(double selStart, double selEnd) {
        if (Double.isNaN(selStart) || Double.isNaN(selEnd)) {
            return;
        }
        this.startX = Math.max(this.xAxis.getLowerBound(), Math.min(selStart, selEnd));
        this.endX = Math.min(this.xAxis.getUpperBound(), Math.max(selStart, selEnd));
    }

    public void setRangeValues(double selStart, double selEnd, double selStartY, double selEndY) {
        if (Double.isNaN(selStart) || Double.isNaN(selEnd)) {
            return;
        }
        this.startX = Math.max(this.xAxis.getLowerBound(), Math.min(selStart, selEnd));
        this.endX = Math.min(this.xAxis.getUpperBound(), Math.max(selStart, selEnd));
        this.startY = Math.max(this.yAxis.getLowerBound(), Math.min(selStartY, selEndY));
        this.endY = Math.min(this.yAxis.getUpperBound(), Math.max(selStartY, selEndY));
    }

    public void anchor(Node n) {
        this.anchor(n, 0.0);
    }

    private void anchor(Node n, double margin) {
        this.anchor(n, margin, margin, margin, margin);
    }

    private void anchor(Node n, double top, double left, double bottom, double right) {
        AnchorPane.setTopAnchor((Node)n, (Double)top);
        AnchorPane.setLeftAnchor((Node)n, (Double)left);
        AnchorPane.setBottomAnchor((Node)n, (Double)bottom);
        AnchorPane.setRightAnchor((Node)n, (Double)right);
    }

    public void fieldEdited(String fldId, BigDecimal newValue) {
        double v = newValue.doubleValue();
        if ("xMin".contentEquals(fldId)) {
            this.setXmin(v);
        }
        if ("xMax".contentEquals(fldId)) {
            this.setXmax(v);
        }
        if ("yMin".contentEquals(fldId)) {
            this.setYmin(v);
        }
        if ("yMax".contentEquals(fldId)) {
            this.setYmax(v);
        }
    }
}

