/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.view;

import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowserManager;
import edu.ucsf.rbvi.cyBrowser.internal.view.SwingPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.util.swing.IconManager;

public class SwingBrowser
extends JFrame
implements CyBrowser,
ChangeListener {
    private final CyBrowserManager manager;
    private SwingPanel currentPanel;
    private final Map<String, SwingPanel> idMap;
    private final Map<String, JButton> buttonMap;
    private final Map<String, BrowserTab> tabMap;
    private String initialTitle = null;
    private JTabbedPane tabbedPane = null;

    public SwingBrowser(final CyBrowserManager manager, String id, SwingPanel reuse, String title, boolean showDebug) {
        this.manager = manager;
        if (title != null) {
            this.setTitle(title);
            this.initialTitle = title;
        } else {
            this.setTitle("CyBrowser");
        }
        this.idMap = new HashMap<String, SwingPanel>();
        this.buttonMap = new HashMap<String, JButton>();
        this.tabMap = new HashMap<String, BrowserTab>();
        this.currentPanel = new SwingPanel(manager, id, this, reuse, true, showDebug);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.getContentPane().add(this.tabbedPane);
        this.addTab(id, this.currentPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                SwingBrowser.this.currentPanel.loadURL(null);
                manager.removeBrowser(SwingBrowser.this);
            }
        });
        this.setPreferredSize(new Dimension(1024, 600));
        this.setDefaultCloseOperation(2);
        this.pack();
        JFrame desktop = ((CySwingApplication)manager.getRegistrar().getService(CySwingApplication.class)).getJFrame();
        this.setLocationRelativeTo(desktop);
    }

    public SwingBrowser(final CyBrowserManager manager, final String id, String title, boolean showDebug) {
        this.manager = manager;
        if (title != null) {
            this.setTitle(title);
            this.initialTitle = title;
        } else {
            this.setTitle("CyBrowser");
        }
        this.idMap = new HashMap<String, SwingPanel>();
        this.buttonMap = new HashMap<String, JButton>();
        this.tabMap = new HashMap<String, BrowserTab>();
        this.currentPanel = new SwingPanel(manager, id, this, null, true, showDebug);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.getContentPane().add(this.tabbedPane);
        this.addTab(id, this.currentPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                SwingBrowser.this.currentPanel.loadURL(null);
                manager.removeBrowser(id);
            }
        });
        this.setPreferredSize(new Dimension(1024, 600));
        this.setDefaultCloseOperation(2);
        this.pack();
        JFrame desktop = ((CySwingApplication)manager.getRegistrar().getService(CySwingApplication.class)).getJFrame();
        this.setLocationRelativeTo(desktop);
    }

    @Override
    public String getTitle(String id) {
        if (id == null) {
            return this.initialTitle;
        }
        if (this.idMap.containsKey(id)) {
            return this.idMap.get(id).getTitle();
        }
        return null;
    }

    @Override
    public String getURL(String id) {
        if (id == null) {
            return this.currentPanel.getURL();
        }
        if (this.idMap.containsKey(id)) {
            return this.idMap.get(id).getURL();
        }
        return null;
    }

    @Override
    public SwingPanel getPanel(String id) {
        if (id == null) {
            return this.currentPanel;
        }
        if (this.idMap.containsKey(id)) {
            return this.idMap.get(id);
        }
        return null;
    }

    @Override
    public void loadURL(String url, boolean newTab) {
        this.loadURL(url, newTab, null);
    }

    @Override
    public void loadURL(String url, boolean newTab, String tabID) {
        if (!newTab || this.currentPanel.getURL() == null) {
            this.loadURL(url);
            if (tabID != null) {
                this.idMap.put((String)tabID, this.currentPanel);
            }
        } else {
            if (tabID == null) {
                tabID = this.currentPanel.getId() + " " + CyBrowserManager.browserCount;
            }
            if (!this.idMap.containsKey(tabID)) {
                this.addTab((String)tabID, this.currentPanel.getTitle() + " " + ++CyBrowserManager.browserCount, false);
            } else {
                this.currentPanel = this.idMap.get(tabID);
                this.tabbedPane.setSelectedComponent(this.currentPanel);
            }
            this.loadURL(url);
        }
    }

    @Override
    public void loadURL(String url) {
        this.currentPanel.loadURL(url);
        try {
            URL u = new URL(url);
            String urlTitle = u.getHost() + u.getPath();
            int tab = this.tabbedPane.indexOfComponent(this.currentPanel);
            this.tabMap.get(this.currentPanel.getId()).setTitle(urlTitle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void loadText(String text) {
        this.currentPanel.loadText(text);
    }

    @Override
    public void loadText(String text, boolean newTab) {
        this.loadText(text, newTab, null);
    }

    @Override
    public void loadText(String text, boolean newTab, String tabID) {
        if (!newTab || this.currentPanel.getText() == null) {
            this.currentPanel.loadText(text);
            if (tabID != null) {
                this.idMap.put((String)tabID, this.currentPanel);
            }
        } else {
            if (tabID == null) {
                tabID = this.currentPanel.getId() + " " + CyBrowserManager.browserCount;
            }
            if (!this.idMap.containsKey(tabID)) {
                this.addTab((String)tabID, this.currentPanel.getTitle() + " " + ++CyBrowserManager.browserCount, false);
            } else {
                this.currentPanel = this.idMap.get(tabID);
                this.tabbedPane.setSelectedComponent(this.currentPanel);
            }
            this.currentPanel.loadText(text);
        }
    }

    public void setTitle(String id, String title) {
        if (this.idMap.containsKey(id)) {
            SwingPanel panel = this.idMap.get(id);
            this.tabMap.get(id).setTitle(title);
            if (panel.equals(this.currentPanel)) {
                this.setTitle(title);
            }
        }
    }

    public void addTab(String id, String title, boolean showDebug) {
        this.currentPanel = new SwingPanel(this.manager, id, this, null, true, showDebug);
        this.addTab(id, this.currentPanel);
    }

    private void addTab(String id, SwingPanel panel) {
        this.tabbedPane.addTab(panel.getTitle(), panel);
        this.idMap.put(id, panel);
        String title = panel.getTitle();
        if (title == null || title.length() == 0) {
            title = this.initialTitle;
        }
        int tab = this.tabbedPane.indexOfComponent(panel);
        BrowserTab newTab = new BrowserTab(title, id);
        this.tabMap.put(id, newTab);
        this.tabbedPane.setTabComponentAt(tab, newTab);
        this.tabbedPane.setSelectedComponent(panel);
        if (this.idMap.size() > 1) {
            for (String btnId : this.buttonMap.keySet()) {
                this.buttonMap.get(btnId).setEnabled(true);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.currentPanel = (SwingPanel)this.tabbedPane.getSelectedComponent();
        if (this.currentPanel == null) {
            return;
        }
        String ttl = this.currentPanel.getTitle();
        if (ttl != null) {
            this.setTitle(ttl);
        } else {
            this.setTitle("CyBrowser");
        }
    }

    public class BrowserTab
    extends JPanel {
        JLabel lblTitle;
        String id;

        public BrowserTab(String title, String id) {
            super(new GridBagLayout());
            this.setOpaque(false);
            if (title == null || title.length() == 0) {
                title = "Empty Tab";
            }
            int len = Math.min(title.length(), 20);
            this.lblTitle = new JLabel(title.substring(0, len));
            this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(10.0f));
            JButton btnClose = new JButton("\uf00d");
            btnClose.setFont(((IconManager)SwingBrowser.this.manager.getRegistrar().getService(IconManager.class)).getIconFont(8.0f));
            SwingBrowser.this.buttonMap.put(id, btnClose);
            if (SwingBrowser.this.idMap.size() > 1) {
                btnClose.setEnabled(true);
            } else {
                btnClose.setEnabled(false);
            }
            btnClose.setBorderPainted(false);
            btnClose.setContentAreaFilled(false);
            btnClose.setFocusPainted(false);
            btnClose.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 1));
            btnClose.addActionListener(new CloseActionHandler(id));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            this.add((Component)btnClose, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            this.add((Component)this.lblTitle, gbc);
        }

        public void setTitle(String title) {
            this.lblTitle.setText(title);
        }

        public void setId(String id) {
            JButton btnClose = SwingBrowser.this.buttonMap.get(this.id);
            this.id = id;
            SwingBrowser.this.buttonMap.put(this.id, btnClose);
            btnClose.addActionListener(new CloseActionHandler(id));
        }
    }

    public class CloseActionHandler
    implements ActionListener {
        String id;

        public CloseActionHandler(String id) {
            this.id = id;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SwingPanel panel = SwingBrowser.this.idMap.get(this.id);
            if (panel != null) {
                panel.loadURL(null);
                SwingBrowser.this.tabbedPane.remove(panel);
                SwingBrowser.this.idMap.remove(this.id);
                SwingBrowser.this.buttonMap.remove(this.id);
                SwingBrowser.this.manager.removeBrowser(this.id);
                SwingBrowser.this.currentPanel = (SwingPanel)SwingBrowser.this.tabbedPane.getSelectedComponent();
                if (SwingBrowser.this.idMap.size() == 1) {
                    SwingBrowser.this.buttonMap.get(SwingBrowser.this.currentPanel.getId()).setEnabled(false);
                }
            }
        }
    }
}

