/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.tasks;

import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowserManager;
import edu.ucsf.rbvi.cyBrowser.internal.view.SwingPanel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class SendTask
extends AbstractTask
implements ObservableTask {
    final CyBrowserManager manager;
    String jsReturn;
    @Tunable(description="Script to execute in browser", longDescription="A string that represents a JavaScript variable, script, or call to be executed in the browser.  Note that only string results are returned", exampleStringValue="navigator.userAgent;", context="nogui")
    public String script;
    @Tunable(description="Window ID", longDescription="The ID for the browser window to close", exampleStringValue="Window 1", context="nogui")
    public String id = null;

    public SendTask(CyBrowserManager manager) {
        this.manager = manager;
    }

    public void run(TaskMonitor monitor) {
        CyBrowser browser = this.manager.getBrowser(this.id);
        SwingPanel panel = browser.getPanel(this.id);
        this.jsReturn = panel.execute(this.script);
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        Map<String, CyBrowser> map = this.manager.getBrowserMap();
        if (type.equals(String.class)) {
            if (this.jsReturn != null) {
                return (R)this.jsReturn.toString();
            }
            return null;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.jsReturn == null) {
                    return "{}";
                }
                String jsonReturn = "{\"browserId\":\"" + this.id + "\", \"result\": ";
                if (this.jsReturn.startsWith("[") || this.jsReturn.startsWith("{")) {
                    return jsonReturn + this.jsReturn + "}";
                }
                return jsonReturn + "\"" + this.jsReturn + "\"}";
            };
            return (R)res;
        }
        return null;
    }
}

