/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.tasks;

import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowserManager;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.AbstractEmptyObservableTask;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class NativeBrowserTask
extends AbstractEmptyObservableTask {
    @Tunable(description="URL", longDescription="The URL the browser should load", exampleStringValue="http://www.cytoscape.org", gravity=1.0)
    public String url;
    final CyBrowserManager manager;
    final CyServiceRegistrar serviceRegistrar;

    public NativeBrowserTask(CyBrowserManager manager, CyServiceRegistrar serviceRegistrar) {
        this.manager = manager;
        this.serviceRegistrar = serviceRegistrar;
    }

    @Override
    public void run(TaskMonitor monitor) {
        OpenBrowser openBrowser = (OpenBrowser)this.serviceRegistrar.getService(OpenBrowser.class);
        openBrowser.openURL(this.url, false);
    }

    @ProvidesTitle
    public String getTitle() {
        return "Open in Native Browser";
    }
}

