/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.tasks;

import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowserManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class ListBrowsersTask
extends AbstractTask
implements ObservableTask {
    final CyBrowserManager manager;

    public ListBrowsersTask(CyBrowserManager manager) {
        this.manager = manager;
    }

    public void run(TaskMonitor monitor) {
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class, List.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        Map<String, CyBrowser> map = this.manager.getBrowserMap();
        if (type.equals(String.class)) {
            Object res = "";
            if (map != null) {
                for (String id : map.keySet()) {
                    CyBrowser b = map.get(id);
                    res = (String)res + id + ": ";
                    if (b.getTitle(id) != null) {
                        res = (String)res + b.getTitle(id) + " ";
                    }
                    if (b.getURL(id) != null) {
                        res = (String)res + "(" + b.getURL(id) + ") ";
                    }
                    res = (String)res + "\n";
                }
            }
            return (R)res;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (map == null) {
                    return "{}";
                }
                if (map.keySet().size() == 0) {
                    return "[]";
                }
                Object jsonRes = "[";
                for (String id : map.keySet()) {
                    CyBrowser b = (CyBrowser)map.get(id);
                    jsonRes = (String)jsonRes + "{\"id\": \"" + id + "\"";
                    if (b.getTitle(id) != null) {
                        jsonRes = (String)jsonRes + ", \"title\":\"" + b.getTitle(id) + "\"";
                    }
                    if (b.getURL(id) != null) {
                        jsonRes = (String)jsonRes + ", \"url\":\"" + b.getURL(id) + "\"";
                    }
                    jsonRes = (String)jsonRes + "},";
                }
                jsonRes = ((String)jsonRes).substring(0, ((String)jsonRes).length() - 1) + "]";
                return jsonRes;
            };
            return (R)res;
        }
        if (type.equals(List.class)) {
            return (R)new ArrayList<String>(map.keySet());
        }
        return null;
    }
}

