/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.model;

import edu.ucsf.rbvi.cyBrowser.internal.model.JSListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.web.WebEngine;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.AboutToRemoveEdgesEvent;
import org.cytoscape.model.events.AboutToRemoveEdgesListener;
import org.cytoscape.model.events.AboutToRemoveNodesEvent;
import org.cytoscape.model.events.AboutToRemoveNodesListener;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;

public class NetworkObjectListenerJS
extends JSListener
implements RowsSetListener,
AboutToRemoveEdgesListener,
AboutToRemoveNodesListener {
    CyTable table = null;
    CyNetwork network;
    Class<? extends CyIdentifiable> type;

    NetworkObjectListenerJS(WebEngine engine, CyNetwork network, String callback, Class<? extends CyIdentifiable> type) {
        super(engine, callback);
        if (network != null) {
            this.table = network.getTable(type, "LOCAL_ATTRS");
        }
        this.network = network;
        this.type = type;
    }

    public void handleEvent(RowsSetEvent e) {
        List selection;
        if (!e.containsColumn("selected")) {
            return;
        }
        if (this.table != null && e.getSource() != this.table) {
            return;
        }
        if (this.type.equals(CyNode.class)) {
            selection = CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true);
        } else if (this.type.equals(CyEdge.class)) {
            selection = CyTableUtil.getEdgesInState((CyNetwork)this.network, (String)"selected", (boolean)true);
        } else {
            return;
        }
        String s = this.getJSON(selection);
        this.doCallback(this.callback, s);
    }

    public void handleEvent(AboutToRemoveNodesEvent e) {
        Collection nodes = e.getNodes();
        String s = this.getJSON(new ArrayList(nodes));
        this.doCallback(this.callback, s);
    }

    public void handleEvent(AboutToRemoveEdgesEvent e) {
        Collection edges = e.getEdges();
        String s = this.getJSON(new ArrayList(edges));
        this.doCallback(this.callback, s);
    }

    private String getJSON(List<? extends CyIdentifiable> ids) {
        Object s = "[";
        for (CyIdentifiable cyIdentifiable : ids) {
            s = (String)s + this.toJSON(cyIdentifiable) + ",";
        }
        if (((String)s).length() > 1) {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        }
        s = (String)s + "]";
        return s;
    }

    private String toJSON(CyIdentifiable id) {
        return "{\"suid\":" + id.getSUID() + ",\"name\":\"" + (String)this.network.getRow(id).get("name", String.class) + "\"}";
    }
}

