/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.model;

import edu.ucsf.rbvi.cyBrowser.internal.view.SwingBrowser;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.FileUtil;

public class Downloader {
    static final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");

    public static void download(CyServiceRegistrar registrar, SwingBrowser parent, String targ, String fileName, boolean prompt) {
        FileUtil fileUtil = (FileUtil)registrar.getService(FileUtil.class);
        if (fileName == null && !targ.startsWith("data:")) {
            try {
                URL urlTarg = new URL(targ);
                fileName = urlTarg.getPath();
                fileName = new File(fileName).getName();
            }
            catch (Exception e) {
                logger.error((Object)("Malformed URL: '" + targ + "'"));
                return;
            }
        }
        if (targ.startsWith("data:")) {
            int offset = targ.indexOf(",");
            String[] inst = targ.substring(0, offset).split("[:;]");
            if (!inst[2].startsWith("base64") || !inst[1].startsWith("image")) {
                logger.error((Object)"Currently only base64-encoded images are supported for data url's");
                return;
            }
            Downloader.doDownload(fileUtil, parent, targ, fileName, true, new DataDownloader());
            return;
        }
        if (fileName.charAt(0) == '/') {
            fileName = fileName.substring(1);
        }
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            HttpGet request = new HttpGet(targ);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                Downloader.doDownload(fileUtil, parent, targ, fileName, prompt, new HttpDownloader(response));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error downloading file from: '" + targ + "': " + e.getMessage()));
        }
    }

    private static void doDownload(final FileUtil fileUtil, final SwingBrowser parent, final String targ, final String fileName, final boolean prompt, final Runnable processor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                File file;
                if (prompt) {
                    file = fileUtil.getFile((Component)parent, "Name of downloaded file", 1, null, fileName, null, new ArrayList());
                    if (file == null) {
                        return;
                    }
                } else {
                    int download = JOptionPane.showConfirmDialog(parent, "You have requested a download of " + fileName + ", OK to download?", "Download", 2);
                    if (download == 2) {
                        return;
                    }
                    file = new File(System.getProperty("user.home") + File.separator + fileName);
                }
                if (processor instanceof HttpDownloader) {
                    ((HttpDownloader)processor).setFile(file);
                    ((HttpDownloader)processor).setURL(targ);
                    ((HttpDownloader)processor).startProgress();
                } else if (processor instanceof DataDownloader) {
                    ((DataDownloader)processor).setFile(file);
                    ((DataDownloader)processor).setURL(targ);
                }
                try {
                    Thread t = new Thread(processor);
                    t.start();
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to open file: '" + file.toString() + "': " + e.getMessage()));
                }
            }
        });
    }

    private static class DataDownloader
    implements Runnable {
        File file;
        String targ;

        public void setFile(File file) {
            this.file = file;
        }

        public void setURL(String targ) {
            this.targ = targ;
        }

        @Override
        public void run() {
            logger.info((Object)("Saving file: " + this.file.toString()));
            String base64String = this.targ.substring(this.targ.indexOf(",") + 1);
            try {
                byte[] imagedata = Base64.getMimeDecoder().decode(base64String.getBytes(StandardCharsets.UTF_8));
                try (FileOutputStream stream = new FileOutputStream(this.file);){
                    ((OutputStream)stream).write(imagedata);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to write image to file: " + this.file.toString()));
                e.printStackTrace();
            }
        }
    }

    private static class HttpDownloader
    implements Runnable {
        File file;
        String targ;
        final CloseableHttpResponse response;
        static int BufferSize = 4096;
        JProgressBar jprogressBar;
        JDialog progressDialog;

        public HttpDownloader(CloseableHttpResponse response) {
            this.response = response;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setURL(String targ) {
            this.targ = targ;
        }

        public void startProgress() {
            JOptionPane pane = new JOptionPane();
            pane.setMessage("Downloading " + this.file.getName() + " ...");
            this.jprogressBar = new JProgressBar(1, 100);
            this.jprogressBar.setValue(0);
            pane.add((Component)this.jprogressBar, 1);
            this.progressDialog = pane.createDialog("Downloading " + this.file.getName());
            this.progressDialog.setModal(false);
            this.progressDialog.setVisible(true);
        }

        @Override
        public void run() {
            logger.info((Object)("Downloading file: " + this.file.toString() + " from " + this.targ));
            try {
                HttpEntity entity = this.response.getEntity();
                if (entity != null) {
                    int bytesRead;
                    double length = entity.getContentLength();
                    InputStream in = entity.getContent();
                    FileOutputStream outstream = new FileOutputStream(this.file);
                    double read = 0.0;
                    byte[] buffer = new byte[BufferSize];
                    do {
                        if ((bytesRead = in.read(buffer, 0, BufferSize)) <= 0) continue;
                        outstream.write(buffer, 0, bytesRead);
                        this.jprogressBar.setValue((int)((read += (double)bytesRead) * 100.0 / length));
                    } while (bytesRead > 0);
                }
                this.progressDialog.setVisible(false);
                this.progressDialog.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("IO error downloading file: '" + this.file.toString() + "' from '" + this.targ + "': " + e.getMessage()));
                this.progressDialog.setVisible(false);
                this.progressDialog.dispose();
                return;
            }
            logger.info((Object)("Downloaded file: " + this.file.toString()));
        }
    }
}

