/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.model;

import edu.ucsf.rbvi.cyBrowser.internal.model.Downloader;
import edu.ucsf.rbvi.cyBrowser.internal.model.JSListener;
import edu.ucsf.rbvi.cyBrowser.internal.model.JSListenerFactory;
import edu.ucsf.rbvi.cyBrowser.internal.view.SwingBrowser;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;
import org.apache.log4j.Logger;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.command.StringToModel;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.json.JSONResult;

public class Bridge {
    private final WebEngine engine;
    private final CommandExecutorTaskFactory commandTaskFactory;
    private final StringToModel stringToModel;
    private final SynchronousTaskManager taskManager;
    private final CyServiceRegistrar registrar;
    private final SwingBrowser parent;
    private List<JSListener> listeners;
    final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");

    public Bridge(WebEngine engine, CyServiceRegistrar registrar, SwingBrowser parent) {
        this.engine = engine;
        this.parent = parent;
        this.commandTaskFactory = (CommandExecutorTaskFactory)registrar.getService(CommandExecutorTaskFactory.class);
        this.taskManager = (SynchronousTaskManager)registrar.getService(SynchronousTaskManager.class);
        this.stringToModel = (StringToModel)registrar.getService(StringToModel.class);
        this.listeners = new ArrayList<JSListener>();
        this.registrar = registrar;
    }

    public void log(String text) {
        this.logger.info((Object)("cyBrowser: " + text));
    }

    public void executeCommand(String command, String callbackMethod) {
        CallbackObserver observer = new CallbackObserver(callbackMethod);
        this.logger.info((Object)("CyBrowser: executing command: '" + command + "'"));
        Runnable runnableTask = () -> {
            try {
                TaskIterator commandTasks = this.commandTaskFactory.createTaskIterator(observer, new String[]{command});
                this.taskManager.execute(commandTasks, observer);
            }
            catch (Exception e) {
                this.logger.error((Object)("CyBrowser: error processing command: " + e.getMessage()));
            }
        };
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(runnableTask);
    }

    public void executeCyCommand(String command) {
        this.logger.info((Object)("Bridge: executing command: '" + command + "'"));
        this.executeCommand(command, null);
    }

    public void executeCyCommandWithResults(String command, String callback) {
        this.logger.info((Object)("Bridge: executing command: '" + command + "' with results"));
        this.executeCommand(command, callback);
    }

    public void cyLog(String message) {
        System.out.println(message);
        this.logger.info((Object)message);
    }

    public void downloadFile(String href, String fileName) {
        Downloader.download(this.registrar, this.parent, href, fileName, true);
    }

    public void registerSelectionListeners(String types, String network, String callback) {
        String[] typeArray;
        CyNetwork net = null;
        if (network != null) {
            net = this.stringToModel.getNetwork(network);
        }
        for (String type : typeArray = types.split(",")) {
            JSListener listener = JSListenerFactory.createListener(this.registrar, this.engine, type, net, callback);
            this.listeners.add(listener);
        }
    }

    public void registerListeners(String types, String callback) {
        String[] typeArray;
        for (String type : typeArray = types.split(",")) {
            JSListener listener = JSListenerFactory.createListener(this.registrar, this.engine, type, callback);
            this.listeners.add(listener);
        }
    }

    public void clearListeners() {
        for (JSListener l : this.listeners) {
            this.registrar.unregisterAllServices((Object)l);
        }
        this.listeners.clear();
    }

    class CallbackObserver
    implements TaskObserver {
        String callbackMethod;

        public CallbackObserver(String callbackMethod) {
            this.callbackMethod = callbackMethod;
        }

        public void allFinished(FinishStatus finishStatus) {
        }

        public void taskFinished(ObservableTask task) {
            final String results = ((JSONResult)task.getResults(JSONResult.class)).getJSON();
            if (this.callbackMethod != null) {
                final String cb = this.callbackMethod;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JSObject jsobj = (JSObject)Bridge.this.engine.executeScript("window");
                        jsobj.call(cb, results);
                    }
                });
            }
        }
    }
}

