/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view.tools;

import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.cytoscape.browser.internal.view.tools.AbstractToolBarControl;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.presentation.property.table.TableMode;
import org.cytoscape.view.presentation.property.table.TableModeVisualProperty;

public class ViewModeControl
extends AbstractToolBarControl {
    private JToggleButton autoButton;
    private JToggleButton allButton;
    private JToggleButton selectedButton;
    private final ButtonGroup modeButtonGroup = new ButtonGroup();

    public ViewModeControl(CyServiceRegistrar serviceRegistrar) {
        super("Show Rows", serviceRegistrar);
        this.init();
    }

    @Override
    protected void update() {
        CyTableView tableView = this.getTableView();
        if (tableView != null) {
            TableMode mode = (TableMode)tableView.getVisualProperty(BasicTableVisualLexicon.TABLE_VIEW_MODE);
            JToggleButton btn = this.getAutoButton();
            if (mode == TableModeVisualProperty.ALL) {
                btn = this.getAllButton();
            } else if (mode == TableModeVisualProperty.SELECTED) {
                btn = this.getSelectedButton();
            }
            this.modeButtonGroup.setSelected(btn.getModel(), true);
        }
    }

    private void init() {
        this.modeButtonGroup.add(this.getAutoButton());
        this.modeButtonGroup.add(this.getAllButton());
        this.modeButtonGroup.add(this.getSelectedButton());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(LookAndFeelUtil.isWinLAF());
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getAutoButton()).addComponent(this.getAllButton()).addComponent(this.getSelectedButton()));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getAutoButton()).addComponent(this.getAllButton()).addComponent(this.getSelectedButton())).addGap(0, 0, Short.MAX_VALUE));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getAutoButton(), this.getAllButton(), this.getSelectedButton()});
        ViewModeControl.setAquaStyle(this.getAutoButton(), this.getAllButton(), this.getSelectedButton());
    }

    private JToggleButton getAutoButton() {
        if (this.autoButton == null) {
            this.autoButton = new JToggleButton("Auto");
            this.autoButton.addActionListener(evt -> this.applyViewMode(TableModeVisualProperty.AUTO));
        }
        return this.autoButton;
    }

    private JToggleButton getAllButton() {
        if (this.allButton == null) {
            this.allButton = new JToggleButton("All");
            this.allButton.addActionListener(evt -> this.applyViewMode(TableModeVisualProperty.ALL));
        }
        return this.allButton;
    }

    private JToggleButton getSelectedButton() {
        if (this.selectedButton == null) {
            this.selectedButton = new JToggleButton("Selected");
            this.selectedButton.addActionListener(evt -> this.applyViewMode(TableModeVisualProperty.SELECTED));
        }
        return this.selectedButton;
    }

    private void applyViewMode(TableMode mode) {
        this.apply(BasicTableVisualLexicon.TABLE_VIEW_MODE, mode);
    }
}

