/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view.tools;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.cytoscape.browser.internal.view.tools.AbstractToolBarControl;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.ContinuousRange;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;

public class RowHeightControl
extends AbstractToolBarControl {
    private static final int MIN_VALUE = 8;
    private JSlider heightSlider;
    private JTextField heightText;
    private JButton resetButton;
    private int value;
    private boolean adjusting;

    public RowHeightControl(CyServiceRegistrar serviceRegistrar) {
        super("Row Height", serviceRegistrar);
        this.init();
    }

    private void setValue(int value) {
        if (value != this.value) {
            this.value = value;
            this.apply(BasicTableVisualLexicon.TABLE_ROW_HEIGHT, value);
        }
    }

    @Override
    protected void update() {
        this.adjusting = true;
        try {
            CyTableView tableView = this.getTableView();
            if (tableView != null) {
                Integer value = (Integer)tableView.getVisualProperty(BasicTableVisualLexicon.TABLE_ROW_HEIGHT);
                if (this.value != (value = Integer.valueOf(this.clamp(value)))) {
                    this.value = value;
                    this.getHeightSlider().setValue(value);
                }
            }
        }
        finally {
            this.adjusting = false;
        }
    }

    private void init() {
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(LookAndFeelUtil.isWinLAF());
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getHeightSlider()).addComponent(this.getHeightText()).addComponent(this.getResetButton()));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getHeightSlider()).addComponent(this.getHeightText()).addComponent(this.getResetButton())).addGap(0, 0, Short.MAX_VALUE));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getHeightSlider(), this.getHeightText(), this.getResetButton()});
        RowHeightControl.setAquaStyle(this.getHeightSlider(), this.getHeightText(), this.getResetButton());
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.getHeightText(), this.getResetButton()});
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton("\uf021");
            this.resetButton.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(10.0f));
            this.resetButton.setToolTipText("Reset");
            this.resetButton.addActionListener(evt -> this.getHeightSlider().setValue((Integer)BasicTableVisualLexicon.TABLE_ROW_HEIGHT.getDefault()));
        }
        return this.resetButton;
    }

    private JSlider getHeightSlider() {
        if (this.heightSlider == null) {
            ContinuousRange range = (ContinuousRange)BasicTableVisualLexicon.TABLE_ROW_HEIGHT.getRange();
            int min = Math.max(8, (Integer)range.getMin());
            Integer max = (Integer)range.getMax();
            Integer def = (Integer)BasicTableVisualLexicon.TABLE_ROW_HEIGHT.getDefault();
            this.heightSlider = new JSlider(min, max);
            this.heightSlider.setValue(this.value <= 0 ? def.intValue() : this.clamp(this.value));
            this.heightSlider.setPreferredSize(new Dimension(120, this.heightSlider.getPreferredSize().height));
            this.heightSlider.addChangeListener(evt -> {
                if (this.adjusting) {
                    return;
                }
                String text = "" + this.heightSlider.getValue();
                this.getHeightText().setText(text);
                this.setValue(this.getCurrentValue());
            });
        }
        return this.heightSlider;
    }

    private JTextField getHeightText() {
        if (this.heightText == null) {
            int min = this.getHeightSlider().getMinimum();
            int max = this.getHeightSlider().getMaximum();
            this.heightText = new JTextField();
            this.heightText.setToolTipText("Enter a number between " + min + " and " + max);
            this.heightText.setHorizontalAlignment(4);
            Dimension d = new Dimension(32, this.heightText.getPreferredSize().height);
            this.heightText.setPreferredSize(d);
            this.heightText.setMaximumSize(d);
            ((AbstractDocument)this.heightText.getDocument()).setDocumentFilter(new IntDocFilter());
            this.heightText.setText("" + this.getHeightSlider().getValue());
            this.heightText.addActionListener(evt -> this.onTextChanged());
            this.heightText.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    RowHeightControl.this.onTextChanged();
                }
            });
        }
        return this.heightText;
    }

    private void onTextChanged() {
        int val = this.getCurrentValue();
        this.getHeightText().setText("" + val);
        this.getHeightSlider().setValue(this.clamp(val));
    }

    private int getCurrentValue() {
        int value = this.value;
        try {
            value = Integer.parseInt(this.getHeightText().getText());
            value = this.clamp(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    private int clamp(int value) {
        int min = this.getHeightSlider().getMinimum();
        int max = this.getHeightSlider().getMaximum();
        return Math.max(min, Math.min(max, value));
    }

    private class IntDocFilter
    extends DocumentFilter {
        private IntDocFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.insert(offset, string);
            if (this.test(sb.toString())) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.replace(offset, offset + length, text);
            if (this.test(sb.toString())) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.delete(offset, offset + length);
            if (this.test(sb.toString())) {
                super.remove(fb, offset, length);
            }
        }

        private boolean test(String text) {
            try {
                Integer.parseInt(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

