/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewManager;

public abstract class AbstractToolBarControl
extends JPanel {
    private JLabel titleLabel;
    private JPanel contentPane;
    protected String title;
    protected CyTable currentTable;
    protected final CyServiceRegistrar serviceRegistrar;

    protected AbstractToolBarControl(CyServiceRegistrar serviceRegistrar) {
        this(null, serviceRegistrar);
    }

    protected AbstractToolBarControl(String title, CyServiceRegistrar serviceRegistrar) {
        this.title = title;
        this.serviceRegistrar = serviceRegistrar;
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.setLayout(new BorderLayout());
        if (!LookAndFeelUtil.isAquaLAF()) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
        if (title != null) {
            this.add((Component)this.getTitleLabel(), "North");
        }
        this.add((Component)this.getContentPane(), "Center");
    }

    public void setCurrentTable(CyTable currentTable) {
        this.currentTable = currentTable;
        this.update();
    }

    protected CyTableView getTableView() {
        if (this.currentTable == null) {
            return null;
        }
        CyTableViewManager tableViewManager = (CyTableViewManager)this.serviceRegistrar.getService(CyTableViewManager.class);
        return tableViewManager.getTableView(this.currentTable);
    }

    protected <T> void apply(VisualProperty<T> vp, T value) {
        CyTableView view = this.getTableView();
        if (view != null) {
            view.setLockedValue(vp, value);
        }
    }

    protected JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel(this.title + ":");
            this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.titleLabel});
            AbstractToolBarControl.setAquaStyle(this.titleLabel);
        }
        return this.titleLabel;
    }

    protected JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setOpaque(!LookAndFeelUtil.isAquaLAF());
        }
        return this.contentPane;
    }

    protected abstract void update();

    static void setAquaStyle(JToggleButton ... buttons) {
        if (LookAndFeelUtil.isAquaLAF()) {
            int count = 0;
            for (JToggleButton btn : buttons) {
                if (btn instanceof JCheckBox || btn instanceof JRadioButton) {
                    AbstractToolBarControl.setAquaStyle(new JComponent[]{btn});
                    continue;
                }
                btn.putClientProperty("JComponent.sizeVariant", "mini");
                btn.putClientProperty("JButton.buttonType", "square");
                ++count;
            }
        }
    }

    static void setAquaStyle(JComponent ... components) {
        if (LookAndFeelUtil.isAquaLAF()) {
            for (JComponent c : components) {
                c.putClientProperty("JComponent.sizeVariant", "mini");
                if (c instanceof JCheckBox || c instanceof JRadioButton || !(c instanceof JButton) && !(c instanceof JToggleButton)) continue;
                c.putClientProperty("JButton.buttonType", "square");
            }
        }
    }
}

