/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.vizmap.StyleAssociation;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.events.VisualStyleChangedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleChangedListener;
import org.cytoscape.view.vizmap.events.VisualStyleSetEvent;
import org.cytoscape.view.vizmap.events.VisualStyleSetListener;
import org.cytoscape.view.vizmap.events.table.ColumnAssociatedVisualStyleSetEvent;
import org.cytoscape.view.vizmap.events.table.ColumnAssociatedVisualStyleSetListener;
import org.cytoscape.view.vizmap.events.table.ColumnVisualStyleSetEvent;
import org.cytoscape.view.vizmap.events.table.ColumnVisualStyleSetListener;

public class TableBrowserStyleMediator
implements VisualStyleChangedListener,
VisualStyleSetListener,
ColumnVisualStyleSetListener,
ColumnAssociatedVisualStyleSetListener {
    private final CyServiceRegistrar registrar;

    public TableBrowserStyleMediator(CyServiceRegistrar registrar) {
        this.registrar = registrar;
    }

    public void handleEvent(VisualStyleSetEvent e) {
        VisualStyle netStyle = e.getVisualStyle();
        CyNetworkView netView = e.getNetworkView();
        this.updateColumnViews(netView, netStyle, CyNode.class);
        this.updateColumnViews(netView, netStyle, CyEdge.class);
    }

    private void updateColumnViews(CyNetworkView netView, VisualStyle netStyle, Class<? extends CyIdentifiable> tableType) {
        TableVisualMappingManager tvmm = (TableVisualMappingManager)this.registrar.getService(TableVisualMappingManager.class);
        CyTableViewManager tableViewManager = (CyTableViewManager)this.registrar.getService(CyTableViewManager.class);
        Map colStyles = tvmm.getAssociatedColumnVisualStyles(netStyle, tableType);
        CyTable table = TableBrowserStyleMediator.getTable(netView, tableType);
        CyTableView tableView = tableViewManager.getTableView(table);
        if (colStyles != null && tableView != null) {
            for (View colView : tableView.getColumnViews()) {
                VisualStyle colStyle = (VisualStyle)colStyles.get(((CyColumn)colView.getModel()).getName());
                this.updateColumn((View<CyColumn>)colView, colStyle);
            }
        }
    }

    public void handleEvent(VisualStyleChangedEvent e) {
        VisualStyle style = (VisualStyle)e.getSource();
        Set<CyColumnView> columns = this.findColumnsWithDirectStyle(style);
        for (CyColumnView colView : columns) {
            this.updateColumn((View<CyColumn>)colView, style);
        }
        columns = this.findColumnsWithAssociatedStyle(style);
        for (CyColumnView colView : columns) {
            this.updateColumn((View<CyColumn>)colView, style);
        }
    }

    public void handleEvent(ColumnVisualStyleSetEvent e) {
        CyColumnView view = (CyColumnView)e.getColumnView();
        VisualStyle style = e.getVisualStyle();
        this.updateColumn((View<CyColumn>)view, style);
    }

    public void handleEvent(ColumnAssociatedVisualStyleSetEvent e) {
        StyleAssociation association = e.getAssociation();
        Set<CyColumnView> columns = this.findColumnsWithAssociatedStyle(association.networkVisualStyle(), association.colName(), association.tableType());
        for (CyColumnView colView : columns) {
            this.updateColumn((View<CyColumn>)colView, association.columnVisualStyle());
        }
    }

    private void updateColumn(View<CyColumn> view, VisualStyle style) {
        if (style == null) {
            view.clearVisualProperties();
        } else {
            style.apply(view);
        }
    }

    private Set<CyColumnView> findColumnsWithAssociatedStyle(VisualStyle networkVisualStyle, String colName, Class<?> tableType) {
        CyNetworkViewManager networkViewManager = (CyNetworkViewManager)this.registrar.getService(CyNetworkViewManager.class);
        CyTableViewManager tableViewManager = (CyTableViewManager)this.registrar.getService(CyTableViewManager.class);
        VisualMappingManager visualMappingManager = (VisualMappingManager)this.registrar.getService(VisualMappingManager.class);
        HashSet<CyColumnView> views = new HashSet<CyColumnView>();
        Set allNetworkViews = networkViewManager.getNetworkViewSet();
        for (CyNetworkView networkView : allNetworkViews) {
            View colView;
            CyTableView tableView;
            CyTable table;
            VisualStyle netVs = visualMappingManager.getVisualStyle(networkView);
            if (netVs == null || !networkVisualStyle.equals(netVs) || (table = TableBrowserStyleMediator.getTable(networkView, tableType)) == null || (tableView = tableViewManager.getTableView(table)) == null || (colView = tableView.getColumnView(colName)) == null) continue;
            views.add((CyColumnView)colView);
        }
        return views;
    }

    private Set<CyColumnView> findColumnsWithAssociatedStyle(VisualStyle columnVisualStyle) {
        TableVisualMappingManager tableVisualMappingManager = (TableVisualMappingManager)this.registrar.getService(TableVisualMappingManager.class);
        HashSet<CyColumnView> views = new HashSet<CyColumnView>();
        Set associations = tableVisualMappingManager.getAssociations(columnVisualStyle);
        for (StyleAssociation a : associations) {
            Set<CyColumnView> colViews = this.findColumnsWithAssociatedStyle(a.networkVisualStyle(), a.colName(), a.tableType());
            views.addAll(colViews);
        }
        return views;
    }

    private static CyTable getTable(CyNetworkView netView, Class<?> tableType) {
        if (tableType == CyNode.class) {
            return ((CyNetwork)netView.getModel()).getDefaultNodeTable();
        }
        if (tableType == CyEdge.class) {
            return ((CyNetwork)netView.getModel()).getDefaultEdgeTable();
        }
        if (tableType == CyNetworkView.class) {
            return ((CyNetwork)netView.getModel()).getDefaultNetworkTable();
        }
        return null;
    }

    private Set<CyColumnView> findColumnsWithDirectStyle(VisualStyle columnStyle) {
        CyTableManager tableManager = (CyTableManager)this.registrar.getService(CyTableManager.class);
        TableVisualMappingManager visualMappingManager = (TableVisualMappingManager)this.registrar.getService(TableVisualMappingManager.class);
        CyTableViewManager tableViewManager = (CyTableViewManager)this.registrar.getService(CyTableViewManager.class);
        HashSet<CyColumnView> views = new HashSet<CyColumnView>();
        Set tables = tableManager.getAllTables(false);
        for (CyTable table : tables) {
            CyTableView tableView = tableViewManager.getTableView(table);
            if (tableView == null) continue;
            for (View colView : tableView.getColumnViews()) {
                VisualStyle colStyle = visualMappingManager.getVisualStyle(colView);
                if (colStyle == null || !colStyle.equals(columnStyle)) continue;
                views.add((CyColumnView)colView);
            }
        }
        return views;
    }
}

