/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.awt.Component;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.JToolBar;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentTableEvent;
import org.cytoscape.application.events.SetCurrentTableListener;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.TableToolBarComponent;
import org.cytoscape.application.swing.ToolBarComponent;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedEvent;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedListener;
import org.cytoscape.browser.internal.action.TaskFactoryTunableAction;
import org.cytoscape.browser.internal.task.DynamicTableTaskFactory;
import org.cytoscape.browser.internal.task.DynamicTogglableTableTaskFactory;
import org.cytoscape.browser.internal.util.TableBrowserUtil;
import org.cytoscape.browser.internal.util.ViewUtil;
import org.cytoscape.browser.internal.view.AbstractTableBrowser;
import org.cytoscape.browser.internal.view.DefaultTableBrowser;
import org.cytoscape.browser.internal.view.GlobalTableBrowser;
import org.cytoscape.browser.internal.view.TableRenderer;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.events.TableAboutToBeDeletedEvent;
import org.cytoscape.model.events.TableAboutToBeDeletedListener;
import org.cytoscape.model.events.TableAddedEvent;
import org.cytoscape.model.events.TableAddedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.Togglable;

public class TableBrowserMediator
implements SetCurrentNetworkListener,
SetCurrentTableListener,
TableAddedListener,
TableAboutToBeDeletedListener,
CytoPanelComponentSelectedListener {
    private final HashMap<Class<? extends CyIdentifiable>, AbstractTableBrowser> tableBrowsers = new HashMap();
    private final Map<TaskFactory, CyAction> taskMap = new HashMap<TaskFactory, CyAction>();
    private final Map<Object, TaskFactory> provisionerMap = new IdentityHashMap<Object, TaskFactory>();
    private final CyServiceRegistrar serviceRegistrar;

    public TableBrowserMediator(DefaultTableBrowser nodeTableBrowser, DefaultTableBrowser edgeTableBrowser, DefaultTableBrowser networkTableBrowser, GlobalTableBrowser globalTableBrowser, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.tableBrowsers.put(CyNode.class, nodeTableBrowser);
        this.tableBrowsers.put(CyEdge.class, edgeTableBrowser);
        this.tableBrowsers.put(CyNetwork.class, networkTableBrowser);
        this.tableBrowsers.put(null, globalTableBrowser);
        for (AbstractTableBrowser tb : this.tableBrowsers.values()) {
            if (!(tb instanceof DefaultTableBrowser)) continue;
            tb.getTableChooser().addActionListener(e -> {
                CyTableManager tableManager;
                ((DefaultTableBrowser)tb).updateCurrentTable();
                CytoPanel cytoPanel = this.getTableCytoPanel();
                int idx = cytoPanel.indexOfComponent(tb.getComponent());
                if (idx != cytoPanel.getSelectedIndex()) {
                    return;
                }
                CyApplicationManager applicationManager = (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class);
                CyTable table = tb.getCurrentTable();
                if (table != null && !table.equals(applicationManager.getCurrentTable()) && (tableManager = (CyTableManager)serviceRegistrar.getService(CyTableManager.class)).getTable(table.getSUID().longValue()) != null) {
                    applicationManager.setCurrentTable(table);
                }
            });
        }
    }

    public void handleEvent(SetCurrentNetworkEvent evt) {
        this.updateCurrentNetworkTables(evt.getNetwork());
    }

    public void handleEvent(SetCurrentTableEvent evt) {
        CyTable table = evt.getTable();
        if (table == null) {
            return;
        }
        Class<? extends CyIdentifiable> type = this.getTableType(table);
        AbstractTableBrowser tb = this.tableBrowsers.get(type);
        if (tb != null) {
            ViewUtil.invokeOnEDT(() -> {
                if (tb.containsTable(table)) {
                    tb.setCurrentTable(table);
                    this.selectTableBrowser(tb);
                }
            });
        }
    }

    public void handleEvent(TableAddedEvent e) {
        Class<? extends CyIdentifiable> type;
        AbstractTableBrowser tb;
        CyTable table = e.getTable();
        if ((table.isPublic() || TableBrowserUtil.isShowPrivateTables(this.serviceRegistrar)) && (tb = this.tableBrowsers.get(type = this.getTableType(table))) != null) {
            ViewUtil.invokeOnEDT(() -> {
                tb.addTable(table);
                if (tb.getObjectType() == null) {
                    tb.setCurrentTable(table);
                    if (tb.getTableChooser().getItemCount() == 1) {
                        this.serviceRegistrar.registerService((Object)tb, CytoPanelComponent.class);
                        CyApplicationManager appManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
                        if (table.equals(appManager.getCurrentTable())) {
                            this.selectTableBrowser(tb);
                            tb.selectTable(table);
                        }
                    }
                }
            });
        }
    }

    public void handleEvent(TableAboutToBeDeletedEvent e) {
        CyTable table = e.getTable();
        if (table.isPublic() || TableBrowserUtil.isShowPrivateTables(this.serviceRegistrar)) {
            ViewUtil.invokeOnEDTAndWait(() -> {
                for (AbstractTableBrowser tb : this.tableBrowsers.values()) {
                    tb.removeTable(table);
                    if (!tb.isEmpty()) continue;
                    this.serviceRegistrar.unregisterService((Object)tb, CytoPanelComponent.class);
                    ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).setCurrentTable(this.getCurrentTable());
                }
            });
        }
    }

    public void handleEvent(CytoPanelComponentSelectedEvent evt) {
        CytoPanel cytoPanel = evt.getCytoPanel();
        CytoPanelName name = cytoPanel.getCytoPanelName();
        int idx = evt.getSelectedIndex();
        int count = cytoPanel.getCytoPanelComponentCount();
        if (name != AbstractTableBrowser.CYTO_PANEL_NAME || idx < 0 || idx >= count) {
            return;
        }
        Component comp = cytoPanel.getComponentAt(idx);
        if (comp == null) {
            return;
        }
        CyTable table = this.getCurrentTable();
        if (table == null || table.isPublic()) {
            ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).setCurrentTable(table);
        }
    }

    public CyTable getCurrentTable() {
        CytoPanel cytoPanel = this.getTableCytoPanel();
        Component comp = cytoPanel.getSelectedComponent();
        CyTable table = null;
        for (AbstractTableBrowser tb : this.tableBrowsers.values()) {
            if (!tb.getComponent().equals(comp)) continue;
            table = tb.getCurrentTable();
            break;
        }
        return table;
    }

    public TableRenderer getCurrentTableRenderer() {
        CyTable table = this.getCurrentTable();
        return table != null ? this.getTableRenderer(table) : null;
    }

    public AbstractTableBrowser getTableBrowser(TableRenderer renderer) {
        for (AbstractTableBrowser tb : this.tableBrowsers.values()) {
            if (!renderer.equals(tb.getCurrentRenderer())) continue;
            return tb;
        }
        return null;
    }

    public void selectTableBrowser(AbstractTableBrowser tableBrowser) {
        CytoPanel cytoPanel = this.getTableCytoPanel();
        int idx = cytoPanel.indexOfComponent(tableBrowser.getComponent());
        if (idx >= 0 && idx < cytoPanel.getCytoPanelComponentCount() && idx != cytoPanel.getSelectedIndex()) {
            cytoPanel.setSelectedIndex(idx);
        }
    }

    public CytoPanel getTableCytoPanel() {
        return ((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getCytoPanel(AbstractTableBrowser.CYTO_PANEL_NAME);
    }

    public void hideColumn(CyColumn column) {
        CyTable table = column.getTable();
        ViewUtil.invokeOnEDTAndWait(() -> {
            TableRenderer renderer = this.getTableRenderer(table);
            if (renderer != null) {
                renderer.setColumnVisible(column.getName(), false);
            }
        });
    }

    public void toggleTextWrap(CyColumn column) {
        CyTable table = column.getTable();
        ViewUtil.invokeOnEDTAndWait(() -> {
            TableRenderer renderer = this.getTableRenderer(table);
            if (renderer != null) {
                renderer.setTextWrap(column.getName(), !renderer.isTextWrap(column.getName()));
            }
        });
    }

    public boolean isTextWrap(CyColumn column) {
        TableRenderer renderer = this.getTableRenderer(column.getTable());
        return renderer != null ? renderer.isTextWrap(column.getName()) : false;
    }

    public void setOptionsBarVisible(JToolBar toolbar, boolean visible) {
        for (AbstractTableBrowser tb : this.tableBrowsers.values()) {
            if (!tb.getToolBar().equals(toolbar)) continue;
            tb.getOptionsBar().setVisible(visible);
            break;
        }
    }

    public Class<? extends CyIdentifiable> getTableType(CyTable table) {
        CyNetworkTableManager netTableManager = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        return netTableManager.getTableType(table);
    }

    public int getTableCount(Class<? extends CyIdentifiable> type) {
        AbstractTableBrowser tb = this.tableBrowsers.get(type);
        return tb != null ? tb.getTableCount() : 0;
    }

    public void addAction(CyAction action, Map<String, String> props) {
        ViewUtil.invokeOnEDT(() -> {
            if (action.isInNodeTableToolBar()) {
                this.tableBrowsers.get(CyNode.class).getToolBar().addAction(action);
            }
            if (action.isInEdgeTableToolBar()) {
                this.tableBrowsers.get(CyEdge.class).getToolBar().addAction(action);
            }
            if (action.isInNetworkTableToolBar()) {
                this.tableBrowsers.get(CyNetwork.class).getToolBar().addAction(action);
            }
            if (action.isInUnassignedTableToolBar()) {
                this.tableBrowsers.get(null).getToolBar().addAction(action);
            }
        });
    }

    public void removeAction(CyAction action, Map<String, String> props) {
        ViewUtil.invokeOnEDT(() -> {
            if (action.isInNodeTableToolBar()) {
                this.tableBrowsers.get(CyNode.class).getToolBar().removeAction(action);
            }
            if (action.isInEdgeTableToolBar()) {
                this.tableBrowsers.get(CyEdge.class).getToolBar().removeAction(action);
            }
            if (action.isInNetworkTableToolBar()) {
                this.tableBrowsers.get(CyNetwork.class).getToolBar().removeAction(action);
            }
            if (action.isInUnassignedTableToolBar()) {
                this.tableBrowsers.get(null).getToolBar().removeAction(action);
            }
        });
    }

    public void addTableTaskFactory(TableTaskFactory factory, Map<String, String> props) {
        DynamicTableTaskFactory provisioner = factory instanceof Togglable ? new DynamicTogglableTableTaskFactory(factory, this.serviceRegistrar) : new DynamicTableTaskFactory(factory, this.serviceRegistrar);
        this.provisionerMap.put(factory, provisioner);
        this.addTaskFactory(provisioner, props);
    }

    public void removeTableTaskFactory(TableTaskFactory factory, Map<String, String> props) {
        this.removeTaskFactory(this.provisionerMap.get(factory), props);
    }

    public void addTaskFactory(TaskFactory factory, Map<String, String> props) {
        TaskFactoryTunableAction action = props.containsKey("enableFor") ? new TaskFactoryTunableAction(factory, props, this.serviceRegistrar) : new TaskFactoryTunableAction(this.serviceRegistrar, factory, props);
        this.taskMap.put(factory, (CyAction)action);
        this.addAction((CyAction)action, props);
    }

    public void removeTaskFactory(TaskFactory factory, Map<String, String> props) {
        CyAction action = this.taskMap.remove(factory);
        if (action != null) {
            this.removeAction(action, props);
        }
    }

    public void addTableToolBarComponent(TableToolBarComponent tbc, Map<String, String> props) {
        ViewUtil.invokeOnEDTAndWait(() -> {
            AbstractTableBrowser tableBrowser = this.tableBrowsers.get(tbc.getTableType());
            if (tableBrowser != null) {
                tableBrowser.getToolBar().addToolBarComponent((ToolBarComponent)tbc, props);
            }
        });
    }

    public void removeTableToolBarComponent(TableToolBarComponent tbc, Map<String, String> props) {
        ViewUtil.invokeOnEDTAndWait(() -> {
            for (AbstractTableBrowser tb : this.tableBrowsers.values()) {
                tb.getToolBar().removeToolBarComponent((ToolBarComponent)tbc);
            }
        });
    }

    private TableRenderer getTableRenderer(CyTable table) {
        for (AbstractTableBrowser tb : this.tableBrowsers.values()) {
            TableRenderer renderer = tb.getTableRenderer(table);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    private void updateCurrentNetworkTables(CyNetwork network) {
        ViewUtil.invokeOnEDTAndWait(() -> {
            ((DefaultTableBrowser)this.tableBrowsers.get(CyNode.class)).update(network);
            ((DefaultTableBrowser)this.tableBrowsers.get(CyEdge.class)).update(network);
            ((DefaultTableBrowser)this.tableBrowsers.get(CyNetwork.class)).update(network);
            CyTable table = this.getCurrentTable();
            if (table == null || table.isPublic()) {
                ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).setCurrentTable(table);
            }
        });
    }
}

