/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.cytoscape.util.swing.OpenBrowser;

public class OpenURLMenu
extends JMenu {
    private static final long serialVersionUID = 2344898200050965794L;
    private final String value;
    private final Map<String, Map<String, String>> structure;
    private final OpenBrowser openBrowser;

    public OpenURLMenu(String value, Map<String, Map<String, String>> menuStructure, OpenBrowser openBrowser) {
        this.value = value;
        this.structure = menuStructure;
        this.openBrowser = openBrowser;
        this.setBackground(UIManager.getColor("Table.background"));
        Object dispStr = value.length() > 30 ? value.substring(0, 29) + " ... " : value;
        this.setText("<html>Search <strong text=\"#DC143C\">" + (String)dispStr + "</strong> on the web</html>");
        this.buildLinks();
    }

    private void buildLinks() {
        if (this.structure == null) {
            return;
        }
        for (final String category : this.structure.keySet()) {
            JMenu cat = new JMenu(category);
            Map<String, String> children = this.structure.get(category);
            for (final String name : children.keySet()) {
                JMenuItem dbLink = new JMenuItem(name);
                dbLink.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String url = OpenURLMenu.this.structure.get(category).get(name).replace("%ID%", OpenURLMenu.this.value);
                        OpenURLMenu.this.openBrowser.openURL(url);
                    }
                });
                cat.add(dbLink);
            }
            this.add(cat);
        }
    }
}

