/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class DeletionDialog
extends JDialog {
    private JList<String> columnList;
    private JButton cancelButton;
    private JButton deleteButton;
    private JScrollPane deletionPane;
    private final CyTable table;

    public DeletionDialog(Frame parent, CyTable table) {
        super((Window)parent, "Delete Columns", Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.table = table;
        this.initComponents();
    }

    private void initComponents() {
        JLabel deleteLabel = new JLabel("Select columns to be deleted:");
        final Collator collator = Collator.getInstance(Locale.getDefault());
        TreeSet<CyColumn> deletableColumns = new TreeSet<CyColumn>(new Comparator<CyColumn>(){

            @Override
            public int compare(CyColumn c1, CyColumn c2) {
                return collator.compare(c1.getName(), c2.getName());
            }
        });
        for (Object col : this.table.getColumns()) {
            if (col.isImmutable()) continue;
            deletableColumns.add((CyColumn)col);
        }
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (CyColumn col : deletableColumns) {
            listModel.addElement(col.getName());
        }
        this.columnList = new JList(listModel);
        this.deletionPane = new JScrollPane(this.columnList);
        this.deleteButton = new JButton(new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeletionDialog.this.deleteButtonActionPerformed(e);
            }
        });
        this.deleteButton.getAction().setEnabled(false);
        this.cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeletionDialog.this.dispose();
            }
        });
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.deleteButton, (JButton)this.cancelButton);
        this.columnList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int[] selectedIndices = this.columnList.getSelectedIndices();
                this.deleteButton.getAction().setEnabled(selectedIndices != null && selectedIndices.length > 0);
            }
        });
        JPanel contentPane = new JPanel();
        GroupLayout layout = new GroupLayout(contentPane);
        contentPane.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(deleteLabel).addComponent(this.deletionPane, -1, 320, Short.MAX_VALUE).addComponent(buttonPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(deleteLabel).addComponent(this.deletionPane, -1, 240, Short.MAX_VALUE).addComponent(buttonPanel));
        this.setContentPane(contentPane);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.deleteButton.getAction(), (Action)this.cancelButton.getAction());
        this.getRootPane().setDefaultButton(this.deleteButton);
        this.pack();
    }

    private void deleteButtonActionPerformed(ActionEvent e) {
        List<String> selected = this.columnList.getSelectedValuesList();
        for (String name : selected) {
            this.table.deleteColumn(name);
        }
        this.dispose();
    }
}

