/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.TableToolBarComponent;
import org.cytoscape.application.swing.ToolBarComponent;
import org.cytoscape.browser.internal.io.TableColumnStat;
import org.cytoscape.browser.internal.io.TableColumnStatFileIO;
import org.cytoscape.browser.internal.util.CyToolBar;
import org.cytoscape.browser.internal.util.ViewUtil;
import org.cytoscape.browser.internal.view.TableRenderer;
import org.cytoscape.browser.internal.view.tools.AbstractToolBarControl;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.task.read.LoadTableFileTaskFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.events.TableViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.TableViewAboutToBeDestroyedListener;
import org.cytoscape.view.model.events.TableViewAddedEvent;
import org.cytoscape.view.model.events.TableViewAddedListener;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewFactory;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableBrowser
extends JPanel
implements CytoPanelComponent2,
SessionLoadedListener,
SessionAboutToBeSavedListener,
TableViewAddedListener,
TableViewAboutToBeDestroyedListener {
    private final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    public static final CytoPanelName CYTO_PANEL_NAME = CytoPanelName.SOUTH;
    public static final int ICON_WIDTH = 32;
    public static final int ICON_HEIGHT = 31;
    public static final float ICON_FONT_SIZE = 22.0f;
    private static final Dimension PANEL_SIZE = new Dimension(550, 400);
    protected JPanel header;
    protected TableToolBar toolBar;
    protected OptionsBar optionsBar;
    private JPanel dropPanel;
    private final JPanel mainPane = new JPanel();
    private final JLabel dropIconLabel = new JLabel();
    private final JLabel dropLabel = new JLabel("Drag table files here");
    protected final String tabTitle;
    protected CyTable currentTable;
    private final Map<CyTable, TableRenderer> tableRenderers;
    protected final String appFileName;
    protected Class<? extends CyIdentifiable> currentTableType;
    protected TextIcon icon;
    protected final Class<? extends CyIdentifiable> objType;
    protected final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();

    AbstractTableBrowser(String tabTitle, Class<? extends CyIdentifiable> objType, CyServiceRegistrar serviceRegistrar) {
        this.tabTitle = tabTitle;
        this.objType = objType;
        this.serviceRegistrar = serviceRegistrar;
        this.appFileName = tabTitle.replaceAll(" ", "").concat(".props");
        this.tableRenderers = new HashMap<CyTable, TableRenderer>();
        this.init();
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CYTO_PANEL_NAME;
    }

    public String getTitle() {
        return this.tabTitle;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new TextIcon("\uf0ce", ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f), 16, 16);
        }
        return this.icon;
    }

    public Class<? extends CyIdentifiable> getObjectType() {
        return this.objType;
    }

    public CyTable getCurrentTable() {
        return this.currentTable;
    }

    public void setCurrentTable(CyTable currentTable) {
        this.currentTable = currentTable;
        this.update();
    }

    public boolean addTable(CyTable table) {
        if (!this.containsTable(table)) {
            ((DefaultComboBoxModel)this.getTableChooser().getModel()).addElement(table);
            return true;
        }
        return false;
    }

    public void selectTable(CyTable table) {
        this.getTableChooser().setSelectedItem(table);
    }

    public int getTableCount() {
        return this.getTableChooser().getItemCount();
    }

    public boolean containsTable(CyTable table) {
        return ((DefaultComboBoxModel)this.getTableChooser().getModel()).getIndexOf(table) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.tableRenderers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRenderer getTableRenderer(CyTable table) {
        if (table == null) {
            return null;
        }
        TableRenderer renderer = null;
        Object object = this.lock;
        synchronized (object) {
            renderer = this.tableRenderers.get(table);
        }
        if (renderer == null) {
            this.createDefaultTableView(table);
            object = this.lock;
            synchronized (object) {
                renderer = this.tableRenderers.get(table);
            }
        }
        return renderer;
    }

    public TableRenderer getCurrentRenderer() {
        return this.getTableRenderer(this.currentTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTable(CyTable cyTable) {
        DefaultComboBoxModel chooserModel = (DefaultComboBoxModel)this.getTableChooser().getModel();
        chooserModel.removeElement(cyTable);
        TableRenderer renderer = null;
        Object object = this.lock;
        synchronized (object) {
            renderer = this.tableRenderers.remove(cyTable);
        }
        if (renderer == null) {
            return;
        }
        renderer.dispose();
        if (this.currentTable == cyTable) {
            this.currentTable = null;
            this.currentTableType = null;
        }
        if (this.isEmpty()) {
            this.showSelectedTable();
        } else {
            this.update();
        }
    }

    private void init() {
        this.setPreferredSize(PANEL_SIZE);
        this.setSize(PANEL_SIZE);
        this.mainPane.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getHeader(), -1, -1, Short.MAX_VALUE).addComponent(this.mainPane, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getHeader(), -2, -1, -2).addComponent(this.mainPane, -1, -1, Short.MAX_VALUE));
        this.showDropPanel();
        BrowserDropListener dropListener = new BrowserDropListener();
        this.setTransferHandler(dropListener);
        new DropTarget(this, dropListener);
        this.getToolBar().addSpacer(2.1474836E9f);
        if (this.getTableChooser() != null) {
            TableToolBarComponent toolbarComp = new TableToolBarComponent(){

                public Component getComponent() {
                    return AbstractTableBrowser.this.getTableChooser();
                }

                public float getToolBarGravity() {
                    return 2.1474836E9f;
                }

                public Class<? extends CyIdentifiable> getTableType() {
                    return AbstractTableBrowser.this.objType;
                }

                public boolean isApplicable(CyTable table) {
                    return true;
                }
            };
            this.getToolBar().addToolBarComponent((ToolBarComponent)toolbarComp, Collections.emptyMap());
        }
        this.getTableChooser().getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                AbstractTableBrowser.this.updateTableChooser();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                AbstractTableBrowser.this.updateTableChooser();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        this.update();
    }

    protected void update() {
        this.updateToolBar();
        this.getOptionsBar().update();
    }

    private void updateToolBar() {
        this.updateTableChooser();
        this.getHeader().setVisible(this.currentTable != null);
    }

    private void updateTableChooser() {
        int minToShow = this.getObjectType() == null ? 1 : 2;
        this.getTableChooser().setVisible(this.getTableChooser().getItemCount() >= minToShow);
        if (this.currentTable != null && !this.currentTable.equals(this.getTableChooser().getSelectedItem())) {
            this.selectTable(this.currentTable);
        }
    }

    private void showDropPanel() {
        this.mainPane.removeAll();
        this.mainPane.add((Component)this.getDropPanel(), "Center");
    }

    private JPanel getDropPanel() {
        if (this.dropPanel == null) {
            this.dropPanel = new JPanel();
            this.dropPanel.setBackground(UIManager.getColor("Table.background"));
            Color fg = UIManager.getColor("Label.disabledForeground");
            fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 120);
            this.dropPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createDashedBorder(fg, 2.0f, 2.0f, 2.0f, true)));
            this.dropIconLabel.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("/images/drop-table-file-56.png")));
            this.dropIconLabel.setForeground(fg);
            this.dropLabel.setFont(this.dropLabel.getFont().deriveFont(18.0f).deriveFont(1));
            this.dropLabel.setForeground(fg);
            GroupLayout layout = new GroupLayout(this.dropPanel);
            this.dropPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.dropIconLabel, -2, -1, -2).addComponent(this.dropLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.dropIconLabel, -2, -1, -2).addComponent(this.dropLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
        }
        return this.dropPanel;
    }

    protected void showSelectedTable() {
        TableRenderer renderer = this.getCurrentRenderer();
        if (renderer != null) {
            this.mainPane.removeAll();
            this.mainPane.add((Component)renderer.getComponent(), "Center");
            this.mainPane.revalidate();
            this.mainPane.validate();
            this.mainPane.repaint();
        } else {
            this.showDropPanel();
            this.repaint();
        }
        this.update();
    }

    private void createDefaultTableView(CyTable table) {
        CyTableViewManager tableViewManager = (CyTableViewManager)this.serviceRegistrar.getService(CyTableViewManager.class);
        CyTableView tableView = tableViewManager.getTableView(table);
        if (tableView == null) {
            CyTableViewFactory tableViewFactory = (CyTableViewFactory)this.serviceRegistrar.getService(CyTableViewFactory.class);
            tableView = tableViewFactory.createTableView(table);
            tableViewManager.setTableView(tableView);
        }
    }

    private boolean correctType(CyTable table) {
        CyNetworkTableManager networkTableManager = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        Class type = networkTableManager.getTableType(table);
        return Objects.equals(this.objType, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(TableViewAddedEvent e) {
        CyTableView tableView = e.getTableView();
        if (!this.correctType((CyTable)tableView.getModel())) {
            return;
        }
        TableRenderer exitingRenderer = null;
        Object object = this.lock;
        synchronized (object) {
            exitingRenderer = this.tableRenderers.remove(tableView.getModel());
        }
        if (exitingRenderer != null) {
            exitingRenderer.dispose();
        }
        RenderingEngineManager renderingEngineManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        JPanel container = new JPanel();
        TableViewRenderer tableViewRenderer = applicationManager.getTableViewRenderer(tableView.getRendererId());
        RenderingEngineFactory renderingEngineFactory = tableViewRenderer.getRenderingEngineFactory("");
        RenderingEngine renderingEngine = renderingEngineFactory.createRenderingEngine((Object)container, (View)tableView);
        renderingEngineManager.addRenderingEngine(renderingEngine);
        TableRenderer renderer = new TableRenderer((RenderingEngine<CyTable>)renderingEngine, container);
        Object object2 = this.lock;
        synchronized (object2) {
            this.tableRenderers.put((CyTable)tableView.getModel(), renderer);
        }
        this.showSelectedTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(TableViewAboutToBeDestroyedEvent e) {
        CyTableView tableView = e.getTableView();
        TableRenderer exitingRenderer = null;
        Object object = this.lock;
        synchronized (object) {
            exitingRenderer = this.tableRenderers.remove(tableView.getModel());
        }
        if (exitingRenderer != null) {
            exitingRenderer.dispose();
        }
    }

    public void handleEvent(SessionLoadedEvent e) {
        Map<String, TableColumnStat> tscMap = TableColumnStatFileIO.read(e, this.appFileName);
        if (tscMap == null || tscMap.isEmpty()) {
            return;
        }
        Map<CyTable, TableRenderer> browserTablesMap = this.getTableRenderersMap();
        for (CyTable table : browserTablesMap.keySet()) {
            if (!tscMap.containsKey(table.getTitle())) continue;
            TableColumnStat tcs = tscMap.get(table.getTitle());
            TableRenderer renderer = this.getTableRenderer(table);
            List<String> orderedCols = tcs.getOrderedCol();
            List<String> visibleCols = tcs.getVisibleCols();
            for (int i = 0; i < orderedCols.size(); ++i) {
                String colName = orderedCols.get(i);
                renderer.setColumnGravity(colName, i);
                renderer.setColumnVisible(colName, visibleCols.contains(colName));
            }
        }
    }

    public void handleEvent(SessionAboutToBeSavedEvent e) {
        Map<CyTable, TableRenderer> tableRendererMap = this.getTableRenderersMap();
        ArrayList<TableColumnStat> tableColumnStatList = new ArrayList<TableColumnStat>();
        for (CyTable table : tableRendererMap.keySet()) {
            TableColumnStat tcs = new TableColumnStat(table.getTitle());
            TableRenderer renderer = this.getTableRenderer(table);
            List<View<CyColumn>> sortedColViews = renderer.getColumnViewsSortedByGravity();
            for (int i = 0; i < sortedColViews.size(); ++i) {
                View<CyColumn> colView = sortedColViews.get(i);
                boolean vis = renderer.isColumnVisible(colView);
                tcs.addColumnStat(((CyColumn)colView.getModel()).getName(), i, vis);
            }
            tableColumnStatList.add(tcs);
        }
        TableColumnStatFileIO.write(tableColumnStatList, e, this.appFileName);
    }

    protected Map<CyTable, TableRenderer> getTableRenderersMap() {
        return new HashMap<CyTable, TableRenderer>(this.tableRenderers);
    }

    @Override
    public String toString() {
        return "AbstractTableBrowser [tabTitle=" + this.tabTitle + ", currentTable=" + this.currentTable + "]";
    }

    protected JPanel getHeader() {
        if (this.header == null) {
            this.header = new JPanel(new BorderLayout());
            this.header.add((Component)this.getToolBar(), "North");
            this.header.add((Component)this.getOptionsBar(), "South");
        }
        return this.header;
    }

    public TableToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new TableToolBar(this.objType, this.serviceRegistrar);
            this.toolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
        }
        return this.toolBar;
    }

    protected OptionsBar getOptionsBar() {
        if (this.optionsBar == null) {
            this.optionsBar = new OptionsBar();
            this.optionsBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
            this.optionsBar.setVisible(false);
        }
        return this.optionsBar;
    }

    protected abstract JComboBox<CyTable> getTableChooser();

    private class BrowserDropListener
    extends TransferHandler
    implements DropTargetListener {
        private Border originalBorder;

        private BrowserDropListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent evt) {
            this.originalBorder = this.getDropTarget().getBorder();
            this.getDropTarget().setBorder(BorderFactory.createLineBorder(UIManager.getColor("Focus.color"), 2));
        }

        @Override
        public void dragExit(DropTargetEvent evt) {
            this.getDropTarget().setBorder(this.originalBorder);
        }

        @Override
        public void dragOver(DropTargetDragEvent evt) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent evt) {
        }

        @Override
        public void drop(DropTargetDropEvent evt) {
            this.getDropTarget().setBorder(this.originalBorder);
            if (!this.isAcceptable(evt)) {
                evt.rejectDrop();
                return;
            }
            evt.acceptDrop(evt.getDropAction());
            Transferable t = evt.getTransferable();
            if (evt.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List data;
                try {
                    data = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (Exception e) {
                    AbstractTableBrowser.this.logger.error("Cannot load table files by Drag-and-Drop.", (Throwable)e);
                    return;
                }
                new Thread(() -> this.loadFiles(data)).start();
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return this.isAcceptable(info);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            return info.isDrop() && !this.isAcceptable(info);
        }

        private void loadFiles(List<File> data) {
            DialogTaskManager taskManager = (DialogTaskManager)AbstractTableBrowser.this.serviceRegistrar.getService(DialogTaskManager.class);
            LoadTableFileTaskFactory factory = (LoadTableFileTaskFactory)AbstractTableBrowser.this.serviceRegistrar.getService(LoadTableFileTaskFactory.class);
            if (factory != null) {
                this.loadFiles(data.iterator(), taskManager, factory);
            }
        }

        private void loadFiles(final Iterator<File> iterator, final DialogTaskManager taskManager, final LoadTableFileTaskFactory factory) {
            while (iterator.hasNext()) {
                File file = iterator.next();
                if (file.isDirectory()) continue;
                try {
                    taskManager.execute(factory.createTaskIterator(file), new TaskObserver(){

                        public void taskFinished(ObservableTask task) {
                        }

                        public void allFinished(FinishStatus finishStatus) {
                            BrowserDropListener.this.loadFiles(iterator, taskManager, factory);
                        }
                    });
                }
                catch (Exception e) {
                    AbstractTableBrowser.this.logger.error("Cannot load table file by Drag-and-Drop.", (Throwable)e);
                }
                return;
            }
        }

        private boolean isAcceptable(DropTargetDropEvent evt) {
            return evt.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        private boolean isAcceptable(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        private JComponent getDropTarget() {
            return AbstractTableBrowser.this.currentTable == null ? AbstractTableBrowser.this.mainPane : AbstractTableBrowser.this;
        }
    }

    public class TableToolBar
    extends CyToolBar {
        private final Class<? extends CyIdentifiable> objType;

        public TableToolBar(Class<? extends CyIdentifiable> objType, CyServiceRegistrar serviceRegistrar) {
            super(AbstractTableBrowser.this.tabTitle + " Tools", 0, 32, 31, serviceRegistrar);
            this.objType = objType;
        }

        public Class<? extends CyIdentifiable> getObjectType() {
            return this.objType;
        }

        public CyTable getCurrentTable() {
            return AbstractTableBrowser.this.currentTable;
        }
    }

    class OptionsBar
    extends JPanel {
        protected List<AbstractToolBarControl> controls = new ArrayList<AbstractToolBarControl>();

        OptionsBar() {
            this.setLayout(new BoxLayout(this, 2));
        }

        void setFormatControls(List<AbstractToolBarControl> list) {
            this.controls.clear();
            this.removeAll();
            int idx = 0;
            for (AbstractToolBarControl c : list) {
                c.setCurrentTable(AbstractTableBrowser.this.getCurrentTable());
                this.controls.add(c);
                Dimension d = c.getPreferredSize();
                if (d != null) {
                    c.setMaximumSize(d);
                }
                this.add(c);
                JSeparator sep = ViewUtil.createToolBarSeparator();
                sep.setMaximumSize(new Dimension(10, Short.MAX_VALUE));
                this.add(sep);
                if (++idx != list.size()) continue;
                this.add(Box.createHorizontalGlue());
            }
        }

        void update() {
            for (AbstractToolBarControl c : this.controls) {
                c.setCurrentTable(AbstractTableBrowser.this.getCurrentTable());
            }
        }
    }
}

