/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.task;

import org.cytoscape.browser.internal.view.TableBrowserMediator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.task.AbstractTableColumnTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;

public class ToggleTextWrapTask
extends AbstractTableColumnTask {
    private final TableBrowserMediator mediator;

    @ProvidesTitle
    public String getTitle() {
        return "Toggle Text Wrap";
    }

    public ToggleTextWrapTask(CyColumn column, TableBrowserMediator mediator) {
        super(column);
        this.mediator = mediator;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Toggle Text Wrap");
        tm.setStatusMessage("Turning " + (this.mediator.isTextWrap(this.column) ? "off" : "on") + " text wrap for column '" + this.column.getName() + "'...");
        tm.setProgress(-1.0);
        this.mediator.toggleTextWrap(this.column);
    }
}

