/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.task;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.browser.internal.task.ClearErrorsEdit;
import org.cytoscape.browser.internal.task.ErrorEquation;
import org.cytoscape.browser.internal.util.TableBrowserUtil;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableColumnTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class ClearAllErrorsTask
extends AbstractTableColumnTask {
    private final List<ErrorEquation> deletedEquations = new ArrayList<ErrorEquation>();
    private final CyServiceRegistrar serviceRegistrar;

    public ClearAllErrorsTask(CyColumn column, CyServiceRegistrar serviceRegistrar) {
        super(column);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Clear Equation Errors");
        tm.setStatusMessage("Clearing equation errors from column '" + this.column.getName() + "'...");
        CyTable table = this.column.getTable();
        EquationCompiler compiler = (EquationCompiler)this.serviceRegistrar.getService(EquationCompiler.class);
        ArrayList<ErrorEquation> errorEquations = new ArrayList<ErrorEquation>();
        for (CyRow row : table.getAllRows()) {
            Equation eq;
            boolean success;
            if (this.cancelled) {
                return;
            }
            Object raw = row.getRaw(this.column.getName());
            if (!(raw instanceof Equation) || (success = compiler.compile((eq = (Equation)raw).toString(), TableBrowserUtil.getAttNameToTypeMap(table, null))) && row.get(this.column.getName(), this.column.getType()) != null) continue;
            errorEquations.add(new ErrorEquation(row, this.column.getName(), eq));
        }
        for (ErrorEquation err : errorEquations) {
            if (this.cancelled) {
                this.restoreDeletedEquations();
                return;
            }
            this.deletedEquations.add(err);
            err.clear();
        }
        if (!this.deletedEquations.isEmpty()) {
            UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
            undoSupport.postEdit((AbstractCyEdit)new ClearErrorsEdit(this.column.getName(), this.deletedEquations));
        }
    }

    private void restoreDeletedEquations() {
        for (ErrorEquation err : this.deletedEquations) {
            err.restore();
        }
    }
}

