/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal;

import java.awt.Font;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.Icon;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentTableListener;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.TableToolBarComponent;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedListener;
import org.cytoscape.browser.internal.action.CreateColumnAction;
import org.cytoscape.browser.internal.action.DeleteColumnsAction;
import org.cytoscape.browser.internal.action.ShowColumnsAction;
import org.cytoscape.browser.internal.action.TableOptionsAction;
import org.cytoscape.browser.internal.task.ClearAllErrorsTaskFactory;
import org.cytoscape.browser.internal.task.DeleteTableTaskFactoryImpl;
import org.cytoscape.browser.internal.task.HideColumnTaskFactory;
import org.cytoscape.browser.internal.task.SetColumnFormatTaskFactory;
import org.cytoscape.browser.internal.task.ToggleTextWrapTaskFactory;
import org.cytoscape.browser.internal.view.DefaultTableBrowser;
import org.cytoscape.browser.internal.view.GlobalTableBrowser;
import org.cytoscape.browser.internal.view.TableBrowserMediator;
import org.cytoscape.browser.internal.view.TableBrowserStyleMediator;
import org.cytoscape.browser.internal.view.ToolBarEnableUpdater;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.events.TableAboutToBeDeletedListener;
import org.cytoscape.model.events.TableAddedListener;
import org.cytoscape.model.events.TablePrivacyChangedListener;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.task.AbstractTableColumnTaskFactory;
import org.cytoscape.task.TableColumnTaskFactory;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.model.events.TableViewAddedListener;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    private static final String TOOLBAR_FILTER = "(|(inNodeTableToolBar=true)(inEdgeTableToolBar=true)(inNetworkTableToolBar=true)(inUnassignedTableToolBar=true))";
    private static float SMALL_ICON_FONT_SIZE = 14.0f;
    private static int SMALL_ICON_SIZE = 16;

    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        IconManager iconManager = (IconManager)this.getService(bc, IconManager.class);
        DefaultTableBrowser nodeTableBrowser = new DefaultTableBrowser("Node Table", CyNode.class, serviceRegistrar);
        DefaultTableBrowser edgeTableBrowser = new DefaultTableBrowser("Edge Table", CyEdge.class, serviceRegistrar);
        DefaultTableBrowser networkTableBrowser = new DefaultTableBrowser("Network Table", CyNetwork.class, serviceRegistrar);
        GlobalTableBrowser globalTableBrowser = new GlobalTableBrowser("Unassigned Tables", serviceRegistrar);
        this.registerAllServices(bc, nodeTableBrowser);
        this.registerAllServices(bc, edgeTableBrowser);
        this.registerAllServices(bc, networkTableBrowser);
        this.registerService(bc, globalTableBrowser, SessionLoadedListener.class);
        this.registerService(bc, globalTableBrowser, SessionAboutToBeSavedListener.class);
        this.registerService(bc, globalTableBrowser, TablePrivacyChangedListener.class);
        this.registerService(bc, globalTableBrowser, TableViewAddedListener.class);
        AbstractTableColumnTaskFactory factory = new ClearAllErrorsTaskFactory(serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("title", "Clear All Errors");
        props.setProperty("menuGravity", "100.1");
        props.setProperty("insertSeparatorBefore", "true");
        props.setProperty("insertSeparatorAfter", "true");
        this.registerService(bc, factory, TableColumnTaskFactory.class, props);
        factory = new SetColumnFormatTaskFactory(serviceRegistrar);
        props = new Properties();
        props.setProperty("title", "Format Column...");
        props.setProperty("menuGravity", "2.1");
        props.setProperty("insertSeparatorBefore", "true");
        this.registerService(bc, factory, TableColumnTaskFactory.class, props);
        TableBrowserMediator mediator = new TableBrowserMediator(nodeTableBrowser, edgeTableBrowser, networkTableBrowser, globalTableBrowser, serviceRegistrar);
        this.registerService(bc, mediator, CytoPanelComponentSelectedListener.class);
        this.registerService(bc, mediator, SetCurrentNetworkListener.class);
        this.registerService(bc, mediator, SetCurrentTableListener.class);
        this.registerService(bc, mediator, TableAddedListener.class);
        this.registerService(bc, mediator, TableAboutToBeDeletedListener.class);
        ToolBarEnableUpdater toolBarEnableUpdater = new ToolBarEnableUpdater(Arrays.asList(nodeTableBrowser.getToolBar(), edgeTableBrowser.getToolBar(), networkTableBrowser.getToolBar(), globalTableBrowser.getToolBar()), serviceRegistrar);
        this.registerAllServices(bc, toolBarEnableUpdater);
        Font iconFont = iconManager.getIconFont(SMALL_ICON_FONT_SIZE);
        TextIcon icon = new TextIcon("\uf070", iconFont, SMALL_ICON_SIZE, SMALL_ICON_SIZE);
        String iconId = "cy::Table::HIDE_COLUMN_SMALL";
        iconManager.addIcon(iconId, (Icon)icon);
        HideColumnTaskFactory factory2 = new HideColumnTaskFactory(mediator);
        Properties props2 = new Properties();
        props2.setProperty("title", "Hide Column");
        props2.setProperty("menuGravity", "1.1");
        props2.setProperty("insertSeparatorBefore", "true");
        props2.setProperty("smallIconID", iconId);
        this.registerService(bc, (Object)factory2, TableColumnTaskFactory.class, props2);
        ToggleTextWrapTaskFactory factory3 = new ToggleTextWrapTaskFactory(mediator);
        Properties props3 = new Properties();
        props3.setProperty("title", "Wrap Text");
        props3.setProperty("menuGravity", "2.2");
        props3.setProperty("insertSeparatorBefore", "true");
        props3.setProperty("insertSeparatorAfter", "true");
        this.registerService(bc, (Object)factory3, TableColumnTaskFactory.class, props3);
        TableBrowserStyleMediator styleMediator = new TableBrowserStyleMediator(serviceRegistrar);
        this.registerAllServices(bc, styleMediator);
        this.registerServiceListener(bc, mediator::addAction, mediator::removeAction, CyAction.class);
        this.registerServiceListener(bc, mediator::addTaskFactory, mediator::removeTaskFactory, TaskFactory.class, TOOLBAR_FILTER);
        this.registerServiceListener(bc, mediator::addTableTaskFactory, mediator::removeTableTaskFactory, TableTaskFactory.class, TOOLBAR_FILTER);
        this.registerServiceListener(bc, mediator::addTableToolBarComponent, mediator::removeTableToolBarComponent, TableToolBarComponent.class);
        Font iconFont2 = iconManager.getIconFont(17.6f);
        TextIcon icon2 = new TextIcon("\uf013", iconFont2, 32, 31);
        AbstractCyAction action = new TableOptionsAction((Icon)icon2, 0.001f, mediator);
        this.registerService(bc, action, CyAction.class);
        iconFont2 = iconManager.getIconFont("cytoscape-3", 22.0f);
        icon2 = new TextIcon("/", iconFont2, 32, 31);
        action = new ShowColumnsAction((Icon)icon2, 0.002f, mediator, serviceRegistrar);
        this.registerService(bc, action, CyAction.class);
        iconFont2 = iconManager.getIconFont("cytoscape-3", 22.0f);
        icon2 = new TextIcon("-", iconFont2, 32, 31);
        action = new CreateColumnAction((Icon)icon2, 0.003f, mediator, serviceRegistrar);
        this.registerService(bc, action, CyAction.class);
        iconFont2 = iconManager.getIconFont("cytoscape-3", 22.0f);
        icon2 = new TextIcon(".", iconFont2, 32, 31);
        action = new DeleteColumnsAction((Icon)icon2, 0.004f, mediator);
        this.registerService(bc, action, CyAction.class);
        iconFont2 = iconManager.getIconFont(22.0f);
        icon2 = new TextIcon("\uf014", iconFont2, 32, 31);
        String iconId2 = "cy::Table::DELETE_TABLE";
        iconManager.addIcon(iconId2, (Icon)icon2);
        props2 = new Properties();
        props2.setProperty("enableFor", "table");
        props2.setProperty("tooltip", "Delete Table...");
        props2.setProperty("largeIconID", iconId2);
        props2.setProperty("toolBarGravity", "3.4028235E38");
        props2.setProperty("inNodeTableToolBar", "true");
        props2.setProperty("inEdgeTableToolBar", "true");
        props2.setProperty("inNetworkTableToolBar", "true");
        props2.setProperty("inUnassignedTableToolBar", "true");
        DeleteTableTaskFactoryImpl factory4 = new DeleteTableTaskFactoryImpl(mediator, serviceRegistrar);
        this.registerService(bc, (Object)factory4, TableTaskFactory.class, props2);
    }
}

