/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.aMatReader.internal.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.aMatReader.internal.ResourceManager;
import org.cytoscape.aMatReader.internal.rest.AMatReaderResource;
import org.cytoscape.aMatReader.internal.rest.AMatReaderResult;
import org.cytoscape.aMatReader.internal.util.Delimiter;
import org.cytoscape.aMatReader.internal.util.MatrixParser;
import org.cytoscape.aMatReader.internal.util.ResettableBufferedReader;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class AMatReaderTask
extends AbstractTask
implements CyNetworkReader,
ObservableTask {
    private String columnName;
    private AMatReaderResource.AMatReaderResponse response;
    private boolean createView = false;
    private CyNetwork network;
    private final Map<Object, CyNode> nodeMap;
    private final ResettableBufferedReader reader;
    private final ResourceManager rm;
    private final String SOURCE_NAME = "SourceNode";
    private final String TARGET_NAME = "TargetNode";
    @Tunable(description="Delimiter", gravity=11.0, longDescription="Character used to separate values within rows")
    public Delimiter delimiter = Delimiter.TAB;
    @Tunable(description="Treat matrix as undirected", gravity=12.0, longDescription="The matrix of an undirected graph must be symmetric, and only the top triangle of the matrix is imported. Directed graphs make use of the entire matrix")
    public boolean undirected = false;
    @Tunable(description="Ignore zero values", groups={"Advanced Options"}, params="displayState=collapsed", gravity=13.0)
    public boolean ignoreZeros = true;
    @Tunable(description="Interaction type", groups={"Advanced Options"}, params="displayState=collapsed", gravity=14.0, longDescription="Edge interaction type given to edges created by the matrix")
    public String interactionName = "interacts with";
    @Tunable(description="Row names", groups={"Advanced Options"}, params="displayState=collapsed", gravity=15.0, longDescription="True if first column specifies node names. False to use the column names (in a square matrix) or generate node names (if columnNames==False)")
    public boolean rowNames;
    @Tunable(description="Column names", groups={"Advanced Options"}, params="displayState=collapsed", gravity=16.0, longDescription="True if first row specifies node names. False to use the row names (in a square matrix) or generate node names (if rowNames==False)")
    public boolean columnNames;
    @Tunable(description="Remove column prefix", groups={"Advanced Options"}, params="displayState=collapsed", gravity=17.0, longDescription="Column names contain prefixes (common in R and MATLAB files) that should be removed upon import.")
    public boolean removeColumnPrefix;

    @ProvidesTitle
    public String getTitle() {
        return "Adjacency Matrix Reader";
    }

    public AMatReaderTask(ResettableBufferedReader reader, String columnName, ResourceManager rm) {
        this.reader = reader;
        this.nodeMap = new HashMap<Object, CyNode>();
        this.columnName = columnName;
        this.rm = rm;
    }

    public AMatReaderTask(CyNetwork network, ResettableBufferedReader reader, String columnName, ResourceManager rm) {
        this.reader = reader;
        this.network = network;
        this.nodeMap = new HashMap<Object, CyNode>();
        this.columnName = columnName;
        this.rm = rm;
    }

    void createColumns() {
        CyTable edgeTable;
        CyTable nodeTable = this.network.getDefaultNodeTable();
        if (nodeTable.getColumn("Type") == null) {
            nodeTable.createColumn("Type", String.class, false);
        }
        if ((edgeTable = this.network.getDefaultEdgeTable()).getColumn(this.columnName) != null) {
            int n = 2;
            while (edgeTable.getColumn(this.columnName + " " + n) != null) {
                ++n;
            }
            this.columnName = this.columnName + " " + n;
        }
        edgeTable.createColumn(this.columnName, Double.class, false);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        String name;
        int i;
        if (this.delimiter == null) {
            throw new NullPointerException("Delimiter value not recognized");
        }
        MatrixParser.MatrixParameters params = new MatrixParser.MatrixParameters(this.delimiter, this.ignoreZeros, this.rowNames, this.columnNames, this.undirected);
        MatrixParser parser = new MatrixParser(params);
        parser.buildNetwork(this.reader);
        this.reader.close();
        if (this.removeColumnPrefix) {
            parser.removeColumnPrefix();
        }
        if (this.network == null) {
            this.network = this.rm.netFactory.createNetwork();
            this.rm.netManager.addNetwork(this.network);
            this.createView = true;
        } else {
            for (CyNode node : this.network.getNodeList()) {
                String key = (String)this.network.getRow((CyIdentifiable)node).get("name", String.class);
                this.nodeMap.put(key, node);
            }
        }
        this.createColumns();
        for (i = 0; i < parser.getRowCount(); ++i) {
            name = parser.getRowName(i);
            this.createNode(name, "SourceNode");
        }
        for (i = 0; i < parser.getColumnCount(); ++i) {
            name = parser.getColumnName(i);
            this.createNode(name, "TargetNode");
        }
        int newEdgeCount = 0;
        int updatedEdgeCount = 0;
        try {
            Map<Integer, Map<Integer, Double>> edgeMap = parser.getEdges();
            for (int src : edgeMap.keySet()) {
                Map<Integer, Double> tgtMap = edgeMap.get(src);
                String srcName = parser.getRowName(src);
                for (int tgt : tgtMap.keySet()) {
                    Double value;
                    String tgtName = parser.getColumnName(tgt);
                    boolean added = this.createEdge(srcName, tgtName, value = tgtMap.get(tgt));
                    if (added) {
                        ++newEdgeCount;
                        continue;
                    }
                    ++updatedEdgeCount;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Exception("Unable to import matrix. Check your parameters and try again");
        }
        this.rm.eventHelper.flushPayloadEvents();
        if (this.createView && this.network.getEdgeCount() < 10000) {
            this.layoutNetwork(this.network);
        }
        taskMonitor.setProgress(1.0);
        this.response = new AMatReaderResource.AMatReaderResponse(this.network.getSUID(), newEdgeCount, updatedEdgeCount);
    }

    private void layoutNetwork(CyNetwork network) {
        CyNetworkView view = this.buildCyNetworkView(network);
        CyLayoutAlgorithm algor = this.rm.layoutManager.getDefaultLayout();
        TaskIterator itr = algor.createTaskIterator(view, algor.createLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, null);
        this.insertTasksAfterCurrentTask(itr);
    }

    private CyNode createNode(String name, String type) {
        CyTable table = this.network.getDefaultNodeTable();
        try {
            if (table.getColumn("name") == null) {
                table.createColumn("name", String.class, false);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CyNode node = null;
        Collection rows = null;
        try {
            rows = table.getMatchingRows("name", (Object)name);
        }
        catch (NullPointerException e) {
            System.out.println("Unable to get node rows with matching name");
            return null;
        }
        if (this.nodeMap.containsKey(name)) {
            node = this.nodeMap.get(name);
        } else {
            try {
                if (rows != null && rows.size() > 1) {
                    CyRow row = (CyRow)rows.iterator().next();
                    node = this.network.getNode(((Long)row.get("SUID", Long.class)).longValue());
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            if (node == null) {
                node = this.network.addNode();
                this.nodeMap.put(name, node);
                this.network.getRow((CyIdentifiable)node).set("name", (Object)name);
            }
            this.network.getRow((CyIdentifiable)node, "USER").set("name", (Object)name);
            this.network.getRow((CyIdentifiable)node, "USER").set("Type", (Object)type);
        }
        return node;
    }

    private boolean createEdge(String srcName, String tgtName, Double value) {
        CyNode src = this.createNode(srcName, "SourceNode");
        CyNode tgt = this.createNode(tgtName, "TargetNode");
        CyEdge edge = null;
        boolean created = false;
        for (CyEdge e : this.network.getConnectingEdgeList(src, tgt, CyEdge.Type.ANY)) {
            if ((!this.undirected || e.isDirected()) && (this.undirected || !e.isDirected() || e.getSource() != src || e.getTarget() != tgt)) continue;
            edge = e;
        }
        if (edge == null) {
            edge = this.network.addEdge(src, tgt, !this.undirected);
            this.network.getRow((CyIdentifiable)edge).set("interaction", (Object)this.interactionName);
            this.network.getRow((CyIdentifiable)edge).set("name", (Object)String.format("%s (%s) %s", srcName, this.interactionName, tgtName));
            created = true;
        }
        this.network.getDefaultEdgeTable().getRow((Object)edge.getSUID()).set(this.columnName, (Object)value);
        return created;
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        if (network == null) {
            return null;
        }
        Collection views = this.rm.viewManager.getNetworkViews(network);
        if (!views.isEmpty()) {
            return (CyNetworkView)views.iterator().next();
        }
        CyNetworkView resView = this.rm.viewFactory.createNetworkView(network);
        if (this.createView || !views.contains(resView)) {
            this.rm.viewManager.addNetworkView(resView);
        }
        return resView;
    }

    private static final String getResultString(AMatReaderResult result) {
        return "Created " + result.newEdges + " new edges and updated " + result.updatedEdges + " in network with SUID " + result.suid;
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(String.class)) {
            AMatReaderResult result = (AMatReaderResult)this.response.data;
            return (R)AMatReaderTask.getResultString(result);
        }
        if (type.equals(AMatReaderResource.AMatReaderResponse.class)) {
            return (R)((Object)this.response);
        }
        if (type.equals(JSONResult.class)) {
            return (R)AMatReaderTask.getJson((AMatReaderResult)this.response.data);
        }
        return null;
    }

    public static final String getJson(AMatReaderResult result) {
        return "{\"newEdges\": " + result.newEdges + ", \"updatedEdges\": " + result.updatedEdges + ", \"suid\": " + result.suid + "}";
    }

    public List<Class<?>> getResultClasses() {
        return Collections.unmodifiableList(Arrays.asList(String.class, AMatReaderResource.AMatReaderResponse.class, JSONResult.class));
    }

    public CyNetwork[] getNetworks() {
        return new CyNetwork[]{this.network};
    }
}

