/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.aMatReader.internal.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.cytoscape.aMatReader.internal.rest.AMatReaderParameters;
import org.cytoscape.aMatReader.internal.rest.AMatReaderResult;
import org.cytoscape.ci.model.CIResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Apps: aMatReader"})
@Path(value="/aMatReader/v1/")
public interface AMatReaderResource {
    public static final String INVALID_FILE_CODE = "1";
    public static final String INVALID_PARAMETERS_CODE = "2";
    public static final String TASK_EXECUTION_ERROR_CODE = "3";
    public static final String GENERIC_SWAGGER_NOTES = "Adjacency matrix files usually specify the node names in the first column and/or first row \nand all values are delimited by a tab, space, comma, or pipe '|'. This app only allows for integer/floating point values for easy parsing.";
    public static final String IMPORT_NOTES = "Import a adjacency matrix file(s) as a new Cytoscape network. \n";
    public static final String EXTEND_NOTES = "Use adjacency matrix file(s) to add edge attributes to an existing Cytoscape network. \n";
    public static final String PREDICT_NOTES = "Get the suggested parameters for a matrix file by peeking at the first two lines.  NOTE: The parser can not predict if the matrix represents an undirected network.";
    public static final Logger logger = LoggerFactory.getLogger(AMatReaderResource.class);
    public static final String resourceErrorRoot = "urn:cytoscape:ci:aMatReader-app:v1";

    @GET
    @Produces(value={"application/json"})
    @Path(value="predictParameters")
    @ApiOperation(value="Peek at a file to determine if row/column names exist, columns have prefixes.", notes="Get the suggested parameters for a matrix file by peeking at the first two lines.  NOTE: The parser can not predict if the matrix represents an undirected network.", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid or nonexistant file", response=CIResponse.class)})
    public Response aMatReaderPredict(@ApiParam(value="Adjacency matrix file path", required=true, defaultValue="/path/to/matrix.adj") @QueryParam(value="path") String var1);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="import")
    @ApiOperation(value="Import a new network from adjacency matrix file(s)", notes="Import a adjacency matrix file(s) as a new Cytoscape network. \nAdjacency matrix files usually specify the node names in the first column and/or first row \nand all values are delimited by a tab, space, comma, or pipe '|'. This app only allows for integer/floating point values for easy parsing.", response=AMatReaderResponse.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid or nonexistant file", response=CIResponse.class), @ApiResponse(code=401, message="Invalid parameters", response=CIResponse.class)})
    public Response aMatReader(@ApiParam(value="Adjacency matrix import parameters", required=true) AMatReaderParameters var1);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="extend/{networkSUID}")
    @ApiOperation(value="Add an edge attribute column to an existing network from adjacency matrix file(s)", notes="Use adjacency matrix file(s) to add edge attributes to an existing Cytoscape network. \nAdjacency matrix files usually specify the node names in the first column and/or first row \nand all values are delimited by a tab, space, comma, or pipe '|'. This app only allows for integer/floating point values for easy parsing.", response=AMatReaderResponse.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid or nonexistant file", response=CIResponse.class), @ApiResponse(code=401, message="Invalid parameters", response=CIResponse.class)})
    public Response aMatReaderExtend(@ApiParam(value="Network SUID to extend") @PathParam(value="networkSUID") long var1, @ApiParam(value="Adjacency matrix import parameters", required=true) AMatReaderParameters var3);

    @ApiModel(value="aMatReader Response", description="aMatReader new/updated nodes in Cytoscape", parent=CIResponse.class)
    public static class AMatReaderResponse
    extends CIResponse<AMatReaderResult> {
        public AMatReaderResponse(Long suid, int newEdges, int updatedEdges) {
            this.data = new AMatReaderResult(suid, newEdges, updatedEdges);
            this.errors = new ArrayList();
        }

        public void update(AMatReaderResponse resp) {
            ((AMatReaderResult)this.data).newEdges += ((AMatReaderResult)resp.data).newEdges;
            ((AMatReaderResult)this.data).updatedEdges += ((AMatReaderResult)resp.data).updatedEdges;
            ((AMatReaderResult)this.data).suid = ((AMatReaderResult)resp.data).suid;
        }
    }
}

