/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.aMatReader.internal;

import java.util.Properties;
import org.cytoscape.aMatReader.internal.CIServiceManager;
import org.cytoscape.aMatReader.internal.ResourceManager;
import org.cytoscape.aMatReader.internal.rest.AMatReaderResource;
import org.cytoscape.aMatReader.internal.rest.AMatReaderResourceImpl;
import org.cytoscape.aMatReader.internal.tasks.AMatReaderWrapperTaskFactory;
import org.cytoscape.aMatReader.internal.tasks.FileChooserTaskFactory;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class CyActivator
extends AbstractCyActivator {
    private static final String AMATREADER_MENU = "Apps.aMatReader[5.0]";
    private static final String AMATREADER_ACTION = "Import Matrix Files";
    public static CIServiceManager serviceManager;

    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        ResourceManager resourceManager = new ResourceManager(serviceRegistrar);
        StreamUtil streamUtil = (StreamUtil)this.getService(bc, StreamUtil.class);
        Properties menuProps = new Properties();
        menuProps.setProperty("preferredMenu", AMATREADER_MENU);
        menuProps.setProperty("title", AMATREADER_ACTION);
        menuProps.setProperty("inMenuBar", "true");
        menuProps.setProperty("menuGravity", "5.0");
        FileChooserTaskFactory menuTF = new FileChooserTaskFactory(resourceManager);
        this.registerAllServices(bc, (Object)menuTF, menuProps);
        BasicCyFileFilter aMatFileFilter = new BasicCyFileFilter(new String[]{"mat", "adj"}, new String[]{"application/text"}, "Adjacency Matrix Reader", DataCategory.NETWORK, streamUtil);
        AMatReaderWrapperTaskFactory wrapperService = new AMatReaderWrapperTaskFactory(resourceManager, (CyFileFilter)aMatFileFilter);
        Properties wrapperProps = new Properties();
        wrapperProps.setProperty("readerDescription", "Matrix reader");
        wrapperProps.setProperty("readerId", "aMatReader");
        wrapperProps.setProperty("inMenuBar", "false");
        this.registerAllServices(bc, (Object)wrapperService, wrapperProps);
        try {
            serviceManager = new CIServiceManager(bc);
            AMatReaderResourceImpl restService = new AMatReaderResourceImpl(serviceRegistrar, resourceManager);
            this.registerService(bc, restService, AMatReaderResource.class);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void shutDown() {
        super.shutDown();
        serviceManager.close();
    }
}

