/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.webservice.biomart.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckBoxJList
extends JList
implements ListSelectionListener {
    private static final long serialVersionUID = 8204477191024405955L;
    public static final String LIST_UPDATED = "LIST_UPDATED";
    private HashSet<Integer> selectionCache = new HashSet();

    public CheckBoxJList() {
        this.setCellRenderer(new CheckBoxListCellRenderer());
        this.addListSelectionListener(this);
    }

    public void setSelectedItems(List<String> selected) {
        ListSelectionListener[] listeners;
        for (ListSelectionListener l : listeners = this.getListSelectionListeners()) {
            this.removeListSelectionListener(l);
        }
        this.getSelectionModel().clearSelection();
        this.selectionCache.clear();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            if (!selected.contains(this.getModel().getElementAt(i))) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
            this.selectionCache.add(i);
        }
        for (ListSelectionListener l : listeners) {
            this.addListSelectionListener(l);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            this.removeListSelectionListener(this);
            HashSet<Integer> newSelections = new HashSet<Integer>();
            int size = this.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                if (!this.getSelectionModel().isSelectedIndex(i)) continue;
                newSelections.add(i);
            }
            for (Integer index : this.selectionCache) {
                this.getSelectionModel().addSelectionInterval(index, index);
            }
            for (Integer index : newSelections) {
                if (this.selectionCache.contains(index)) {
                    this.getSelectionModel().removeSelectionInterval(index, index);
                    continue;
                }
                this.getSelectionModel().addSelectionInterval(index, index);
            }
            this.selectionCache.clear();
            for (int i = 0; i < size; ++i) {
                if (!this.getSelectionModel().isSelectedIndex(i)) continue;
                this.selectionCache.add(i);
            }
            this.addListSelectionListener(this);
            this.firePropertyChange(LIST_UPDATED, null, null);
        }
    }

    private final class CheckBoxListCellRenderer
    extends JComponent
    implements ListCellRenderer {
        private static final long serialVersionUID = 3002151884598694214L;
        private final DefaultListCellRenderer defaultComp;
        private final JCheckBox checkbox;
        private final BorderLayout layout = new BorderLayout();

        public CheckBoxListCellRenderer() {
            this.setLayout(this.layout);
            this.defaultComp = new DefaultListCellRenderer();
            this.checkbox = new JCheckBox();
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.defaultComp, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.defaultComp.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.checkbox.setSelected(isSelected);
            this.checkbox.setForeground(UIManager.getColor(isSelected ? "Table.selectionForeground" : "Table.foreground"));
            this.checkbox.setBackground(UIManager.getColor(isSelected ? "Table.selectionBackground" : "Table.background"));
            this.defaultComp.setForeground(UIManager.getColor(isSelected ? "Table.selectionForeground" : "Table.foreground"));
            this.defaultComp.setBackground(UIManager.getColor(isSelected ? "Table.selectionBackground" : "Table.background"));
            Component[] comps = this.getComponents();
            int length = comps.length;
            for (int i = 0; i < length; ++i) {
                comps[i].setBackground(UIManager.getColor(isSelected ? "Table.selectionBackground" : "Table.background"));
                comps[i].setForeground(UIManager.getColor(isSelected ? "Table.selectionForeground" : "Table.foreground"));
            }
            return this;
        }
    }
}

