/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.webservice.biomart.ui;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.io.webservice.biomart.ui.CheckBoxJList;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public abstract class AttributeImportPanel
extends JPanel
implements ColumnCreatedListener,
ColumnDeletedListener,
SetCurrentNetworkListener {
    protected JComboBox<String> columnNameComboBox;
    protected JLabel attributeLabel;
    protected JPanel attributePanel;
    protected JComboBox<String> attributeTypeComboBox;
    protected JLabel attributeTypeLabel;
    protected JButton cancelButton;
    protected JComboBox<String> databaseComboBox;
    protected JPanel databasePanel;
    protected JPanel attrListPanel;
    protected JPanel availableAttrPanel;
    protected JScrollPane availableAttrScrollPane;
    protected JButton importButton;
    protected JLabel titleLabel;
    protected JButton selectAllButton;
    protected JButton selectNoneButton;
    protected JButton refreshButton;
    protected CheckBoxJList attrCheckboxList;
    protected DefaultListModel attrCheckboxListModel;
    protected String panelTitle;
    protected Icon logo;
    protected String attributePanelTitle;
    private boolean defKeyStrokesAdded;
    protected final CyServiceRegistrar serviceRegistrar;

    protected AttributeImportPanel(Icon logo, String title, String attrPanelTitle, CyServiceRegistrar serviceRegistrar) {
        this.logo = logo;
        this.panelTitle = title;
        this.attributePanelTitle = attrPanelTitle;
        this.serviceRegistrar = serviceRegistrar;
        this.initComponents();
        this.setAttributeComboBox();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ae) {
                if (AttributeImportPanel.this.getRootPane() != null) {
                    AttributeImportPanel.this.getRootPane().setDefaultButton(AttributeImportPanel.this.getImportButton());
                    if (!AttributeImportPanel.this.defKeyStrokesAdded) {
                        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)AttributeImportPanel.this.getRootPane(), (Action)AttributeImportPanel.this.getImportButton().getAction(), (Action)AttributeImportPanel.this.getCancelButton().getAction());
                        AttributeImportPanel.this.defKeyStrokesAdded = true;
                    }
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ae) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ae) {
            }
        });
    }

    private void initComponents() {
        this.attrCheckboxList = new CheckBoxJList();
        this.attrCheckboxListModel = new DefaultListModel();
        this.attrCheckboxList.setModel(this.attrCheckboxListModel);
        this.titleLabel = new JLabel(this.panelTitle);
        this.titleLabel.setIcon(this.logo);
        this.databasePanel = new JPanel();
        this.databaseComboBox = new JComboBox();
        this.attributePanel = new JPanel();
        this.attributeLabel = new JLabel("Column:");
        this.columnNameComboBox = new JComboBox();
        this.attributeTypeLabel = new JLabel("Data Type:");
        this.attributeTypeComboBox = new JComboBox();
        this.availableAttrPanel = new JPanel();
        this.availableAttrScrollPane = new JScrollPane();
        this.attrListPanel = new JPanel();
        this.selectAllButton = new JButton("Select All");
        this.selectNoneButton = new JButton("Select None");
        if (LookAndFeelUtil.isAquaLAF()) {
            this.selectAllButton.putClientProperty("JButton.buttonType", "gradient");
            this.selectAllButton.putClientProperty("JComponent.sizeVariant", "small");
            this.selectNoneButton.putClientProperty("JButton.buttonType", "gradient");
            this.selectNoneButton.putClientProperty("JComponent.sizeVariant", "small");
        }
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.selectAllButton, this.selectNoneButton});
        IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
        this.refreshButton = new JButton("\uf141");
        this.refreshButton.setFont(iconManager.getIconFont(14.0f));
        this.refreshButton.setToolTipText("Select Services...");
        this.databasePanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"Service"));
        this.databaseComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeImportPanel.this.databaseComboBoxActionPerformed(evt);
            }
        });
        this.databaseComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setToolTipText(value != null ? value.toString() : null);
                return this;
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeImportPanel.this.refreshButtonActionPerformed(evt);
            }
        });
        GroupLayout databasePanelLayout = new GroupLayout(this.databasePanel);
        this.databasePanel.setLayout(databasePanelLayout);
        databasePanelLayout.setAutoCreateContainerGaps(true);
        databasePanelLayout.setAutoCreateGaps(true);
        databasePanelLayout.setHorizontalGroup(databasePanelLayout.createSequentialGroup().addComponent(this.databaseComboBox, 200, 700, Short.MAX_VALUE).addComponent(this.refreshButton, -2, -1, -2));
        databasePanelLayout.setVerticalGroup(databasePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.databaseComboBox, -2, -1, -2).addComponent(this.refreshButton, -2, -1, -2));
        this.attributePanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"Key Column in Cytoscape"));
        GroupLayout attributePanelLayout = new GroupLayout(this.attributePanel);
        this.attributePanel.setLayout(attributePanelLayout);
        attributePanelLayout.setAutoCreateContainerGaps(true);
        attributePanelLayout.setAutoCreateGaps(true);
        attributePanelLayout.setHorizontalGroup(attributePanelLayout.createSequentialGroup().addGroup(attributePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.attributeLabel).addComponent(this.attributeTypeLabel)).addGroup(attributePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.attributeTypeComboBox, -1, -1, Short.MAX_VALUE).addComponent(this.columnNameComboBox, -1, -1, Short.MAX_VALUE)));
        attributePanelLayout.setVerticalGroup(attributePanelLayout.createSequentialGroup().addGroup(attributePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.attributeLabel).addComponent(this.columnNameComboBox, -2, -1, -2)).addGroup(attributePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.attributeTypeLabel).addComponent(this.attributeTypeComboBox, -2, -1, -2)));
        this.availableAttrPanel.setBorder(LookAndFeelUtil.createTitledBorder((String)this.attributePanelTitle));
        this.availableAttrScrollPane.setHorizontalScrollBarPolicy(31);
        this.availableAttrScrollPane.setViewportView(this.attrCheckboxList);
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeImportPanel.this.selectAllButtonActionPerformed(evt);
            }
        });
        this.selectNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeImportPanel.this.selectNoneButtonActionPerformed(evt);
            }
        });
        GroupLayout availableAttrPanelLayout = new GroupLayout(this.availableAttrPanel);
        this.availableAttrPanel.setLayout(availableAttrPanelLayout);
        availableAttrPanelLayout.setAutoCreateContainerGaps(true);
        availableAttrPanelLayout.setAutoCreateGaps(true);
        availableAttrPanelLayout.setHorizontalGroup(availableAttrPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.availableAttrScrollPane, -1, -1, Short.MAX_VALUE).addGroup(availableAttrPanelLayout.createSequentialGroup().addComponent(this.selectAllButton, -2, -1, -2).addComponent(this.selectNoneButton, -2, -1, -2)));
        availableAttrPanelLayout.setVerticalGroup(availableAttrPanelLayout.createSequentialGroup().addComponent(this.availableAttrScrollPane, -1, 280, Short.MAX_VALUE).addGroup(availableAttrPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.selectAllButton, -2, -1, -2).addComponent(this.selectNoneButton, -2, -1, -2)));
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.getImportButton(), (JButton)this.getCancelButton());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.titleLabel).addComponent(this.databasePanel, -1, -1, Short.MAX_VALUE).addComponent(this.attributePanel, -1, -1, Short.MAX_VALUE).addComponent(this.availableAttrPanel, -1, 800, Short.MAX_VALUE).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.titleLabel).addComponent(this.databasePanel, -2, -1, -2).addComponent(this.attributePanel, -2, -1, -2).addComponent(this.availableAttrPanel, -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -2, -1, -2));
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
            }
        });
    }

    protected abstract void selectNoneButtonActionPerformed(ActionEvent var1);

    protected abstract void selectAllButtonActionPerformed(ActionEvent var1);

    protected abstract void refreshButtonActionPerformed(ActionEvent var1);

    protected abstract void databaseComboBoxActionPerformed(ActionEvent var1);

    protected abstract void importAttributes();

    private void setAttributeComboBox() {
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        Set networks = netManager.getNetworkSet();
        for (CyNetwork network : networks) {
            CyTable nodeTable = network.getDefaultNodeTable();
            Collection columns = nodeTable.getColumns();
            for (CyColumn col : columns) {
                this.columnNameComboBox.addItem(col.getName());
            }
        }
        this.columnNameComboBox.setSelectedItem("shared name");
    }

    protected void addAttribute(String attributeName) {
        if (attributeName == null) {
            return;
        }
        Object currentSelection = this.columnNameComboBox.getSelectedItem();
        TreeSet<String> attrNameSet = new TreeSet<String>();
        attrNameSet.add(attributeName);
        for (int i = 0; i < this.columnNameComboBox.getItemCount(); ++i) {
            attrNameSet.add(this.columnNameComboBox.getItemAt(i).toString());
        }
        this.columnNameComboBox.removeAllItems();
        for (String name : attrNameSet) {
            this.columnNameComboBox.addItem(name);
        }
        if (currentSelection != null) {
            this.columnNameComboBox.setSelectedItem(currentSelection.toString());
        }
    }

    protected void removeAttribute(String attributeName) {
        if (attributeName != null) {
            this.columnNameComboBox.removeItem(attributeName);
            return;
        }
    }

    private boolean validTable(CyTable t) {
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        for (CyNetwork network : netManager.getNetworkSet()) {
            if (!t.equals(network.getDefaultNodeTable())) continue;
            return true;
        }
        return false;
    }

    public void handleEvent(final ColumnCreatedEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AttributeImportPanel.this.validTable((CyTable)e.getSource())) {
                    AttributeImportPanel.this.addAttribute(e.getColumnName());
                }
            }
        });
    }

    public void handleEvent(final ColumnDeletedEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AttributeImportPanel.this.validTable((CyTable)e.getSource())) {
                    AttributeImportPanel.this.removeAttribute(e.getColumnName());
                }
            }
        });
    }

    public void handleEvent(final SetCurrentNetworkEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AttributeImportPanel.this.updateColumnList(e.getNetwork() != null ? e.getNetwork().getDefaultNodeTable() : null);
            }
        });
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Window container = (Window)AttributeImportPanel.this.getRootPane().getParent();
                    container.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton(new AbstractAction("Import"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeImportPanel.this.importAttributes();
                }
            });
        }
        return this.importButton;
    }

    private void updateColumnList(CyTable currentNodeTable) {
        TreeSet<String> attrNameSet = new TreeSet<String>();
        if (currentNodeTable != null) {
            Collection columns = currentNodeTable.getColumns();
            for (CyColumn col : columns) {
                attrNameSet.add(col.getName());
            }
        }
        this.columnNameComboBox.removeAllItems();
        for (String name : attrNameSet) {
            this.columnNameComboBox.addItem(name);
        }
        this.columnNameComboBox.setSelectedItem("shared name");
    }
}

