/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.webservice.biomart.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.io.webservice.biomart.BiomartQuery;
import org.cytoscape.io.webservice.biomart.rest.BiomartRestClient;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.task.edit.ImportDataTableTaskFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class ImportTableTask
extends AbstractTask {
    private final BiomartRestClient client;
    private final BiomartQuery query;
    private final CyTableFactory tableFactory;
    private Set<CyTable> tables;
    private final CyTableManager tableManager;
    private final ImportDataTableTaskFactory mapNetworkAttrTF;

    public ImportTableTask(BiomartRestClient client, BiomartQuery query, CyTableFactory tableFactory, CyTableManager tableManager, ImportDataTableTaskFactory mapNetworkAttrTF) {
        this.client = client;
        this.query = query;
        this.tableFactory = tableFactory;
        this.tableManager = tableManager;
        this.mapNetworkAttrTF = mapNetworkAttrTF;
        this.tables = new HashSet<CyTable>();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.query == null) {
            throw new NullPointerException("Query is null");
        }
        taskMonitor.setProgress(0.0);
        taskMonitor.setTitle("Loading data table from BioMart...");
        taskMonitor.setStatusMessage("Loading data...");
        BufferedReader result = this.client.sendQuery(this.query.getQueryString());
        if (!result.ready()) {
            result.close();
            throw new IOException("Could not get result.");
        }
        taskMonitor.setStatusMessage("Creating global table...");
        CyTable newTable = this.createGlobalTable(result, this.query.getKeyColumnName());
        result.close();
        this.tables.add(newTable);
        TaskIterator ti = this.mapNetworkAttrTF.createTaskIterator(newTable);
        this.insertTasksAfterCurrentTask(ti);
    }

    private CyTable createGlobalTable(BufferedReader reader, String key) throws IOException {
        String line = reader.readLine();
        String[] columnNames = line.split("\\t");
        if (columnNames[0].contains("Query ERROR")) {
            throw new IOException("BioMart service returns error: \n" + line);
        }
        CyTable globalTable = this.tableFactory.createTable(this.query.getTableName(), key, String.class, false, true);
        int recordCount = 0;
        ArrayList report = new ArrayList();
        int colSize = columnNames.length;
        int keyIdx = 0;
        for (int i = 0; i < colSize; ++i) {
            if (columnNames[i].equals(key)) {
                keyIdx = i;
                continue;
            }
            globalTable.createColumn(columnNames[i], String.class, false);
        }
        Object ids = null;
        String keyVal = null;
        int rowLength = 0;
        boolean hitCount = false;
        long start = System.currentTimeMillis();
        while ((line = reader.readLine()) != null) {
            String[] row = line.split("\\t");
            if (row.length <= keyIdx || row.length == 0) continue;
            ++recordCount;
            keyVal = row[keyIdx];
            rowLength = row.length;
            CyRow cyRow = globalTable.getRow((Object)keyVal);
            for (int j = 0; j < rowLength; ++j) {
                String val = row[j];
                if (val == null || val.length() == 0) continue;
                cyRow.set(columnNames[j], (Object)val);
            }
        }
        reader.close();
        reader = null;
        this.tableManager.addTable(globalTable);
        return globalTable;
    }

    public Set<CyTable> getCyTables() {
        return this.tables;
    }
}

