/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.webservice.biomart.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cytoscape.io.webservice.biomart.rest.Attribute;
import org.cytoscape.io.webservice.biomart.rest.Dataset;
import org.cytoscape.io.webservice.biomart.rest.Filter;
import org.cytoscape.io.webservice.biomart.rest.XMLQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BiomartRestClient {
    private static final Logger logger = LoggerFactory.getLogger(BiomartRestClient.class);
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int READ_TIMEOUT = 5000;
    private String baseURL;
    private static final String RESOURCE = "/settings/filterconversion.txt";
    private static final String TAXONOMY_TABLE = "/settings/tax_report.txt";
    private Map<String, Map<String, String>> databases = null;
    private Map<String, String> datasourceMap = new HashMap<String, String>();
    private Map<String, Map<String, String>> filterConversionMap;
    private Map<String, String> taxonomyTable;
    private static final int BUFFER_SIZE = 81920;

    public BiomartRestClient(String baseURL) {
        if (baseURL == null) {
            throw new NullPointerException("Biomart base URL is missing.");
        }
        this.baseURL = baseURL + "?";
        try {
            this.loadConversionFile();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't initialize BiomartRestClient", ioe);
        }
        logger.debug("Biomart REST client initialized.");
    }

    private void loadConversionFile() throws IOException {
        String line;
        this.filterConversionMap = new HashMap<String, Map<String, String>>();
        InputStreamReader inFile = new InputStreamReader(this.getClass().getResource(RESOURCE).openStream(), Charset.forName("UTF-8").newDecoder());
        BufferedReader inBuffer = new BufferedReader(inFile);
        String oldName = null;
        HashMap<String, String> oneEntry = new HashMap<String, String>();
        while ((line = inBuffer.readLine()) != null) {
            String trimed = line.trim();
            String[] dbparts = trimed.split("\\t");
            if (!dbparts[0].equals(oldName)) {
                oneEntry = new HashMap();
                oldName = dbparts[0];
                this.filterConversionMap.put(oldName, oneEntry);
            }
            oneEntry.put(dbparts[1], dbparts[2]);
        }
        inFile.close();
        inBuffer.close();
    }

    public String toAttributeName(String dbName, String filterID) {
        if (this.filterConversionMap.get(dbName) == null) {
            return null;
        }
        return this.filterConversionMap.get(dbName).get(filterID);
    }

    public void setBaseURL(String baseURL) {
        if (baseURL == null) {
            throw new NullPointerException("URL string is null.");
        }
        this.baseURL = baseURL + "?";
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public Map<String, Map<String, String>> getRegistry() throws IOException, ParserConfigurationException, SAXException {
        if (this.databases != null) {
            return this.databases;
        }
        this.databases = new HashMap<String, Map<String, String>>();
        String reg = "type=registry";
        URL targetURL = new URL(this.baseURL + "type=registry");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStream is = targetURL.openStream();
        Document registry = builder.parse(is);
        NodeList locations = registry.getElementsByTagName("MartURLLocation");
        int locSize = locations.getLength();
        for (int i = 0; i < locSize; ++i) {
            NamedNodeMap attrList = locations.item(i).getAttributes();
            int attrLen = attrList.getLength();
            String dbID = attrList.getNamedItem("name").getNodeValue();
            HashMap<String, String> entry = new HashMap<String, String>();
            for (int j = 0; j < attrLen; ++j) {
                entry.put(attrList.item(j).getNodeName(), attrList.item(j).getNodeValue());
            }
            this.databases.put(dbID, entry);
        }
        is.close();
        is = null;
        return this.databases;
    }

    public Map<String, String> getAvailableDatasets(String martName) throws IOException {
        String s;
        try {
            this.getRegistry();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        HashMap<String, String> datasources = new HashMap<String, String>();
        Map<String, String> detail = this.databases.get(martName);
        String urlStr = "http://" + detail.get("host") + ":" + detail.get("port") + detail.get("path") + "?type=datasets&mart=" + detail.get("name");
        URL url = new URL(urlStr);
        URLConnection connection = url.openConnection();
        connection.setReadTimeout(5000);
        connection.setConnectTimeout(3000);
        InputStream is = connection.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((s = reader.readLine()) != null) {
            String[] parts = s.split("\\t");
            if (parts.length <= 4 || !parts[3].equals("1")) continue;
            datasources.put(parts[1], parts[2]);
            this.datasourceMap.put(parts[1], martName);
        }
        is.close();
        reader.close();
        reader = null;
        is = null;
        return datasources;
    }

    public Map<String, String> getFilters(String datasetName, boolean getAll) throws IOException {
        String s;
        HashMap<String, String> filters = new HashMap<String, String>();
        String martName = this.datasourceMap.get(datasetName);
        Map<String, String> detail = this.databases.get(martName);
        String urlStr = "http://" + detail.get("host") + ":" + detail.get("port") + detail.get("path") + "?virtualschema=" + detail.get("serverVirtualSchema") + "&type=filters&dataset=" + datasetName;
        URL url = new URL(urlStr);
        InputStream is = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((s = reader.readLine()) != null) {
            String[] parts = s.split("\\t");
            if (parts.length <= 1 || (!parts[1].contains("ID(s)") && !parts[1].contains("Accession(s)") && !parts[1].contains("IDs") || parts[0].startsWith("with_") || parts[0].endsWith("-2")) && (parts.length <= 6 || !parts[5].equals("id_list"))) continue;
            filters.put(parts[1], parts[0]);
        }
        is.close();
        reader.close();
        reader = null;
        is = null;
        return filters;
    }

    public Map<String, String[]> getAttributes(String datasetName) throws IOException {
        String s;
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        String martName = this.datasourceMap.get(datasetName);
        Map<String, String> detail = this.databases.get(martName);
        String urlStr = "http://" + detail.get("host") + ":" + detail.get("port") + detail.get("path") + "?virtualschema=" + detail.get("serverVirtualSchema") + "&type=attributes&dataset=" + datasetName;
        URL url = new URL(urlStr);
        InputStream is = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((s = reader.readLine()) != null) {
            String[] parts = s.split("\\t");
            String[] attrInfo = new String[3];
            if (parts.length == 0) continue;
            if (parts.length == 4) {
                attrInfo[0] = parts[1];
                attrInfo[1] = parts[2];
                attrInfo[2] = parts[3];
            } else if (parts.length > 1) {
                attrInfo[0] = parts[1];
            }
            attributes.put(parts[0], attrInfo);
        }
        is.close();
        reader.close();
        reader = null;
        is = null;
        return attributes;
    }

    public BufferedReader sendQuery(String xmlQuery) throws IOException {
        URL url = new URL(this.baseURL);
        URLConnection uc = url.openConnection();
        uc.setDoOutput(true);
        uc.setRequestProperty("User-Agent", "Java URLConnection");
        OutputStream os = uc.getOutputStream();
        String postStr = "query=" + xmlQuery;
        PrintStream ps = new PrintStream(os);
        ps.print(postStr);
        os.close();
        ps.close();
        ps = null;
        os = null;
        return new BufferedReader(new InputStreamReader(uc.getInputStream()), 81920);
    }

    private String taxID2datasource(String ncbiTaxID) throws IOException {
        if (this.taxonomyTable == null) {
            String line;
            InputStreamReader inFile = new InputStreamReader(this.getClass().getResource(TAXONOMY_TABLE).openStream());
            BufferedReader inBuffer = new BufferedReader(inFile);
            this.taxonomyTable = new HashMap<String, String>();
            String name1 = null;
            String name2 = null;
            while ((line = inBuffer.readLine()) != null) {
                String trimed = line.trim();
                String[] dbparts = trimed.split("\\t");
                String[] spName = dbparts[0].split(" ");
                name1 = spName[0].substring(0, 1);
                name2 = spName[1];
                this.taxonomyTable.put(dbparts[1], (name1 + name2).toLowerCase());
            }
            inFile.close();
            inBuffer.close();
        }
        if (this.taxonomyTable.get(ncbiTaxID) == null) {
            return null;
        }
        return this.taxonomyTable.get(ncbiTaxID) + "_gene_ensembl";
    }

    public List<String[]> getAllGOAnnotations(String ncbiTaxID) throws IOException {
        ArrayList<String[]> res = new ArrayList<String[]>();
        String dbName = this.taxID2datasource(ncbiTaxID);
        if (dbName == null) {
            return res;
        }
        Dataset dataset = new Dataset(dbName);
        Attribute[] attrs = new Attribute[]{new Attribute("ensembl_gene_id"), new Attribute("go"), new Attribute("evidence_code")};
        Filter[] filters = new Filter[]{new Filter("with_go", null)};
        String query2 = XMLQueryBuilder.getQueryString(dataset, attrs, filters);
        BufferedReader reader = this.sendQuery(query2);
        String line = reader.readLine();
        String[] parts = line.split("\\t");
        res.add(parts);
        while ((line = reader.readLine()) != null) {
            parts = line.split("\\t");
            res.add(parts);
        }
        reader.close();
        reader = null;
        return res;
    }

    public List<String[]> getAllAliases(String ncbiTaxID) throws IOException {
        ArrayList<String[]> res = new ArrayList<String[]>();
        String dbName = this.taxID2datasource(ncbiTaxID);
        return res;
    }
}

