/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.webservice.biomart;

import org.cytoscape.io.webservice.TableImportWebServiceClient;
import org.cytoscape.io.webservice.biomart.BiomartQuery;
import org.cytoscape.io.webservice.biomart.rest.BiomartRestClient;
import org.cytoscape.io.webservice.biomart.task.ImportTableTask;
import org.cytoscape.io.webservice.biomart.ui.BiomartAttrMappingPanel;
import org.cytoscape.io.webservice.swing.AbstractWebServiceGUIClient;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.task.edit.ImportDataTableTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class BiomartClient
extends AbstractWebServiceGUIClient
implements TableImportWebServiceClient {
    private final CyTableFactory tableFactory;
    private final BiomartRestClient restClient;
    private ImportTableTask importTask;
    private final CyTableManager tableManager;
    private final ImportDataTableTaskFactory importNetworkAttrTF;

    public BiomartClient(String displayName, String description, BiomartRestClient restClient, CyTableFactory tableFactory, CyTableManager tableManager, BiomartAttrMappingPanel gui, ImportDataTableTaskFactory importNetworkAttrTF) {
        super(restClient.getBaseURL(), displayName, description);
        this.tableFactory = tableFactory;
        this.restClient = restClient;
        this.tableManager = tableManager;
        this.importNetworkAttrTF = importNetworkAttrTF;
        this.gui = gui;
    }

    public BiomartRestClient getRestClient() {
        return this.restClient;
    }

    public TaskIterator createTaskIterator(Object query) {
        if (this.gui == null) {
            throw new IllegalStateException("Could not build query because Query Builder GUI is null.");
        }
        this.importTask = new ImportTableTask(this.restClient, (BiomartQuery)query, this.tableFactory, this.tableManager, this.importNetworkAttrTF);
        return new TaskIterator(new Task[]{this.importTask});
    }
}

