/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteProviderManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.nrnb.gsoc.enrichment.model.ChartType;
import org.nrnb.gsoc.enrichment.model.EnrichmentTerm;
import org.nrnb.gsoc.enrichment.ui.EnrichmentTableModel;
import org.nrnb.gsoc.enrichment.utils.ModelUtils;
import org.nrnb.gsoc.enrichment.utils.SessionUtils;

public class ViewUtils {
    static String PIE_CHART = "piechart: attributelist=\"enrichmentTermsIntegers\" showlabels=\"false\" colorlist=\"";
    static String CIRCOS_CHART = "circoschart: firstarc=1.0 arcwidth=0.4 attributelist=\"enrichmentTermsIntegers\" showlabels=\"false\" colorlist=\"";
    static String CIRCOS_CHART2 = "circoschart: borderwidth=0 firstarc=1.0 arcwidth=0.4 attributelist=\"enrichmentTermsIntegers\" showlabels=\"false\" colorlist=\"";

    public static void updatePieCharts(CyServiceRegistrar registrar, VisualStyle stringStyle, boolean show) {
        VisualMappingFunctionFactory passThroughFactory = (VisualMappingFunctionFactory)registrar.getService(VisualMappingFunctionFactory.class, "(mapping.type=passthrough)");
        VisualLexicon lex = ((RenderingEngineManager)registrar.getService(RenderingEngineManager.class)).getDefaultVisualLexicon();
        if (show) {
            VisualProperty customGraphics = lex.lookup(CyNode.class, "NODE_CUSTOMGRAPHICS_4");
            PassthroughMapping pMapping = (PassthroughMapping)passThroughFactory.createVisualMappingFunction("enrichmentPassthrough", String.class, customGraphics);
            stringStyle.addVisualMappingFunction((VisualMappingFunction)pMapping);
        } else {
            stringStyle.removeVisualMappingFunction(lex.lookup(CyNode.class, "NODE_CUSTOMGRAPHICS_4"));
        }
    }

    public static void drawCharts(CyApplicationManager manager, CyServiceRegistrar registrar, Map<EnrichmentTerm, String> selectedTerms, ChartType type) {
        CyNetwork network = manager.getCurrentNetwork();
        if (network == null || selectedTerms.size() == 0) {
            return;
        }
        CyTable nodeTable = network.getDefaultNodeTable();
        ViewUtils.createColumns(nodeTable);
        List<String> colorList = ViewUtils.getColorList(selectedTerms);
        List<String> shownTermNames = ViewUtils.getTermNames(network, nodeTable, selectedTerms);
        for (CyNode node : network.getNodeList()) {
            List nodeTermsIntegers = nodeTable.getRow((Object)node.getSUID()).getList("enrichmentTermsIntegers", Integer.class);
            String nodeColor = ViewUtils.nodeColors(colorList, nodeTermsIntegers, type);
            nodeTable.getRow((Object)node.getSUID()).set("enrichmentPassthrough", (Object)nodeColor);
            nodeTable.getRow((Object)node.getSUID()).set("enrichmentTermsIntegers", (Object)nodeTermsIntegers);
        }
        VisualMappingManager vmm = (VisualMappingManager)registrar.getService(VisualMappingManager.class);
        CyNetworkView netView = manager.getCurrentNetworkView();
        if (netView != null) {
            ViewUtils.updatePieCharts(registrar, vmm.getVisualStyle(netView), true);
            netView.updateView();
        }
        CyTable netTable = network.getDefaultNetworkTable();
        ModelUtils.createListColumnIfNeeded(netTable, String.class, ModelUtils.NET_ENRICHMENT_VISTEMRS);
        netTable.getRow((Object)network.getSUID()).set(ModelUtils.NET_ENRICHMENT_VISTEMRS, shownTermNames);
        ModelUtils.createListColumnIfNeeded(netTable, String.class, ModelUtils.NET_ENRICHMENT_VISCOLORS);
        netTable.getRow((Object)network.getSUID()).set(ModelUtils.NET_ENRICHMENT_VISCOLORS, colorList);
    }

    public static void resetCharts(CyApplicationManager manager, CyServiceRegistrar registrar, EnrichmentTableModel model) {
        CyNetwork network = manager.getCurrentNetwork();
        if (network == null || model == null) {
            return;
        }
        CyTable nodeTable = network.getDefaultNodeTable();
        ModelUtils.replaceListColumnIfNeeded(nodeTable, String.class, "enrichmentTermsNames");
        ModelUtils.replaceListColumnIfNeeded(nodeTable, Integer.class, "enrichmentTermsIntegers");
        ModelUtils.replaceColumnIfNeeded(nodeTable, String.class, "enrichmentPassthrough");
        CyTable currTable = ModelUtils.getEnrichmentTable(registrar, network, EnrichmentTerm.TermSource.ALL.getTable());
        if (currTable == null || currTable.getRowCount() == 0) {
            return;
        }
        for (CyRow row : currTable.getAllRows()) {
            if (currTable.getColumn("chart color") == null || row.get("chart color", String.class) == null || ((String)row.get("chart color", String.class)).equals("")) continue;
            row.set("chart color", (Object)"");
        }
        model.fireTableDataChanged();
    }

    public static Palette getEnrichmentPalette(CyNetwork network, CyTable table, CyServiceRegistrar registrar) {
        Palette palette = SessionUtils.getEnrichmentPalette(network, table);
        if (Objects.isNull(palette)) {
            return ViewUtils.getDefaultPalette(registrar);
        }
        return palette;
    }

    private static void createColumns(CyTable nodeTable) {
        ModelUtils.replaceListColumnIfNeeded(nodeTable, String.class, "enrichmentTermsNames");
        ModelUtils.replaceListColumnIfNeeded(nodeTable, Integer.class, "enrichmentTermsIntegers");
        ModelUtils.replaceColumnIfNeeded(nodeTable, String.class, "enrichmentPassthrough");
    }

    private static List<String> getColorList(Map<EnrichmentTerm, String> selectedTerms) {
        ArrayList<String> colorList = new ArrayList<String>();
        for (EnrichmentTerm term : selectedTerms.keySet()) {
            String color = selectedTerms.get(term);
            if (color != null) {
                colorList.add(color);
                continue;
            }
            colorList.add("");
        }
        return colorList;
    }

    private static List<String> getTermNames(CyNetwork network, CyTable nodeTable, Map<EnrichmentTerm, String> selectedTerms) {
        ArrayList<String> shownTermNames = new ArrayList<String>();
        boolean firstTerm = true;
        for (EnrichmentTerm term : selectedTerms.keySet()) {
            String selTerm = term.getName();
            shownTermNames.add(selTerm);
            List<Long> enrichedNodeSUIDs = term.getNodesSUID();
            for (CyNode node : network.getNodeList()) {
                ArrayList<Integer> nodeTermsIntegers = nodeTable.getRow((Object)node.getSUID()).getList("enrichmentTermsIntegers", Integer.class);
                ArrayList<String> nodeTermsNames = nodeTable.getRow((Object)node.getSUID()).getList("enrichmentTermsNames", String.class);
                if (firstTerm || nodeTermsIntegers == null) {
                    nodeTermsIntegers = new ArrayList<Integer>();
                }
                if (firstTerm || nodeTermsNames == null) {
                    nodeTermsNames = new ArrayList<String>();
                }
                if (enrichedNodeSUIDs.contains(node.getSUID())) {
                    nodeTermsNames.add(selTerm);
                    nodeTermsIntegers.add(1);
                } else {
                    nodeTermsNames.add("");
                    nodeTermsIntegers.add(0);
                }
                nodeTable.getRow((Object)node.getSUID()).set("enrichmentTermsIntegers", nodeTermsIntegers);
                nodeTable.getRow((Object)node.getSUID()).set("enrichmentTermsNames", nodeTermsNames);
            }
            if (!firstTerm) continue;
            firstTerm = false;
        }
        return shownTermNames;
    }

    /*
     * WARNING - void declaration
     */
    private static String nodeColors(List<String> colors, List<Integer> nodeTermFlags, ChartType type) {
        boolean foundTerm = false;
        for (Integer n : nodeTermFlags) {
            if (n <= 0) continue;
            foundTerm = true;
            break;
        }
        if (!foundTerm) {
            return null;
        }
        StringBuilder colorString = new StringBuilder();
        if (type.equals((Object)ChartType.FULL) || type.equals((Object)ChartType.PIE)) {
            for (String color : colors) {
                colorString.append(color).append(",");
            }
        } else {
            void var5_8;
            boolean bl = false;
            while (var5_8 < colors.size()) {
                if (nodeTermFlags.get((int)var5_8) > 0) {
                    if (type.equals((Object)ChartType.TEETH)) {
                        colorString.append(colors.get((int)var5_8)).append("ff,");
                    } else {
                        colorString.append(colors.get((int)var5_8)).append(",");
                    }
                } else {
                    if (type.equals((Object)ChartType.TEETH)) {
                        colorString.append("#ffffff00,");
                    } else {
                        colorString.append("#ffffff,");
                    }
                    nodeTermFlags.set((int)var5_8, 1);
                }
                ++var5_8;
            }
        }
        if (type.equals((Object)ChartType.PIE) || type.equals((Object)ChartType.SPLIT_PIE)) {
            return PIE_CHART + colorString.substring(0, colorString.length() - 1) + "\"";
        }
        if (type.equals((Object)ChartType.TEETH)) {
            return CIRCOS_CHART2 + colorString.substring(0, colorString.length() - 1) + "\"";
        }
        return CIRCOS_CHART + colorString.substring(0, colorString.length() - 1) + "\"";
    }

    private static Palette getDefaultPalette(CyServiceRegistrar registrar) {
        PaletteProviderManager pm = (PaletteProviderManager)registrar.getService(PaletteProviderManager.class);
        PaletteProvider brewerProvider = pm.getPaletteProvider("ColorBrewer");
        return brewerProvider.getPalette("Paired colors");
    }
}

