/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.color.Palette;
import org.nrnb.gsoc.enrichment.model.ChartType;
import org.nrnb.gsoc.enrichment.model.EnrichmentTerm;

public class SessionUtils {
    private static final Map<String, Object> sessionObjectMap = new HashMap<String, Object>();

    public static void setSelectedEvidenceCode(CyNetwork network, CyTable model, List<String> evidenceCode) {
        sessionObjectMap.put("selectedEvidenceCodes" + SessionUtils.generateHashMap(network, model), evidenceCode);
    }

    public static List<String> getSelectedEvidenceCode(CyNetwork network, CyTable model) {
        try {
            List result = (List)sessionObjectMap.get("selectedEvidenceCodes" + SessionUtils.generateHashMap(network, model));
            return Objects.isNull(result) ? Collections.emptyList() : result;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static void setSelectedCategories(CyNetwork network, CyTable model, List<EnrichmentTerm.TermSource> categories) {
        sessionObjectMap.put("selectedCategories" + SessionUtils.generateHashMap(network, model), categories);
    }

    public static List<EnrichmentTerm.TermSource> getSelectedCategories(CyNetwork network, CyTable model) {
        try {
            List result = (List)sessionObjectMap.get("selectedCategories" + SessionUtils.generateHashMap(network, model));
            return Objects.isNull(result) ? Collections.emptyList() : result;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static void setRemoveRedundantStatus(CyNetwork network, CyTable model, boolean status) {
        sessionObjectMap.put("removeRedundantStatus" + SessionUtils.generateHashMap(network, model), status);
    }

    public static boolean getRemoveRedundantStatus(CyNetwork network, CyTable model) {
        try {
            return (Boolean)sessionObjectMap.get("removeRedundantStatus" + SessionUtils.generateHashMap(network, model));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setRemoveRedundantCutoff(CyNetwork network, CyTable model, double cutoff) {
        sessionObjectMap.put("removeRedundantCutOff" + SessionUtils.generateHashMap(network, model), cutoff);
    }

    public static double getRemoveRedundantCutoff(CyNetwork network, CyTable model) {
        try {
            Double result = (Double)sessionObjectMap.get("removeRedundantCutOff" + SessionUtils.generateHashMap(network, model));
            return Objects.isNull(result) ? 0.5 : result;
        }
        catch (Exception e) {
            return 0.5;
        }
    }

    public static ChartType getChartType(CyNetwork network, CyTable model) {
        try {
            ChartType result = (ChartType)((Object)sessionObjectMap.get("chartType" + SessionUtils.generateHashMap(network, model)));
            return Objects.isNull((Object)result) ? ChartType.SPLIT : result;
        }
        catch (Exception e) {
            return ChartType.SPLIT;
        }
    }

    public static void setChartType(CyNetwork network, CyTable model, ChartType type) {
        sessionObjectMap.put("chartType" + SessionUtils.generateHashMap(network, model), (Object)type);
    }

    public static void setTopTerms(CyNetwork network, CyTable model, int topTerms) {
        sessionObjectMap.put("topTerms" + SessionUtils.generateHashMap(network, model), topTerms);
    }

    public static int getTopTerms(CyNetwork network, CyTable model) {
        try {
            return (Integer)sessionObjectMap.get("topTerms" + SessionUtils.generateHashMap(network, model));
        }
        catch (Exception e) {
            return 5;
        }
    }

    public static void setEnrichmentPalette(CyNetwork network, CyTable model, Palette palette) {
        sessionObjectMap.put("enrichmentPalette" + SessionUtils.generateHashMap(network, model), palette);
    }

    public static Palette getEnrichmentPalette(CyNetwork network, CyTable model) {
        try {
            Palette palette = (Palette)sessionObjectMap.get("enrichmentPalette" + SessionUtils.generateHashMap(network, model));
            return Objects.isNull(palette) ? null : palette;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String generateHashMap(CyNetwork network, CyTable model) {
        return "" + network.hashCode() + model.hashCode();
    }
}

