/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.property.AbstractConfigDirPropsReader;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.SimpleCyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nrnb.gsoc.enrichment.model.EnrichmentTerm;

public class ModelUtils {
    private static final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");
    public static String ENRICHMENT_NAMESPACE = "EnrichmentTable";
    public static String NAMESPACE_SEPARATOR = "::";
    public static String CANONICAL = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "canonical name";
    public static String DISPLAY = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "display name";
    public static String FULLNAME = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "full name";
    public static String ID = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "@id";
    public static String QUERYTERM = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "query term";
    public static String PROFILERID = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "database identifier";
    public static Map<String, String> scientificNametoID = ModelUtils.getOrganisms();
    public static int MAX_SHORT_NAME_LENGTH = 15;
    public static int SECOND_SEGMENT_LENGTH = 3;
    public static String NET_ENRICHMENT_SETTINGS = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "enrichmentSettings";
    public static String NET_ORGANISMS = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "organism";
    public static String NET_GENE_ID_COLUMN = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "Gene ID Column";
    public static String NET_NO_IEA = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "No IEA";
    public static String NET_DOMAIN_SCOPE = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "Domain Scope";
    public static String NET_SIGNIFICANCE_THRESHOLD_METHOD = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "Significance Threshold Method";
    public static String NET_BACKGROUND = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "Background";
    public static String NET_USER_THRESHOLD = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "User Threshold";
    public static String NET_ALL_RESULTS = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "All Results";
    public static String NET_MEASURE_UNDERREPRESENTATION = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "Measure Underrepresentation";
    public static String NET_ENRICHMENT_VISTEMRS = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "visualizedTerms";
    public static String NET_ENRICHMENT_VISCOLORS = ENRICHMENT_NAMESPACE + NAMESPACE_SEPARATOR + "visualizedTermsColors";
    public static int DEF_VIEW_THRESHOLD = 3000;

    public static boolean haveQueryTerms(CyNetwork network) {
        if (network == null) {
            return false;
        }
        for (CyNode node : network.getNodeList()) {
            if (network.getRow((CyIdentifiable)node).get(QUERYTERM, String.class) == null) continue;
            return true;
        }
        return false;
    }

    public static void selectQueryTerms(CyNetwork network) {
        for (CyNode node : network.getNodeList()) {
            if (network.getRow((CyIdentifiable)node).get(QUERYTERM, String.class) != null) {
                network.getRow((CyIdentifiable)node).set("selected", (Object)true);
                continue;
            }
            network.getRow((CyIdentifiable)node).set("selected", (Object)false);
        }
    }

    public static String getExisting(CyNetwork network) {
        StringBuilder str = new StringBuilder();
        for (CyNode node : network.getNodeList()) {
            String profilerID = (String)network.getRow((CyIdentifiable)node).get(PROFILERID, String.class);
            if (profilerID == null || profilerID.length() <= 0) continue;
            str.append(profilerID + "\n");
        }
        return str.toString();
    }

    public static String getSelected(CyNetwork network, View<CyNode> nodeView) {
        StringBuilder selectedStr = new StringBuilder();
        if (nodeView != null) {
            String profilerID = (String)network.getRow((CyIdentifiable)nodeView.getModel()).get(PROFILERID, String.class);
            selectedStr.append(profilerID + "\n");
        }
        for (CyNode node : network.getNodeList()) {
            String profilerID;
            if (!((Boolean)network.getRow((CyIdentifiable)node).get("selected", Boolean.class)).booleanValue() || (profilerID = (String)network.getRow((CyIdentifiable)node).get(PROFILERID, String.class)) == null || profilerID.length() <= 0) continue;
            selectedStr.append(profilerID + "\n");
        }
        return selectedStr.toString();
    }

    public static CyTable getEnrichmentTable(CyServiceRegistrar registrar, CyNetwork network, String name) {
        CyTableManager tableManager = (CyTableManager)registrar.getService(CyTableManager.class);
        Set currTables = tableManager.getAllTables(true);
        for (CyTable current : currTables) {
            CyRow tempRow;
            if (!name.equals(current.getTitle()) || current.getColumn("network.SUID") == null || current.getAllRows().size() <= 0 || (tempRow = (CyRow)current.getAllRows().get(0)).get("network.SUID", Long.class) == null || !((Long)tempRow.get("network.SUID", Long.class)).equals(network.getSUID())) continue;
            return current;
        }
        return null;
    }

    public static void deleteEnrichmentTables(CyServiceRegistrar registrar, CyNetwork network) {
        CyEventHelper cyEventHelper = (CyEventHelper)registrar.getService(CyEventHelper.class);
        CyTableManager tableManager = (CyTableManager)registrar.getService(CyTableManager.class);
        Set<CyTable> oldTables = ModelUtils.getEnrichmentTables(registrar, network);
        for (CyTable table : oldTables) {
            tableManager.deleteTable(table.getSUID().longValue());
            cyEventHelper.flushPayloadEvents();
        }
    }

    public static void setupEnrichmentTable(CyTable enrichmentTable) {
        if (enrichmentTable.getColumn("nodes.SUID") == null) {
            enrichmentTable.createListColumn("nodes.SUID", Long.class, false);
        }
        if (enrichmentTable.getColumn("network.SUID") == null) {
            enrichmentTable.createColumn("network.SUID", Long.class, false);
        }
        if (enrichmentTable.getColumn("term name") == null) {
            enrichmentTable.createColumn("term name", String.class, false);
        }
        if (enrichmentTable.getColumn("p-value") == null) {
            enrichmentTable.createColumn("p-value", Double.class, false);
        }
        if (enrichmentTable.getColumn("source") == null) {
            enrichmentTable.createColumn("source", String.class, false);
        }
        if (enrichmentTable.getColumn("description") == null) {
            enrichmentTable.createColumn("description", String.class, false);
        }
        if (enrichmentTable.getColumn("term id") == null) {
            enrichmentTable.createColumn("term id", String.class, false);
        }
        if (enrichmentTable.getColumn("intersection size") == null) {
            enrichmentTable.createColumn("intersection size", Integer.class, false);
        }
        if (enrichmentTable.getColumn("background size") == null) {
            enrichmentTable.createColumn("background size", Integer.class, false);
        }
        if (enrichmentTable.getColumn("term size") == null) {
            enrichmentTable.createColumn("term size", Integer.class, false);
        }
        if (enrichmentTable.getColumn("precision") == null) {
            enrichmentTable.createColumn("precision", Double.class, false);
        }
        if (enrichmentTable.getColumn("query size") == null) {
            enrichmentTable.createColumn("query size", Integer.class, false);
        }
        if (enrichmentTable.getColumn("recall") == null) {
            enrichmentTable.createColumn("recall", Double.class, false);
        }
        if (enrichmentTable.getColumn("intersecting genes") == null) {
            enrichmentTable.createListColumn("intersecting genes", String.class, false);
        }
        if (enrichmentTable.getColumn("Evidence codes") == null) {
            enrichmentTable.createListColumn("Evidence codes", String.class, false);
        }
        if (enrichmentTable.getColumn("chart color") == null) {
            enrichmentTable.createColumn("chart color", String.class, false);
        }
    }

    public static List<CyColumn> getProfilerColumn(CyTable nodeTable) {
        ArrayList<CyColumn> profilerColumnNames = new ArrayList<CyColumn>();
        for (CyColumn col : nodeTable.getColumns()) {
            if (!col.getType().equals(String.class)) continue;
            profilerColumnNames.add(col);
        }
        return profilerColumnNames;
    }

    public static Map<String, String> getOrganisms() {
        if (scientificNametoID != null) {
            return scientificNametoID;
        }
        try {
            int i;
            String line;
            InputStream inputStream = ModelUtils.class.getClassLoader().getResourceAsStream("organismsList.json");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            JSONParser parser = new JSONParser();
            String jsonString = stringBuilder.toString();
            JSONArray result = (JSONArray)parser.parse(jsonString);
            if (result == null) {
                return scientificNametoID;
            }
            JSONArray jsonArrayScientificName = new JSONArray();
            JSONArray jsonArrayID = new JSONArray();
            for (i = 0; i < result.size(); ++i) {
                JSONObject jsonObject = (JSONObject)result.get(i);
                jsonArrayScientificName.add(jsonObject.get((Object)"scientific_name"));
                jsonArrayID.add(jsonObject.get((Object)"id"));
            }
            scientificNametoID = new HashMap<String, String>();
            if (jsonArrayID != null && jsonArrayScientificName != null) {
                for (i = 0; i < jsonArrayID.size(); ++i) {
                    scientificNametoID.put(jsonArrayScientificName.get(i).toString(), jsonArrayID.get(i).toString());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return scientificNametoID;
    }

    public static List<String> getOrganismsName(Map<String, String> scientificNametoID) {
        ArrayList<String> allSpecies = new ArrayList<String>();
        for (String name : scientificNametoID.keySet()) {
            allSpecies.add(name);
        }
        return allSpecies;
    }

    public static String listToString(List<?> list) {
        Object str = "";
        if (list == null || list.size() == 0) {
            return str;
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            str = (String)str + list.get(i) + ",";
        }
        return (String)str + list.get(list.size() - 1).toString();
    }

    public static List<String> stringToList(String string) {
        if (string == null || string.length() == 0) {
            return new ArrayList<String>();
        }
        String[] arr = string.split(",");
        return Arrays.asList(arr);
    }

    public static void updateEnrichmentSettings(CyNetwork network, Map<String, String> settings) {
        Object setting = "";
        int index = 0;
        for (String key : settings.keySet()) {
            if (index > 0) {
                setting = (String)setting + ";";
            }
            setting = (String)setting + key + "=" + settings.get(key);
            ++index;
        }
        ModelUtils.createColumnIfNeeded(network.getDefaultNetworkTable(), String.class, NET_ENRICHMENT_SETTINGS);
        network.getRow((CyIdentifiable)network).set(NET_ENRICHMENT_SETTINGS, setting);
    }

    public static void createColumnIfNeeded(CyTable table, Class<?> clazz, String columnName) {
        if (table.getColumn(columnName) != null) {
            return;
        }
        table.createColumn(columnName, clazz, false);
    }

    public static void createListColumnIfNeeded(CyTable table, Class<?> clazz, String columnName) {
        if (table.getColumn(columnName) != null) {
            return;
        }
        table.createListColumn(columnName, clazz, false);
    }

    public static Map<String, String> getEnrichmentSettings(CyNetwork network) {
        String[] settingArray;
        HashMap<String, String> settings = new HashMap<String, String>();
        String setting = (String)network.getRow((CyIdentifiable)network).get(NET_ENRICHMENT_SETTINGS, String.class);
        if (setting == null || setting.length() == 0) {
            return settings;
        }
        for (String s : settingArray = setting.split(";")) {
            String[] pair = s.split("=");
            if (pair.length != 2) continue;
            settings.put(pair[0], pair[1]);
        }
        return settings;
    }

    public static Set<CyTable> getEnrichmentTables(CyServiceRegistrar registrar, CyNetwork network) {
        CyTableManager tableManager = (CyTableManager)registrar.getService(CyTableManager.class);
        HashSet<CyTable> netTables = new HashSet<CyTable>();
        HashSet<String> tableNames = new HashSet<String>(EnrichmentTerm.TermSource.getTables());
        Set currTables = tableManager.getAllTables(true);
        for (CyTable current : currTables) {
            CyRow tempRow;
            if (!tableNames.contains(current.getTitle()) || current.getColumn("network.SUID") == null || current.getAllRows().size() <= 0 || (tempRow = (CyRow)current.getAllRows().get(0)).get("network.SUID", Long.class) == null || !((Long)tempRow.get("network.SUID", Long.class)).equals(network.getSUID())) continue;
            netTables.add(current);
        }
        return netTables;
    }

    public static void replaceListColumnIfNeeded(CyTable table, Class<?> clazz, String columnName) {
        if (table.getColumn(columnName) != null) {
            table.deleteColumn(columnName);
        }
        table.createListColumn(columnName, clazz, false);
    }

    public static void replaceColumnIfNeeded(CyTable table, Class<?> clazz, String columnName) {
        if (table.getColumn(columnName) != null) {
            table.deleteColumn(columnName);
        }
        table.createColumn(columnName, clazz, false);
    }

    public static void copyRow(CyTable fromTable, CyTable toTable, CyIdentifiable from, CyIdentifiable to, List<String> columnsCreated) {
        for (CyColumn col : fromTable.getColumns()) {
            Object v;
            if (col.getName().equals("SUID") || from.getClass().equals(CyNode.class) && col.getName().equals("name") || col.getName().equals("selected") || from.getClass().equals(CyNode.class) && col.getName().equals("shared name")) continue;
            if (col.getName().equals(QUERYTERM) || col.getName().equals(DISPLAY) || col.getName().equals(ID)) {
                v = fromTable.getRow((Object)from.getSUID()).getRaw(col.getName());
                toTable.getRow((Object)to.getSUID()).set(col.getName() + ".copy", v);
                continue;
            }
            v = fromTable.getRow((Object)from.getSUID()).getRaw(col.getName());
            toTable.getRow((Object)to.getSUID()).set(col.getName(), v);
        }
    }

    public static void copyNodes(CyNetwork fromNetwork, CyNetwork toNetwork, Map<String, CyNode> nodeMap, String keyColumn, List<String> toColumns) {
        for (CyNode node : fromNetwork.getNodeList()) {
            String key = (String)fromNetwork.getRow((CyIdentifiable)node).get(keyColumn, String.class);
            if (key == null || nodeMap.containsKey(key)) continue;
            CyNode newNode = toNetwork.addNode();
            nodeMap.put(key, newNode);
            toNetwork.getRow((CyIdentifiable)newNode).set("name", (Object)key);
            for (String col : toColumns) {
                toNetwork.getRow((CyIdentifiable)newNode).set(col, (Object)key);
            }
        }
    }

    public static void createNodeMap(CyNetwork network, Map<String, CyNode> nodeMap, String column) {
        for (CyNode node : network.getNodeList()) {
            String key = (String)network.getRow((CyIdentifiable)node).get(column, String.class);
            nodeMap.put(key, node);
        }
    }

    public static List<String> copyColumns(CyTable fromTable, CyTable toTable) {
        ArrayList<String> columns = new ArrayList<String>();
        for (CyColumn col : fromTable.getColumns()) {
            String fqn = col.getName();
            if (toTable.getColumn(fqn) == null) {
                if (col.getType().equals(List.class)) {
                    if (col.getListElementType().equals(String.class)) {
                        toTable.createListColumn(fqn, String.class, col.isImmutable(), (List)col.getDefaultValue());
                        continue;
                    }
                    if (col.getListElementType().equals(Long.class)) {
                        toTable.createListColumn(fqn, Long.class, col.isImmutable(), (List)col.getDefaultValue());
                        continue;
                    }
                    if (col.getListElementType().equals(Double.class)) {
                        toTable.createListColumn(fqn, Double.class, col.isImmutable(), (List)col.getDefaultValue());
                        continue;
                    }
                    if (col.getListElementType().equals(Integer.class)) {
                        toTable.createListColumn(fqn, Integer.class, col.isImmutable(), (List)col.getDefaultValue());
                        continue;
                    }
                    if (!col.getListElementType().equals(Boolean.class)) continue;
                    toTable.createListColumn(fqn, Boolean.class, col.isImmutable(), (List)col.getDefaultValue());
                    continue;
                }
                toTable.createColumn(fqn, col.getType(), col.isImmutable(), col.getDefaultValue());
                columns.add(fqn);
                continue;
            }
            if (!fqn.equals(QUERYTERM) && !fqn.equals(DISPLAY) && !fqn.equals(ID)) continue;
            toTable.createColumn(fqn + ".copy", col.getType(), col.isImmutable(), col.getDefaultValue());
            columns.add(fqn + ".copy");
        }
        return columns;
    }

    public static CyNetworkView getNetworkView(CyServiceRegistrar registrar, CyNetwork network) {
        Collection views = ((CyNetworkViewManager)registrar.getService(CyNetworkViewManager.class)).getNetworkViews(network);
        Iterator iterator = views.iterator();
        if (iterator.hasNext()) {
            CyNetworkView view = (CyNetworkView)iterator.next();
            return view;
        }
        return null;
    }

    public static List<EnrichmentTerm> getEnrichmentfromJSON(JSONObject response, CyNetwork network, List<String> nodeNameList, Map<String, Long> enrichmentNodesMap) {
        JSONArray enrichmentArray = ModelUtils.getResultsFromJSON(response, JSONArray.class);
        if (enrichmentArray == null) {
            return null;
        }
        ArrayList<EnrichmentTerm> results = new ArrayList<EnrichmentTerm>();
        for (Object enrObject : enrichmentArray) {
            double recall;
            String content;
            JSONObject enr = (JSONObject)enrObject;
            EnrichmentTerm currTerm = new EnrichmentTerm();
            if (enr.containsKey((Object)"description")) {
                currTerm.setDescription((String)enr.get((Object)"description"));
            }
            if (enr.containsKey((Object)"intersection_size")) {
                currTerm.setIntersectionSize(((Number)enr.get((Object)"intersection_size")).intValue());
            }
            if (enr.containsKey((Object)"effective_domain_size")) {
                currTerm.setEffectiveDomainSize(((Number)enr.get((Object)"effective_domain_size")).intValue());
            }
            if (enr.containsKey((Object)"p_value")) {
                content = enr.get((Object)"p_value").toString();
                double d = Double.parseDouble(content);
                currTerm.setPValue(d);
            }
            if (enr.containsKey((Object)"precision")) {
                content = enr.get((Object)"precision").toString();
                double precision = Double.parseDouble(content);
                currTerm.setPrecision(precision);
            }
            if (enr.containsKey((Object)"recall")) {
                content = enr.get((Object)"recall").toString();
                recall = Double.parseDouble(content);
                currTerm.setRecall(recall);
            }
            if (enr.containsKey((Object)"native")) {
                content = enr.get((Object)"native").toString();
                currTerm.setTermID(content);
            }
            if (enr.containsKey((Object)"goshv")) {
                content = enr.get((Object)"goshv").toString();
                recall = Double.parseDouble(content);
            }
            if (enr.containsKey((Object)"term_size")) {
                content = enr.get((Object)"term_size").toString();
                int termSize = Integer.parseInt(content);
                currTerm.setTermSize(termSize);
            }
            if (enr.containsKey((Object)"query_size")) {
                content = enr.get((Object)"query_size").toString();
                int termSize = Integer.parseInt(content);
                currTerm.setQuerySize(termSize);
            }
            if (enr.containsKey((Object)"significant")) {
                currTerm.setSignificant((Boolean)enr.get((Object)"significant"));
            }
            if (enr.containsKey((Object)"source")) {
                content = enr.get((Object)"source").toString();
                if (content == null || content.isEmpty()) {
                    currTerm.setSource("");
                } else {
                    currTerm.setSource(content);
                }
            }
            if (enr.containsKey((Object)"name")) {
                currTerm.setName((String)enr.get((Object)"name"));
            }
            HashSet<String> evidenceCodes = new HashSet<String>();
            if (enr.containsKey((Object)"intersections")) {
                ArrayList<String> currGeneList = new ArrayList<String>();
                ArrayList<Long> currNodeList = new ArrayList<Long>();
                JSONArray genes = (JSONArray)enr.get((Object)"intersections");
                for (int i = 0; i < genes.size(); ++i) {
                    if (genes.get(i).toString().length() <= 2) continue;
                    evidenceCodes.addAll(Arrays.stream(genes.get(i).toString().substring(1, genes.get(i).toString().length() - 1).split(",")).collect(Collectors.toList()));
                    String enrGeneNodeName = nodeNameList.get(i);
                    Long nodeSUID = enrichmentNodesMap.get(enrGeneNodeName);
                    currNodeList.add(nodeSUID);
                    currGeneList.add(nodeNameList.get(i));
                }
                currTerm.setGenes(currGeneList);
                currTerm.setNodesSUID(currNodeList);
            }
            currTerm.setEvidenceCodes(evidenceCodes);
            results.add(currTerm);
        }
        return results;
    }

    public static void setNetOrganism(CyNetwork network, String species) {
        ModelUtils.createColumnIfNeeded(network.getDefaultNetworkTable(), String.class, NET_ORGANISMS);
        network.getRow((CyIdentifiable)network).set(NET_ORGANISMS, (Object)species);
    }

    public static String getNetGeneIDColumn(CyNetwork network) {
        if (network.getDefaultNetworkTable().getColumn(NET_GENE_ID_COLUMN) == null) {
            return null;
        }
        return (String)network.getRow((CyIdentifiable)network).get(NET_GENE_ID_COLUMN, String.class);
    }

    public static void setNetGeneIDColumn(CyNetwork network, String column) {
        ModelUtils.createColumnIfNeeded(network.getDefaultNetworkTable(), String.class, NET_GENE_ID_COLUMN);
        network.getRow((CyIdentifiable)network).set(NET_GENE_ID_COLUMN, (Object)column);
    }

    public static String getNetOrganism(CyNetwork network) {
        if (network.getDefaultNetworkTable().getColumn(NET_ORGANISMS) == null) {
            return null;
        }
        return (String)network.getRow((CyIdentifiable)network).get(NET_ORGANISMS, String.class);
    }

    public static void setNetBackground(CyNetwork network, List<String> background) {
        ModelUtils.createColumnIfNeeded(network.getDefaultNetworkTable(), String.class, NET_BACKGROUND);
        network.getRow((CyIdentifiable)network).set(NET_BACKGROUND, background);
    }

    public static List<String> getNetBackground(CyNetwork network) {
        if (network.getDefaultNetworkTable().getColumn(NET_DOMAIN_SCOPE) == null) {
            return null;
        }
        return (List)network.getRow((CyIdentifiable)network).get(NET_BACKGROUND, List.class);
    }

    public static void setNetUserThreshold(CyNetwork network, Double userThreshold) {
        ModelUtils.createColumnIfNeeded(network.getDefaultNetworkTable(), Double.class, NET_USER_THRESHOLD);
        network.getRow((CyIdentifiable)network).set(NET_USER_THRESHOLD, (Object)userThreshold);
    }

    public static Double getNetUserThreshold(CyNetwork network) {
        if (network.getDefaultNetworkTable().getColumn(NET_USER_THRESHOLD) == null) {
            return null;
        }
        return (Double)network.getRow((CyIdentifiable)network).get(NET_USER_THRESHOLD, Double.class);
    }

    public static void setNetSignificanceThresholdMethod(CyNetwork network, String significanceThresholdMethod) {
        if (network.getDefaultNetworkTable() == null) {
            logger.warn((Object)"No default network table available");
            return;
        }
        ModelUtils.createColumnIfNeeded(network.getDefaultNetworkTable(), String.class, NET_SIGNIFICANCE_THRESHOLD_METHOD);
        network.getRow((CyIdentifiable)network).set(NET_SIGNIFICANCE_THRESHOLD_METHOD, (Object)significanceThresholdMethod);
    }

    public static String getNetSignificanceThresholdMethod(CyNetwork network) {
        if (network.getDefaultNetworkTable().getColumn(NET_SIGNIFICANCE_THRESHOLD_METHOD) == null) {
            return null;
        }
        return (String)network.getRow((CyIdentifiable)network).get(NET_SIGNIFICANCE_THRESHOLD_METHOD, String.class);
    }

    public static void setNetDomainScope(CyNetwork network, String domainScope) {
        ModelUtils.createColumnIfNeeded(network.getDefaultNetworkTable(), String.class, NET_DOMAIN_SCOPE);
        network.getRow((CyIdentifiable)network).set(NET_DOMAIN_SCOPE, (Object)domainScope);
    }

    public static String getNetDomainScope(CyNetwork network) {
        if (network.getDefaultNetworkTable().getColumn(NET_DOMAIN_SCOPE) == null) {
            return null;
        }
        return (String)network.getRow((CyIdentifiable)network).get(NET_DOMAIN_SCOPE, String.class);
    }

    public static void setNetNoIEA(CyNetwork network, Boolean noIEA) {
        ModelUtils.createColumnIfNeeded(network.getDefaultNetworkTable(), Boolean.class, NET_NO_IEA);
        network.getRow((CyIdentifiable)network).set(NET_NO_IEA, (Object)noIEA);
    }

    public static Boolean getNetNoIEA(CyNetwork network) {
        if (network.getDefaultNetworkTable().getColumn(NET_NO_IEA) == null) {
            return null;
        }
        return (Boolean)network.getRow((CyIdentifiable)network).get(NET_NO_IEA, Boolean.class);
    }

    public static void setNetAllResults(CyNetwork network, Boolean allResults) {
        ModelUtils.createColumnIfNeeded(network.getDefaultNetworkTable(), Boolean.class, NET_ALL_RESULTS);
        network.getRow((CyIdentifiable)network).set(NET_ALL_RESULTS, (Object)allResults);
    }

    public static Boolean getNetAllResults(CyNetwork network) {
        if (network.getDefaultNetworkTable().getColumn(NET_ALL_RESULTS) == null) {
            return null;
        }
        return (Boolean)network.getRow((CyIdentifiable)network).get(NET_ALL_RESULTS, Boolean.class);
    }

    public static <T> T getResultsFromJSON(JSONObject json, Class<? extends T> clazz) {
        if (json == null) {
            return null;
        }
        Object result = json.get((Object)"result");
        if (!clazz.isAssignableFrom(result.getClass())) {
            return null;
        }
        return (T)result;
    }

    public static void copyNodeAttributes(CyNetwork from, CyNetwork to, Map<String, CyNode> nodeMap, String column) {
        List<String> columnsCreated = ModelUtils.copyColumns(from.getDefaultNodeTable(), to.getDefaultNodeTable());
        for (CyNode node : from.getNodeList()) {
            String nodeKey = (String)from.getRow((CyIdentifiable)node).get(column, String.class);
            if (!nodeMap.containsKey(nodeKey)) continue;
            CyNode newNode = nodeMap.get(nodeKey);
            ModelUtils.copyRow(from.getDefaultNodeTable(), to.getDefaultNodeTable(), (CyIdentifiable)node, (CyIdentifiable)newNode, columnsCreated);
        }
    }

    public static CyProperty<Properties> getPropertyService(CyServiceRegistrar registrar, CyProperty.SavePolicy policy) {
        String name = "enrichment";
        if (policy.equals((Object)CyProperty.SavePolicy.SESSION_FILE)) {
            CyProperty service = (CyProperty)registrar.getService(CyProperty.class, "(cyPropertyName=" + name + ")");
            if (service.getSavePolicy().equals((Object)CyProperty.SavePolicy.SESSION_FILE)) {
                return service;
            }
            Properties props = new Properties();
            service = new SimpleCyProperty(name, (Object)props, Properties.class, CyProperty.SavePolicy.SESSION_FILE);
            Properties serviceProps = new Properties();
            serviceProps.setProperty("cyPropertyName", service.getName());
            registrar.registerAllServices((Object)service, serviceProps);
            return service;
        }
        if (policy.equals((Object)CyProperty.SavePolicy.CONFIG_DIR) || policy.equals((Object)CyProperty.SavePolicy.SESSION_FILE_AND_CONFIG_DIR)) {
            ConfigPropsReader service = new ConfigPropsReader(policy, name);
            Properties serviceProps = new Properties();
            serviceProps.setProperty("cyPropertyName", service.getName());
            registrar.registerAllServices((Object)service, serviceProps);
            return service;
        }
        return null;
    }

    public static boolean ifHaveEnrichmentNS(CyNetwork network) {
        if (network == null) {
            return false;
        }
        Collection columns = network.getDefaultNetworkTable().getColumns(ENRICHMENT_NAMESPACE);
        return columns != null && columns.size() > 0;
    }

    public static class ConfigPropsReader
    extends AbstractConfigDirPropsReader {
        ConfigPropsReader(CyProperty.SavePolicy policy, String name) {
            super(name, "enrichment.props", policy);
        }
    }
}

