/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.ui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.nrnb.gsoc.enrichment.model.EnrichmentTerm;

public class EnrichmentTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private CyTable cyTable;
    private Long[] rowNames;

    public EnrichmentTableModel(CyTable cyTable, String[] columnNames) {
        this.columnNames = columnNames;
        this.cyTable = cyTable;
        this.initData();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rowNames.length;
    }

    public int getAllRowCount() {
        return this.cyTable.getRowCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Long[] getRowNames() {
        return this.rowNames;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.getRowCount() == 0) {
            return null;
        }
        String colName = this.columnNames[col];
        Long rowName = this.rowNames[row];
        if (colName.equals("chart color")) {
            String hexColor = (String)this.cyTable.getRow((Object)rowName).get(colName, String.class);
            if (hexColor != null && !hexColor.equals("")) {
                return Color.decode(hexColor);
            }
            return Color.WHITE;
        }
        if (colName.equals("background size")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Integer.class);
        }
        if (colName.equals("intersection size")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Integer.class);
        }
        if (colName.equals("query size")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Integer.class);
        }
        if (colName.equals("recall")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Double.class);
        }
        if (colName.equals("goshv")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Double.class);
        }
        if (colName.equals("term id")) {
            return this.cyTable.getRow((Object)rowName).get(colName, String.class);
        }
        if (colName.equals("group id")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Long.class);
        }
        if (colName.equals("term size")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Integer.class);
        }
        if (colName.equals("intersecting genes")) {
            return this.cyTable.getRow((Object)rowName).getList(colName, String.class);
        }
        if (colName.equals("source")) {
            return this.cyTable.getRow((Object)rowName).get(colName, String.class);
        }
        if (colName.equals("id")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Long.class);
        }
        if (colName.equals("p-value")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Double.class);
        }
        if (colName.equals("precision")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Double.class);
        }
        if (colName.equals("significant")) {
            return this.cyTable.getRow((Object)rowName).getList(colName, Boolean.class);
        }
        if (colName.equals("nodes.SUID")) {
            return this.cyTable.getRow((Object)rowName).getList(colName, Long.class);
        }
        if (colName.equals("Evidence codes")) {
            return this.cyTable.getRow((Object)rowName).getList(colName, String.class);
        }
        return this.cyTable.getRow((Object)rowName).get(colName, String.class);
    }

    public Object getValueAt(int row, String colName) {
        Long rowName = this.rowNames[row];
        if (colName.equals("chart color")) {
            String hexColor = (String)this.cyTable.getRow((Object)rowName).get(colName, String.class);
            if (hexColor != null && !hexColor.equals("")) {
                return Color.decode(hexColor);
            }
            return Color.WHITE;
        }
        if (colName.equals("background size")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Integer.class);
        }
        if (colName.equals("intersection size")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Integer.class);
        }
        if (colName.equals("query size")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Integer.class);
        }
        if (colName.equals("source")) {
            return this.cyTable.getRow((Object)rowName).get(colName, String.class);
        }
        if (colName.equals("recall")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Double.class);
        }
        if (colName.equals("goshv")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Double.class);
        }
        if (colName.equals("id")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Long.class);
        }
        if (colName.equals("term id")) {
            return this.cyTable.getRow((Object)rowName).get(colName, String.class);
        }
        if (colName.equals("group id")) {
            return this.cyTable.getRow((Object)rowName).get(colName, String.class);
        }
        if (colName.equals("term size")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Integer.class);
        }
        if (colName.equals("intersecting genes")) {
            return this.cyTable.getRow((Object)rowName).getList(colName, String.class);
        }
        if (colName.equals("significant")) {
            return this.cyTable.getRow((Object)rowName).getList(colName, Boolean.class);
        }
        if (colName.equals("intersection size")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Integer.class);
        }
        if (colName.equals("term size")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Integer.class);
        }
        if (colName.equals("precision")) {
            return this.cyTable.getRow((Object)rowName).get(colName, Double.class);
        }
        if (colName.equals("nodes.SUID")) {
            return this.cyTable.getRow((Object)rowName).getList(colName, Long.class);
        }
        return this.cyTable.getRow((Object)rowName).get(colName, String.class);
    }

    @Override
    public Class<?> getColumnClass(int c) {
        String colName = this.columnNames[c];
        if (colName.equals("chart color")) {
            return Color.class;
        }
        if (colName.equals("background size")) {
            return Integer.class;
        }
        if (colName.equals("intersection size")) {
            return Integer.class;
        }
        if (colName.equals("query size")) {
            return Integer.class;
        }
        if (colName.equals("source")) {
            return String.class;
        }
        if (colName.equals("recall")) {
            return Double.class;
        }
        if (colName.equals("goshv")) {
            return Double.class;
        }
        if (colName.equals("id")) {
            return Long.class;
        }
        if (colName.equals("term id")) {
            return String.class;
        }
        if (colName.equals("group id")) {
            return String.class;
        }
        if (colName.equals("term size")) {
            return Integer.class;
        }
        if (colName.equals("intersecting genes")) {
            return String.class;
        }
        if (colName.equals("significant")) {
            return Boolean.class;
        }
        if (colName.equals("intersection size")) {
            return Integer.class;
        }
        if (colName.equals("term size")) {
            return Integer.class;
        }
        if (colName.equals("precision")) {
            return Double.class;
        }
        if (colName.equals("nodes.SUID")) {
            return List.class;
        }
        if (colName.equals("p-value")) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.columnNames[col].equals("chart color");
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String colName = this.columnNames[col];
        Long rowName = this.rowNames[row];
        if (colName.equals("chart color")) {
            if (this.cyTable.getColumn("chart color") == null) {
                this.cyTable.createColumn("chart color", String.class, false);
            }
            try {
                Color color = (Color)value;
                String hexColor = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                this.cyTable.getRow((Object)rowName).set(colName, (Object)hexColor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public void filterByNodeSUID(List<Long> nodesToFilterSUID, boolean annotateAllNodes, List<EnrichmentTerm.TermSource> categories, List<String> evidenceCodes, boolean removeRedundancy, double cutoff) {
        this.filter(categories, evidenceCodes, removeRedundancy, cutoff);
        this.filterByNodeSUID(nodesToFilterSUID, annotateAllNodes);
    }

    public void filterByNodeSUID(List<Long> nodesToFilterSUID, boolean annotateAllNodes) {
        List rows = this.cyTable.getAllRows();
        List<Long> shownRows = Arrays.asList(this.rowNames);
        Long[] rowArray = new Long[rows.size()];
        int i = 0;
        for (CyRow row : rows) {
            Long rowID = (Long)row.get("id", Long.class);
            if (!shownRows.contains(rowID)) continue;
            if (nodesToFilterSUID != null && nodesToFilterSUID.size() > 0) {
                ArrayList genesSUID = new ArrayList(row.getList("nodes.SUID", Long.class));
                genesSUID.retainAll(nodesToFilterSUID);
                if ((genesSUID.size() <= 0 || annotateAllNodes) && (!annotateAllNodes || genesSUID.size() != nodesToFilterSUID.size())) continue;
                rowArray[i] = rowID;
                ++i;
                continue;
            }
            rowArray[i] = rowID;
            ++i;
        }
        this.rowNames = Arrays.copyOf(rowArray, i);
        this.fireTableDataChanged();
    }

    public void filter(List<EnrichmentTerm.TermSource> sources, List<String> evidenceList, boolean removeOverlapping, double cutoff) {
        this.filterBySource(sources);
        int length = this.filterByEvidenceCode(evidenceList);
        if (removeOverlapping && length > 0) {
            this.rowNames = this.removeRedundancy(length, cutoff);
        }
        this.fireTableDataChanged();
    }

    private void filterBySource(List<EnrichmentTerm.TermSource> sources) {
        List rows = this.cyTable.getAllRows();
        Long[] rowArray = new Long[rows.size()];
        int rowCount = 0;
        for (CyRow row : rows) {
            String termSource = (String)row.get("source", String.class);
            if (!sources.isEmpty() && !this.inSource(sources, termSource)) continue;
            rowArray[rowCount] = (Long)row.get("id", Long.class);
            ++rowCount;
        }
        this.rowNames = Arrays.copyOf(rowArray, rowCount);
    }

    public int filterByEvidenceCode(List<String> evidenceCodes) {
        List rows = this.cyTable.getAllRows();
        HashSet<Long> shownRows = new HashSet<Long>(Arrays.asList(this.rowNames));
        Long[] rowArray = new Long[rows.size()];
        int rowCount = 0;
        for (CyRow row : rows) {
            Long rowID = (Long)row.get("id", Long.class);
            if (!shownRows.contains(rowID)) continue;
            List termSource = (List)row.get("Evidence codes", List.class);
            if (!evidenceCodes.isEmpty() && !evidenceCodes.stream().allMatch(e -> termSource.contains("\"" + e + "\""))) continue;
            rowArray[rowCount++] = (Long)row.get("id", Long.class);
        }
        this.rowNames = Arrays.copyOf(rowArray, rowCount);
        this.fireTableDataChanged();
        return rowCount;
    }

    private boolean inSource(List<EnrichmentTerm.TermSource> sources, String termName) {
        for (EnrichmentTerm.TermSource ts : sources) {
            if (!ts.getName().equals(termName)) continue;
            return true;
        }
        return false;
    }

    private Long[] removeRedundancy(int length, double cutoff) {
        Long[] sortedArray = this.pValueSort(this.rowNames, length);
        ArrayList<Long> currentTerms = new ArrayList<Long>();
        currentTerms.add(sortedArray[0]);
        for (int i = 1; i < length; ++i) {
            if (!(this.jaccard(currentTerms, sortedArray[i]) < cutoff)) continue;
            currentTerms.add(sortedArray[i]);
        }
        return currentTerms.toArray(new Long[1]);
    }

    private Long[] pValueSort(Long[] rowArray, int length) {
        return Arrays.copyOf(rowArray, length);
    }

    private double jaccard(List<Long> currentTerms, Long term) {
        double maxJaccard = 0.0;
        for (Long currentTerm : currentTerms) {
            maxJaccard = Math.max(maxJaccard, this.jaccard(currentTerm, term));
        }
        return maxJaccard;
    }

    private double jaccard2(List<Long> currentTerms, Long term) {
        HashSet<Long> currentNodes = new HashSet<Long>();
        for (Long currentTerm : currentTerms) {
            List nodes = this.cyTable.getRow((Object)currentTerm).getList("nodes.SUID", Long.class);
            currentNodes.addAll(nodes);
        }
        List newNodes = this.cyTable.getRow((Object)term).getList("nodes.SUID", Long.class);
        return this.jaccard2(currentNodes, newNodes);
    }

    private double jaccard2(Set<Long> currentNodes, List<Long> newNodes) {
        int intersection = 0;
        for (Long cn : newNodes) {
            if (!currentNodes.contains(cn)) continue;
            ++intersection;
        }
        double j = (double)intersection / (double)(currentNodes.size() + newNodes.size() - intersection);
        return j;
    }

    private double jaccard(Long currentTerm, Long term) {
        List currentNodes = this.cyTable.getRow((Object)currentTerm).getList("nodes.SUID", Long.class);
        List newNodes = this.cyTable.getRow((Object)term).getList("nodes.SUID", Long.class);
        if (currentNodes == null || newNodes == null) {
            return 0.0;
        }
        int intersection = 0;
        for (Long cn : currentNodes) {
            if (!newNodes.contains(cn)) continue;
            ++intersection;
        }
        double j = (double)intersection / (double)(currentNodes.size() + newNodes.size() - intersection);
        return j;
    }

    private void initData() {
        List rows = this.cyTable.getAllRows();
        this.rowNames = new Long[rows.size()];
        int i = 0;
        for (CyRow row : rows) {
            this.rowNames[i] = (Long)row.get("id", Long.class);
            ++i;
        }
    }
}

