/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.model.events.SelectedNodesAndEdgesEvent;
import org.cytoscape.model.events.SelectedNodesAndEdgesListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.util.swing.CyColorPaletteChooserFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.json.simple.JSONObject;
import org.nrnb.gsoc.enrichment.model.EnrichmentTerm;
import org.nrnb.gsoc.enrichment.tasks.EnrichmentAdvancedOptionsTask;
import org.nrnb.gsoc.enrichment.tasks.EnrichmentMapAdvancedTask;
import org.nrnb.gsoc.enrichment.tasks.EnrichmentSettingsTask;
import org.nrnb.gsoc.enrichment.tasks.EnrichmentTask;
import org.nrnb.gsoc.enrichment.tasks.ExportEnrichmentTableTask;
import org.nrnb.gsoc.enrichment.tasks.FilterEnrichmentTableTask;
import org.nrnb.gsoc.enrichment.tasks.OrganismAndGeneIdAssertionTask;
import org.nrnb.gsoc.enrichment.ui.ColorRenderer;
import org.nrnb.gsoc.enrichment.ui.EnrichmentTableModel;
import org.nrnb.gsoc.enrichment.utils.IconUtil;
import org.nrnb.gsoc.enrichment.utils.ModelUtils;
import org.nrnb.gsoc.enrichment.utils.SessionUtils;
import org.nrnb.gsoc.enrichment.utils.ViewUtils;

public class EnrichmentCytoPanel
extends JPanel
implements CytoPanelComponent2,
ActionListener,
TableModelListener,
SelectedNodesAndEdgesListener,
NetworkAboutToBeDestroyedListener,
SetCurrentNetworkListener,
SessionLoadedListener {
    private CyTable enrichmentTable;
    EnrichmentTableModel tableModel;
    Map<String, JTable> enrichmentTables;
    JPanel topPanel;
    JPanel mainPanel;
    JScrollPane scrollPane;
    List<String> availableTables;
    final CyColorPaletteChooserFactory colorChooserFactory;
    public static final String showTable = EnrichmentTerm.TermSource.ALL.getTable();
    JLabel labelRows;
    JButton butAdvancedOptions;
    JButton butExportTable;
    JButton butRunProfiler;
    JButton butFilter;
    JButton butEnrichmentMap;
    JButton butDrawCharts;
    JButton butResetCharts;
    JButton butChartSettings;
    JLabel organismSelect;
    JLabel geneIdSelect;
    TableColumnModel columnModel;
    CyTable filteredEnrichmentTable = null;
    boolean clearSelection = false;
    JPopupMenu popupMenu;
    private boolean registered = false;
    private String[] columnToolTips = new String[]{"the full name of the datasource for the term", "term ID in its native namespace. For non-GO terms, the ID is prefixed with the datasource abbreviation", "term name", "term description if available. If not available, repeats the term name", "hypergeometric p-value after correction for multiple testing", "the number of genes that were included in the query", "the total number of genes 'in the universe' which is used as one of the four parameters for the hypergeometric probability function of statistical significance", "the number of genes that are annotated to the term", "the number of genes in the query that are annotated to the corresponding term", "the proportion of genes in the input list that are annotated to the function, defined as intersection_size/query_size", "the proportion of functionally annotated genes that the query recovers, defined as intersection_size/term_size", "llist of query genes intersecting with terms", "Evidence codes in the term"};
    private static final Icon chartIcon = new ImageIcon(EnrichmentCytoPanel.class.getResource("/images/chart20.png"));
    final Font iconFont;
    final CyServiceRegistrar registrar;
    private Icon icon;
    final CyApplicationManager applicationManager;
    final String butFilterName = "Filter enrichment table";
    final String organismSelectTip = "Click gear icon to change organism";
    final String geneIdSelectTip = "<html>Click gear icon to change <b>Node Table</b> column with gene identifiers</html>";
    final String butSettingsName = "Network-specific enrichment panel settings";
    final String butExportTableDescr = "Export enrichment table";
    final String butRunProfilerName = "Perform Gene Enrichment";
    final String butEnrichmentMapName = "Create EnrichmentMap";
    final String butDrawChartsName = "Draw charts using default color palette";
    final String butResetChartsName = "Reset charts";
    final String butChartSettingsName = "Network-specific chart settings";
    private boolean noSignificant;
    private JSONObject result;
    CyTableFactory tableFactory;
    CyTableManager tableManager;
    private CyProperty<Properties> sessionProperties;
    private final AvailableCommands availableCommands;
    private final TaskManager<?, ?> taskManager;
    private boolean isChartEnabled = false;
    private JPanel emptyPanel;
    private final JLabel emptyLabel = new JLabel("Load a network");
    private JPanel reloadPanel;
    private final JLabel reloadIconLabel = new JLabel();
    private final JLabel reloadLabel = new JLabel("Click reload icon");

    public EnrichmentCytoPanel(CyServiceRegistrar registrar, boolean noSignificant, JSONObject result) {
        this.registrar = registrar;
        this.result = result;
        this.setLayout(new BorderLayout());
        this.colorChooserFactory = (CyColorPaletteChooserFactory)registrar.getService(CyColorPaletteChooserFactory.class);
        this.availableCommands = (AvailableCommands)registrar.getService(AvailableCommands.class);
        this.taskManager = (TaskManager)registrar.getService(TaskManager.class);
        IconManager iconManager = (IconManager)registrar.getService(IconManager.class);
        this.iconFont = iconManager.getIconFont(22.0f);
        this.applicationManager = (CyApplicationManager)registrar.getService(CyApplicationManager.class);
        this.enrichmentTables = new HashMap<String, JTable>();
        this.noSignificant = noSignificant;
        this.initPanel(this.noSignificant);
        this.registered = true;
    }

    public void setEnrichmentTable(CyTable enrichmentTable) {
        this.enrichmentTable = enrichmentTable;
        this.initPanel(this.noSignificant);
    }

    public String getIdentifier() {
        return "org.nrnb.gsoc.enrichment";
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.SOUTH;
    }

    public String getTitle() {
        return "Enrichment Table";
    }

    public Icon getIcon() {
        if (this.icon == null) {
            Font font = IconUtil.getIconFont(14.0f);
            this.icon = new TextIcon("a", font, 16, 16);
        }
        return this.icon;
    }

    public EnrichmentTableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (e.getSource().equals(this.butRunProfiler)) {
            this.taskManager.execute(new TaskIterator(new Task[]{new EnrichmentTask(this.registrar, this)}));
        } else if (e.getSource().equals(this.butFilter)) {
            this.taskManager.execute(new TaskIterator(new Task[]{new FilterEnrichmentTableTask(this.registrar, this)}));
        } else if (e.getSource().equals(this.butExportTable)) {
            if (network != null && this.enrichmentTable != null) {
                this.taskManager.execute(new TaskIterator(new Task[]{new ExportEnrichmentTableTask(this.registrar, network, this, this.enrichmentTable)}));
            }
        } else if (e.getSource().equals(this.butAdvancedOptions)) {
            if (network != null) {
                this.taskManager.execute(new TaskIterator(new Task[]{new EnrichmentAdvancedOptionsTask(this.registrar)}));
            }
        } else if (e.getSource().equals(this.butEnrichmentMap)) {
            if (network != null) {
                this.drawEnrichmentMap();
            }
        } else if (e.getSource().equals(this.butDrawCharts)) {
            AvailableCommands availableCommands;
            ViewUtils.resetCharts(this.applicationManager, this.registrar, this.tableModel);
            Map<EnrichmentTerm, String> preselectedTerms = this.getUserSelectedTerms();
            if (preselectedTerms.size() == 0) {
                preselectedTerms = this.getAutoSelectedTopTerms(SessionUtils.getTopTerms(network, this.filteredEnrichmentTable));
            }
            if (!(availableCommands = (AvailableCommands)this.registrar.getService(AvailableCommands.class)).getNamespaces().contains("enhancedGraphics")) {
                JOptionPane.showMessageDialog(null, "Charts will not be displayed. You need to install enhancedGraphics from the App Manager or Cytoscape App Store.", "No results", 2);
                return;
            }
            ViewUtils.drawCharts(this.applicationManager, this.registrar, preselectedTerms, SessionUtils.getChartType(network, this.enrichmentTable));
            this.isChartEnabled = true;
        } else if (e.getSource().equals(this.butChartSettings)) {
            this.taskManager.execute(new TaskIterator(new Task[]{new EnrichmentSettingsTask(this.registrar, this.applicationManager, this.filteredEnrichmentTable)}));
            this.isChartEnabled = true;
        } else if (e.getSource().equals(this.butResetCharts)) {
            ViewUtils.resetCharts(this.applicationManager, this.registrar, this.tableModel);
            this.isChartEnabled = false;
        }
    }

    public CyTable getFilteredTable() {
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null || this.tableModel == null) {
            return null;
        }
        if (this.filteredEnrichmentTable != null) {
            return this.filteredEnrichmentTable;
        }
        CyTable currTable = ModelUtils.getEnrichmentTable(this.registrar, network, EnrichmentTerm.TermSource.ALL.getTable());
        if (currTable == null || currTable.getRowCount() == 0) {
            return null;
        }
        CyTableFactory tableFactory = (CyTableFactory)this.registrar.getService(CyTableFactory.class);
        CyTableManager tableManager = (CyTableManager)this.registrar.getService(CyTableManager.class);
        this.filteredEnrichmentTable = tableFactory.createTable(EnrichmentTerm.TermSource.ALLFILTERED.getTable(), "id", Long.class, false, true);
        this.filteredEnrichmentTable.setTitle("Enrichment: filtered");
        this.filteredEnrichmentTable.setSavePolicy(SavePolicy.DO_NOT_SAVE);
        tableManager.addTable(this.filteredEnrichmentTable);
        ModelUtils.setupEnrichmentTable(this.filteredEnrichmentTable);
        this.updateFilteredEnrichmentTable();
        return this.filteredEnrichmentTable;
    }

    public void initPanel(boolean noSignificant) {
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        JPanel buttonsPanelLeft = new JPanel();
        BoxLayout layoutLeft = new BoxLayout(buttonsPanelLeft, 2);
        buttonsPanelLeft.setLayout(layoutLeft);
        this.butRunProfiler = new JButton("\uf021");
        this.butRunProfiler.setFont(this.iconFont);
        this.butRunProfiler.addActionListener(this);
        this.butRunProfiler.setToolTipText("Perform Gene Enrichment");
        this.butRunProfiler.setBorderPainted(false);
        this.butRunProfiler.setContentAreaFilled(false);
        this.butRunProfiler.setFocusPainted(false);
        this.butRunProfiler.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        this.butFilter = new JButton("\uf0b0");
        this.butFilter.setFont(this.iconFont);
        this.butFilter.addActionListener(this);
        this.butFilter.setToolTipText("Filter enrichment table");
        this.butFilter.setBorderPainted(false);
        this.butFilter.setContentAreaFilled(false);
        this.butFilter.setFocusPainted(false);
        this.butFilter.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        this.butEnrichmentMap = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("/images/em_logo.png")));
        this.butEnrichmentMap.addActionListener(this);
        this.butEnrichmentMap.setToolTipText("Create EnrichmentMap");
        this.butEnrichmentMap.setBorderPainted(false);
        this.butEnrichmentMap.setContentAreaFilled(false);
        this.butEnrichmentMap.setFocusPainted(false);
        this.butEnrichmentMap.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 20));
        this.butDrawCharts = new JButton(chartIcon);
        this.butDrawCharts.addActionListener(this);
        this.butDrawCharts.setToolTipText("Draw charts using default color palette");
        this.butDrawCharts.setBorderPainted(false);
        this.butDrawCharts.setContentAreaFilled(false);
        this.butDrawCharts.setFocusPainted(false);
        this.butDrawCharts.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 10));
        this.butResetCharts = new JButton("\uf10c");
        this.butResetCharts.setFont(this.iconFont);
        this.butResetCharts.addActionListener(this);
        this.butResetCharts.setToolTipText("Reset charts");
        this.butResetCharts.setBorderPainted(false);
        this.butResetCharts.setContentAreaFilled(false);
        this.butResetCharts.setFocusPainted(false);
        this.butResetCharts.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 10));
        this.butResetCharts.setEnabled(true);
        buttonsPanelLeft.add(this.butRunProfiler);
        buttonsPanelLeft.add(this.butFilter);
        buttonsPanelLeft.add(this.butEnrichmentMap);
        buttonsPanelLeft.add(this.butDrawCharts);
        buttonsPanelLeft.add(this.butResetCharts);
        JPanel buttonsPanelCenter = new JPanel();
        buttonsPanelCenter.setLayout(new FlowLayout(1, 20, 5));
        if (network != null && (ModelUtils.getNetGeneIDColumn(network) == null || ModelUtils.getNetOrganism(network) == null)) {
            this.taskManager.execute(new TaskIterator(new Task[]{new OrganismAndGeneIdAssertionTask()}));
        }
        if (network == null) {
            this.organismSelect = new JLabel("Organism: null", 2);
        } else {
            OrganismAndGeneIdAssertionTask.setOrganism(network);
            String currentOrganism = ModelUtils.getNetOrganism(network) == null ? OrganismAndGeneIdAssertionTask.getOrganismPrediction() : ModelUtils.getNetOrganism(network);
            String actualName = OrganismAndGeneIdAssertionTask.getActualNameFromCodeName(currentOrganism);
            this.organismSelect = new JLabel("Organism: " + actualName, 2);
        }
        this.organismSelect.setToolTipText("Click gear icon to change organism");
        if (network == null) {
            this.geneIdSelect = new JLabel("Gene ID column: null", 2);
        } else {
            OrganismAndGeneIdAssertionTask.setGeneId(network, this.registrar);
            this.geneIdSelect = new JLabel("Gene ID column: " + OrganismAndGeneIdAssertionTask.getGeneIdPrediction(), 2);
        }
        this.geneIdSelect.setToolTipText("<html>Click gear icon to change <b>Node Table</b> column with gene identifiers</html>");
        buttonsPanelCenter.add(this.organismSelect);
        buttonsPanelCenter.add(this.geneIdSelect);
        JPanel buttonsPanelRight = new JPanel();
        BoxLayout layoutRight = new BoxLayout(buttonsPanelRight, 2);
        buttonsPanelRight.setLayout(layoutRight);
        this.butExportTable = new JButton("\uf0c7");
        this.butExportTable.addActionListener(this);
        this.butExportTable.setFont(this.iconFont);
        this.butExportTable.setToolTipText("Export enrichment table");
        this.butExportTable.setBorderPainted(false);
        this.butExportTable.setContentAreaFilled(false);
        this.butExportTable.setFocusPainted(false);
        this.butExportTable.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 10));
        this.butExportTable.setEnabled(false);
        this.butFilter.setEnabled(false);
        this.butEnrichmentMap.setEnabled(false);
        this.butDrawCharts.setEnabled(false);
        this.butAdvancedOptions = new JButton("\uf013");
        this.butAdvancedOptions.setFont(this.iconFont);
        this.butAdvancedOptions.addActionListener(this);
        this.butAdvancedOptions.setToolTipText("Network-specific enrichment panel settings");
        this.butAdvancedOptions.setBorderPainted(false);
        this.butAdvancedOptions.setContentAreaFilled(false);
        this.butAdvancedOptions.setFocusPainted(false);
        this.butAdvancedOptions.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 10));
        this.butChartSettings = new JButton("\uf013");
        this.butChartSettings.setFont(this.iconFont);
        this.butChartSettings.addActionListener(this);
        this.butChartSettings.setToolTipText("Network-specific chart settings");
        this.butChartSettings.setBorderPainted(false);
        this.butChartSettings.setContentAreaFilled(false);
        this.butChartSettings.setFocusPainted(false);
        this.butChartSettings.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 10));
        this.butChartSettings.setEnabled(true);
        buttonsPanelRight.add(this.butExportTable);
        buttonsPanelRight.add(this.butAdvancedOptions);
        buttonsPanelRight.add(this.butChartSettings);
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.add((Component)buttonsPanelLeft, "West");
        this.topPanel.add((Component)buttonsPanelCenter, "Center");
        this.topPanel.add((Component)buttonsPanelRight, "East");
        this.add((Component)this.topPanel, "North");
        if (network == null) {
            this.mainPanel = this.getEmptyPanel();
            this.add((Component)this.mainPanel, "Center");
            return;
        }
        this.initPanel(network, noSignificant);
    }

    public void initPanel(CyNetwork network, boolean noSignificant) {
        this.removeAll();
        this.availableTables = new ArrayList<String>();
        Set<CyTable> currTables = ModelUtils.getEnrichmentTables(this.registrar, network);
        Iterator<CyTable> iterator = currTables.iterator();
        while (iterator.hasNext()) {
            CyTable currTable;
            this.enrichmentTable = currTable = iterator.next();
            this.availableTables.add(this.enrichmentTable.getTitle());
        }
        JPanel buttonsPanelLeft = new JPanel();
        BoxLayout layoutLeft = new BoxLayout(buttonsPanelLeft, 2);
        buttonsPanelLeft.setLayout(layoutLeft);
        buttonsPanelLeft.add(this.butRunProfiler);
        buttonsPanelLeft.add(this.butFilter);
        buttonsPanelLeft.add(this.butEnrichmentMap);
        buttonsPanelLeft.add(this.butDrawCharts);
        buttonsPanelLeft.add(this.butResetCharts);
        JPanel buttonsPanelCenter = new JPanel();
        buttonsPanelCenter.setLayout(new FlowLayout(1, 20, 5));
        if (network != null && (ModelUtils.getNetGeneIDColumn(network) == null || ModelUtils.getNetOrganism(network) == null)) {
            this.taskManager.execute(new TaskIterator(new Task[]{new OrganismAndGeneIdAssertionTask()}));
        }
        if (network == null) {
            this.organismSelect = new JLabel("Organism: null", 2);
        } else {
            OrganismAndGeneIdAssertionTask.setOrganism(network);
            String currentOrganism = ModelUtils.getNetOrganism(network) == null ? OrganismAndGeneIdAssertionTask.getOrganismPrediction() : ModelUtils.getNetOrganism(network);
            String actualName = OrganismAndGeneIdAssertionTask.getActualNameFromCodeName(currentOrganism);
            this.organismSelect = new JLabel("Organism: " + actualName, 2);
        }
        this.organismSelect.setToolTipText("Click gear icon to change organism");
        if (network == null) {
            this.geneIdSelect = new JLabel("Gene ID column: null", 2);
        } else {
            OrganismAndGeneIdAssertionTask.setGeneId(network, this.registrar);
            this.geneIdSelect = new JLabel("Gene ID column: " + OrganismAndGeneIdAssertionTask.getGeneIdPrediction(), 2);
        }
        this.geneIdSelect.setToolTipText("<html>Click gear icon to change <b>Node Table</b> column with gene identifiers</html>");
        buttonsPanelCenter.add(this.organismSelect);
        buttonsPanelCenter.add(this.geneIdSelect);
        JPanel buttonsPanelRight = new JPanel();
        BoxLayout layoutRight = new BoxLayout(buttonsPanelRight, 2);
        buttonsPanelRight.setLayout(layoutRight);
        this.butExportTable = new JButton("\uf0c7");
        this.butExportTable.addActionListener(this);
        this.butExportTable.setFont(this.iconFont);
        this.butExportTable.setToolTipText("Export enrichment table");
        this.butExportTable.setBorderPainted(false);
        this.butExportTable.setContentAreaFilled(false);
        this.butExportTable.setFocusPainted(false);
        this.butExportTable.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 10));
        this.butExportTable.setEnabled(false);
        this.butFilter.setEnabled(false);
        this.butEnrichmentMap.setEnabled(false);
        this.butAdvancedOptions = new JButton("\uf013");
        this.butAdvancedOptions.setFont(this.iconFont);
        this.butAdvancedOptions.addActionListener(this);
        this.butAdvancedOptions.setToolTipText("Network-specific enrichment panel settings");
        this.butAdvancedOptions.setBorderPainted(false);
        this.butAdvancedOptions.setContentAreaFilled(false);
        this.butAdvancedOptions.setFocusPainted(false);
        this.butAdvancedOptions.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 10));
        this.butChartSettings = new JButton("\uf200");
        this.butChartSettings.setFont(this.iconFont);
        this.butChartSettings.addActionListener(this);
        this.butChartSettings.setToolTipText("Network-specific chart settings");
        this.butChartSettings.setBorderPainted(false);
        this.butChartSettings.setContentAreaFilled(false);
        this.butChartSettings.setFocusPainted(false);
        this.butChartSettings.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 10));
        this.butChartSettings.setEnabled(true);
        buttonsPanelRight.add(this.butExportTable);
        buttonsPanelRight.add(this.butAdvancedOptions);
        buttonsPanelRight.add(this.butChartSettings);
        this.butExportTable.setEnabled(true);
        this.butFilter.setEnabled(true);
        this.butDrawCharts.setEnabled(true);
        this.butResetCharts.setEnabled(true);
        JPanel labelPanel = new JPanel();
        JPanel labelAndButtonPanelRight = new JPanel();
        labelAndButtonPanelRight.add((Component)labelPanel, "East");
        labelAndButtonPanelRight.add((Component)buttonsPanelRight, "West");
        if (this.isEnrichmentMapInstalled()) {
            this.butEnrichmentMap.setEnabled(true);
        } else {
            this.butEnrichmentMap.setToolTipText("Install enrichment map to use functionality");
        }
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.add((Component)buttonsPanelLeft, "West");
        this.topPanel.add((Component)buttonsPanelCenter, "Center");
        this.topPanel.add((Component)labelAndButtonPanelRight, "East");
        this.add((Component)this.topPanel, "North");
        if (noSignificant) {
            this.mainPanel = new JPanel(new BorderLayout());
            JLabel label = new JLabel("Enrichment returned no results that met the criteria. Click on the gear icon to check settings.", 0);
            this.mainPanel.add((Component)label, "Center");
            this.add((Component)this.mainPanel, "Center");
        } else if (this.availableTables.size() == 0) {
            this.mainPanel = this.getReloadPanel();
            this.add((Component)this.mainPanel, "Center");
        } else {
            if (this.enrichmentTable == null) {
                CyTableManager tableManager = (CyTableManager)this.registrar.getService(CyTableManager.class);
                this.tableFactory = (CyTableFactory)this.registrar.getService(CyTableFactory.class);
                this.enrichmentTable = this.tableFactory.createTable(EnrichmentTerm.TermSource.ALL.getTable(), "id", Long.class, false, true);
                tableManager.addTable(this.enrichmentTable);
            }
            this.createJTable(this.enrichmentTable);
            List rows = this.enrichmentTable.getAllRows();
            this.availableTables.add(this.enrichmentTable.getTitle());
            JTable currentTable = this.enrichmentTables.get(this.enrichmentTable.getTitle());
            if (this.tableModel != null) {
                this.updateFilteredEnrichmentTable();
            }
            this.labelRows = new JLabel("");
            this.updateLabelRows();
            this.labelRows.setHorizontalAlignment(4);
            Font labelFont = this.labelRows.getFont();
            this.labelRows.setFont(labelFont.deriveFont((float)((double)labelFont.getSize() * 0.8)));
            labelPanel.add(this.labelRows);
            this.mainPanel = new JPanel(new BorderLayout());
            this.scrollPane = new JScrollPane(currentTable);
            this.mainPanel.setLayout(new GridLayout(1, 1));
            this.mainPanel.add((Component)this.scrollPane, "Center");
            this.add((Component)this.mainPanel, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    private JPanel getEmptyPanel() {
        if (this.emptyPanel == null) {
            this.emptyPanel = new JPanel();
            this.emptyPanel.setBackground(UIManager.getColor("Table.background"));
            Color fg = UIManager.getColor("Label.disabledForeground");
            fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 120);
            this.emptyPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createDashedBorder(fg, 2.0f, 2.0f, 2.0f, true)));
            this.emptyLabel.setFont(this.emptyLabel.getFont().deriveFont(18.0f).deriveFont(1));
            this.emptyLabel.setForeground(fg);
            GroupLayout layout = new GroupLayout(this.emptyPanel);
            this.emptyPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.emptyLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.emptyLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
        }
        return this.emptyPanel;
    }

    private JPanel getReloadPanel() {
        if (this.reloadPanel == null) {
            this.reloadPanel = new JPanel();
            this.reloadPanel.setBackground(UIManager.getColor("Table.background"));
            Color fg = UIManager.getColor("Label.disabledForeground");
            fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 120);
            this.reloadPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createDashedBorder(fg, 2.0f, 2.0f, 2.0f, true)));
            this.reloadIconLabel.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("/images/reload-table-56.png")));
            this.reloadIconLabel.setForeground(fg);
            this.reloadLabel.setFont(this.reloadLabel.getFont().deriveFont(18.0f).deriveFont(1));
            this.reloadLabel.setForeground(fg);
            GroupLayout layout = new GroupLayout(this.reloadPanel);
            this.reloadPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.reloadIconLabel, -2, -1, -2).addComponent(this.reloadLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.reloadIconLabel, -2, -1, -2).addComponent(this.reloadLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
        }
        return this.reloadPanel;
    }

    private void createJTable(CyTable cyTable) {
        this.tableModel = new EnrichmentTableModel(this.enrichmentTable, EnrichmentTerm.swingColumnsEnrichment);
        final JTable jTable = new JTable(this.tableModel){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Object tip = null;
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return EnrichmentCytoPanel.this.columnToolTips[realIndex];
                    }
                };
            }
        };
        jTable.getColumnModel().getColumn(13).setMinWidth(0);
        jTable.getColumnModel().getColumn(13).setMaxWidth(0);
        jTable.getColumnModel().getColumn(13).setWidth(0);
        jTable.getColumn("Evidence codes").setMinWidth(0);
        jTable.getColumn("Evidence codes").setMaxWidth(0);
        jTable.getColumn("Evidence codes").setWidth(0);
        jTable.getColumn("p-value").setCellRenderer(new DecimalFormatRenderer());
        jTable.setFillsViewportHeight(true);
        jTable.setAutoCreateRowSorter(true);
        jTable.setAutoResizeMode(4);
        jTable.getSelectionModel().setSelectionMode(2);
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EnrichmentCytoPanel.this.enrichmentTables.put(EnrichmentCytoPanel.this.enrichmentTable.getTitle(), jTable);
                int rows = jTable.getSelectedRow();
                int columnCount = jTable.getSelectedColumnCount();
                if (e.getValueIsAdjusting()) {
                    return;
                }
                CyNetwork network = EnrichmentCytoPanel.this.applicationManager.getCurrentNetwork();
                if (network == null) {
                    return;
                }
                if (jTable == null) {
                    return;
                }
                if (columnCount == 1 && rows > -1) {
                    if (jTable.getSelectedRowCount() == 1) {
                        EnrichmentCytoPanel.this.clearNetworkSelection(network);
                    }
                    for (int row : jTable.getSelectedRows()) {
                        Object cellContent = jTable.getModel().getValueAt(jTable.convertRowIndexToModel(row), 13);
                        if (!(cellContent instanceof List)) continue;
                        List nodeIDs = (List)cellContent;
                        for (Long nodeID : nodeIDs) {
                            network.getDefaultNodeTable().getRow((Object)nodeID).set("selected", (Object)true);
                        }
                    }
                }
            }
        });
        jTable.getModel().addTableModelListener(this);
        jTable.setDefaultRenderer(Color.class, new ColorRenderer(true));
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        this.popupMenu = new JPopupMenu();
        JMenuItem menuItemClearRowSelection = new JMenuItem("Clear row selection");
        menuItemClearRowSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                JPopupMenu popup = (JPopupMenu)c.getParent();
                JTable table = (JTable)popup.getInvoker();
                table.clearSelection();
                EnrichmentCytoPanel.this.updateLabelRows();
            }
        });
        this.popupMenu.add(menuItemClearRowSelection);
        jTable.setComponentPopupMenu(this.popupMenu);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int row = source.rowAtPoint(e.getPoint());
                int column = source.columnAtPoint(e.getPoint());
                if (!source.isRowSelected(row)) {
                    source.changeSelection(row, column, false, false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int row = source.rowAtPoint(e.getPoint());
                int column = source.columnAtPoint(e.getPoint());
                if (!source.isRowSelected(row)) {
                    source.changeSelection(row, column, false, false);
                }
            }
        });
        this.enrichmentTables.put(this.enrichmentTable.getTitle(), jTable);
    }

    public CyTable updateFilteredEnrichmentTable() {
        CyNetwork network;
        if (this.filteredEnrichmentTable == null) {
            this.getFilteredTable();
        }
        if ((network = this.applicationManager.getCurrentNetwork()) == null || this.tableModel == null) {
            return null;
        }
        CyTable currTable = ModelUtils.getEnrichmentTable(this.registrar, network, EnrichmentTerm.TermSource.ALL.getTable());
        if (currTable == null) {
            return null;
        }
        this.filteredEnrichmentTable.deleteRows((Collection)this.filteredEnrichmentTable.getPrimaryKey().getValues(Long.class));
        Long[] rowNames = this.tableModel.getRowNames();
        for (int i = 0; i < rowNames.length; ++i) {
            CyRow row = currTable.getRow((Object)rowNames[i]);
            CyRow filtRow = this.filteredEnrichmentTable.getRow((Object)rowNames[i]);
            filtRow.set("term name", (Object)((String)row.get("term name", String.class)));
            filtRow.set("description", (Object)((String)row.get("description", String.class)));
            filtRow.set("p-value", (Object)((Double)row.get("p-value", Double.class)));
            filtRow.set("intersecting genes", (Object)row.getList("intersecting genes", String.class));
            filtRow.set("nodes.SUID", (Object)row.getList("nodes.SUID", Long.class));
            filtRow.set("network.SUID", (Object)((Long)row.get("network.SUID", Long.class)));
        }
        return this.filteredEnrichmentTable;
    }

    public void resetColor(int currentRow) {
        JTable currentTable = this.enrichmentTables.get(showTable);
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null || this.tableModel == null) {
            return;
        }
        CyTable enrichmentTable = ModelUtils.getEnrichmentTable(this.registrar, network, EnrichmentTerm.TermSource.ALL.getTable());
        Color color = (Color)currentTable.getModel().getValueAt(currentTable.convertRowIndexToModel(currentRow), 1);
        String termName = (String)currentTable.getModel().getValueAt(currentTable.convertRowIndexToModel(currentRow), 3);
        if (color == null || termName == null) {
            return;
        }
        for (CyRow row : enrichmentTable.getAllRows()) {
            if (enrichmentTable.getColumn("term name") == null || row.get("term name", String.class) == null || !((String)row.get("term name", String.class)).equals(termName)) continue;
            row.set("chart color", (Object)"");
        }
        this.tableModel.fireTableDataChanged();
    }

    public void updateLabelRows() {
        if (this.tableModel == null) {
            return;
        }
        Object labelTxt = "";
        labelTxt = this.tableModel.getAllRowCount() != this.tableModel.getRowCount() ? this.tableModel.getRowCount() + " rows (" + this.tableModel.getAllRowCount() + " before filtering)" : this.tableModel.getAllRowCount() + " rows";
        if (this.labelRows != null) {
            this.labelRows.setText((String)labelTxt);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null) {
            return;
        }
        this.updateLabelRows();
        this.updateFilteredEnrichmentTable();
        JTable currentTable = this.enrichmentTables.get(showTable);
        if (currentTable == null) {
            currentTable = this.enrichmentTables.get(this.enrichmentTable.getTitle());
        }
        currentTable.tableChanged(e);
    }

    private void clearNetworkSelection(CyNetwork network) {
        List nodes = network.getNodeList();
        this.clearSelection = true;
        for (CyNode node : nodes) {
            if (!((Boolean)network.getRow((CyIdentifiable)node).get("selected", Boolean.class)).booleanValue()) continue;
            network.getRow((CyIdentifiable)node).set("selected", (Object)false);
        }
        this.clearSelection = false;
    }

    public void handleEvent(SetCurrentNetworkEvent event) {
        CyNetwork network = event.getNetwork();
        if (ModelUtils.ifHaveEnrichmentNS(network)) {
            if (!this.registered) {
                this.showCytoPanel();
            } else {
                this.initPanel(network, false);
            }
        } else {
            this.hideCytoPanel();
        }
    }

    public void handleEvent(SelectedNodesAndEdgesEvent event) {
        JTable table = this.enrichmentTables.get(showTable);
        if (table != null && table.getSelectedRow() > -1 && table.getSelectedColumnCount() == 1 && table.getSelectedColumn() != 1) {
            return;
        }
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null || this.tableModel == null) {
            return;
        }
        ArrayList<Long> nodesToFilterSUID = new ArrayList<Long>();
        for (CyNode node : event.getSelectedNodes()) {
            nodesToFilterSUID.add(node.getSUID());
        }
        this.tableModel.filterByNodeSUID(nodesToFilterSUID, true, SessionUtils.getSelectedCategories(network, this.enrichmentTable), SessionUtils.getSelectedEvidenceCode(network, this.enrichmentTable), SessionUtils.getRemoveRedundantStatus(network, this.enrichmentTable), SessionUtils.getRemoveRedundantCutoff(network, this.enrichmentTable));
        this.updateLabelRows();
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent e) {
        int compIndex;
        Component panel;
        CyNetwork network = e.getNetwork();
        CyTableManager tableManager = (CyTableManager)this.registrar.getService(CyTableManager.class);
        Set<CyTable> oldTables = ModelUtils.getEnrichmentTables(this.registrar, network);
        for (CyTable table : oldTables) {
            tableManager.deleteTable(table.getSUID().longValue());
        }
        CySwingApplication swingApplication = (CySwingApplication)this.registrar.getService(CySwingApplication.class);
        CytoPanel cytoPanel = swingApplication.getCytoPanel(CytoPanelName.SOUTH);
        if (cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment") >= 0 && (panel = cytoPanel.getComponentAt(compIndex = cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"))) instanceof CytoPanelComponent2) {
            this.registrar.unregisterService((Object)panel, CytoPanelComponent.class);
            this.registrar.unregisterService((Object)panel, SelectedNodesAndEdgesListener.class);
            this.registrar.unregisterService((Object)panel, SetCurrentNetworkListener.class);
        }
        EnrichmentCytoPanel panel2 = new EnrichmentCytoPanel(this.registrar, this.noSignificant, null);
        this.registrar.registerService((Object)panel2, CytoPanelComponent.class, new Properties());
        this.registrar.registerService((Object)panel2, SelectedNodesAndEdgesListener.class, new Properties());
        this.registrar.registerService((Object)panel2, SetCurrentNetworkListener.class, new Properties());
        if (cytoPanel.getState() == CytoPanelState.HIDE) {
            cytoPanel.setState(CytoPanelState.DOCK);
        }
        cytoPanel.setSelectedIndex(cytoPanel.indexOfComponent("org.cytoscape.NodeTables"));
    }

    public void handleEvent(SessionLoadedEvent arg0) {
        int compIndex;
        Component panel;
        CySwingApplication swingApplication = (CySwingApplication)this.registrar.getService(CySwingApplication.class);
        CytoPanel cytoPanel = swingApplication.getCytoPanel(CytoPanelName.SOUTH);
        if (cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment") >= 0 && (panel = cytoPanel.getComponentAt(compIndex = cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"))) instanceof CytoPanelComponent2) {
            this.registrar.unregisterService((Object)panel, CytoPanelComponent.class);
            this.registrar.unregisterService((Object)panel, SelectedNodesAndEdgesListener.class);
            this.registrar.unregisterService((Object)panel, SetCurrentNetworkListener.class);
        }
        EnrichmentCytoPanel panel2 = new EnrichmentCytoPanel(this.registrar, this.noSignificant, null);
        this.registrar.registerService((Object)panel2, CytoPanelComponent.class, new Properties());
        this.registrar.registerService((Object)panel2, SelectedNodesAndEdgesListener.class, new Properties());
        this.registrar.registerService((Object)panel2, SetCurrentNetworkListener.class, new Properties());
        if (cytoPanel.getState() == CytoPanelState.HIDE) {
            cytoPanel.setState(CytoPanelState.DOCK);
        }
        cytoPanel.setSelectedIndex(cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"));
    }

    public void drawCharts() {
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null) {
            return;
        }
        ViewUtils.resetCharts(this.applicationManager, this.registrar, this.tableModel);
        Map<EnrichmentTerm, String> preselectedTerms = this.getUserSelectedTerms();
        if (preselectedTerms.size() == 0) {
            preselectedTerms = this.getAutoSelectedTopTerms(SessionUtils.getTopTerms(network, this.filteredEnrichmentTable));
        }
        ViewUtils.drawCharts(this.applicationManager, this.registrar, preselectedTerms, SessionUtils.getChartType(network, this.filteredEnrichmentTable));
        this.isChartEnabled = true;
    }

    public boolean getIsChartEnabled() {
        return this.isChartEnabled;
    }

    public void showCytoPanel() {
        CySwingApplication swingApplication = (CySwingApplication)this.registrar.getService(CySwingApplication.class);
        CytoPanel cytoPanel = swingApplication.getCytoPanel(CytoPanelName.SOUTH);
        if (!this.registered && cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment") < 0) {
            this.registrar.registerService((Object)this, CytoPanelComponent.class, new Properties());
            this.registered = true;
        }
        if (cytoPanel.getState() == CytoPanelState.HIDE) {
            cytoPanel.setState(CytoPanelState.DOCK);
        }
        this.initPanel(false);
        cytoPanel.setSelectedIndex(cytoPanel.indexOfComponent("edu.ucsf.rbvi.stringApp.Enrichment"));
    }

    public void hideCytoPanel() {
        this.registrar.unregisterService((Object)this, CytoPanelComponent.class);
        this.registered = false;
    }

    private boolean isEnrichmentMapInstalled() {
        return this.availableCommands.getNamespaces().contains("enrichmentmap");
    }

    private void drawEnrichmentMap() {
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null) {
            return;
        }
        if (this.tableModel.getAllRowCount() != this.tableModel.getRowCount()) {
            this.taskManager.execute(new TaskIterator(new Task[]{new EnrichmentMapAdvancedTask(network, this.getFilteredTable(), this.enrichmentTable, true, this.registrar)}));
        } else {
            this.taskManager.execute(new TaskIterator(new Task[]{new EnrichmentMapAdvancedTask(network, this.getFilteredTable(), this.enrichmentTable, false, this.registrar)}));
        }
    }

    private Map<EnrichmentTerm, String> getUserSelectedTerms() {
        LinkedHashMap<EnrichmentTerm, String> selectedTerms = new LinkedHashMap<EnrichmentTerm, String>();
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null) {
            return selectedTerms;
        }
        CyTable currTable = this.getFilteredTable();
        if (currTable == null || currTable.getRowCount() == 0) {
            return selectedTerms;
        }
        for (CyRow row : currTable.getAllRows()) {
            if (currTable.getColumn("chart color") == null || row.get("chart color", String.class) == null || ((String)row.get("chart color", String.class)).equals("") || ((String)row.get("chart color", String.class)).equals("#ffffff")) continue;
            System.out.println("Set color");
            String selTerm = (String)row.get("term name", String.class);
            if (selTerm == null) continue;
            EnrichmentTerm enrTerm = new EnrichmentTerm(selTerm, (String)row.get("description", String.class), (String)row.get("source", String.class), (Double)row.get("p-value", Double.class));
            enrTerm.setNodesSUID(row.getList("nodes.SUID", Long.class));
            selectedTerms.put(enrTerm, (String)row.get("chart color", String.class));
        }
        return selectedTerms;
    }

    private Map<EnrichmentTerm, String> getAutoSelectedTopTerms(int termNumber) {
        LinkedHashMap<EnrichmentTerm, String> selectedTerms = new LinkedHashMap<EnrichmentTerm, String>();
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null || this.tableModel == null) {
            return selectedTerms;
        }
        CyTable currTable = ModelUtils.getEnrichmentTable(this.registrar, network, EnrichmentTerm.TermSource.ALL.getTable());
        if (currTable == null || currTable.getRowCount() == 0) {
            return selectedTerms;
        }
        Color[] colors = ViewUtils.getEnrichmentPalette(network, this.filteredEnrichmentTable, this.registrar).getColors(termNumber);
        Long[] rowNames = this.tableModel.getRowNames();
        for (int i = 0; i < termNumber; ++i) {
            CyRow row;
            String selTerm;
            if (i >= rowNames.length || (selTerm = (String)(row = currTable.getRow((Object)rowNames[i])).get("term name", String.class)) == null) continue;
            EnrichmentTerm enrTerm = new EnrichmentTerm(selTerm, (String)row.get("description", String.class), (String)row.get("source", String.class), (Double)row.get("p-value", Double.class));
            enrTerm.setNodesSUID(row.getList("nodes.SUID", Long.class));
            String color = String.format("#%02x%02x%02x", colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue());
            row.set("chart color", (Object)color);
            selectedTerms.put(enrTerm, color);
        }
        this.tableModel.fireTableDataChanged();
        return selectedTerms;
    }

    private static class DecimalFormatRenderer
    extends DefaultTableCellRenderer {
        private static final DecimalFormat formatter = new DecimalFormat("#.#####E0");

        private DecimalFormatRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                if (value != null) {
                    value = formatter.format(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

