/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.nrnb.gsoc.enrichment.utils.ModelUtils;

public class OrganismAndGeneIdAssertionTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");
    private static final Map<String, String> scientificNameToID = ModelUtils.getOrganisms();
    private static String initialOrganism;
    private static String geneId;

    public static String getOrganismPrediction() {
        return initialOrganism;
    }

    public static String getGeneIdPrediction() {
        return geneId;
    }

    public static void setOrganism(CyNetwork currentNetwork) {
        if (currentNetwork == null) {
            logger.error((Object)"[Enrichment Table] No Network selected");
            return;
        }
        String currentOrganism = ModelUtils.getNetOrganism(currentNetwork);
        if (currentOrganism != null) {
            return;
        }
        initialOrganism = "hsapiens";
        OrganismNetworkEntry[] otherNetworks = OrganismNetworkEntry.values();
        ArrayList<String> otherNetworkParameters = new ArrayList<String>();
        for (OrganismNetworkEntry entry : otherNetworks) {
            otherNetworkParameters.addAll(OrganismAndGeneIdAssertionTask.getList(currentNetwork, entry.toString()));
        }
        for (String possibleOrganism : otherNetworkParameters) {
            if (possibleOrganism == null) continue;
            String trimmedPossibleOrganism = possibleOrganism.trim().toLowerCase();
            Optional<String> gProfilerOrganism = scientificNameToID.keySet().stream().filter(gProfilerName -> trimmedPossibleOrganism.contains(gProfilerName.toLowerCase())).findFirst();
            if (gProfilerOrganism.isPresent()) {
                initialOrganism = scientificNameToID.get(gProfilerOrganism.get());
                logger.info((Object)("[Enrichment Table] Organism predicted to be [" + initialOrganism + "] for enrichment"));
                break;
            }
            Optional<Map.Entry> gProfilerScientificId = scientificNameToID.entrySet().stream().filter(keyValuePair -> trimmedPossibleOrganism.contains(((String)keyValuePair.getValue()).toLowerCase())).findFirst();
            if (!gProfilerScientificId.isPresent()) continue;
            initialOrganism = (String)gProfilerScientificId.get().getValue();
            logger.info((Object)("[Enrichment Table] Organism predicted to be [" + initialOrganism + "] for enrichment"));
            break;
        }
        logger.info((Object)("[Enrichment Table] Using default organism [" + initialOrganism + "] for enrichment "));
    }

    public static String getActualNameFromCodeName(String codeName) {
        Optional<Map.Entry> actualName = scientificNameToID.entrySet().stream().filter(stringStringEntry -> ((String)stringStringEntry.getValue()).equals(codeName)).findFirst();
        return actualName.map(Map.Entry::getKey).orElse(null);
    }

    public static void setGeneId(CyNetwork network, CyServiceRegistrar registrar) {
        if (registrar == null) {
            logger.error((Object)"[Enrichment Table] Service registrar is null");
            return;
        }
        if (network == null) {
            logger.error((Object)"[Enrichment Table] Network is null");
            return;
        }
        geneId = ModelUtils.getNetGeneIDColumn(network);
        if (geneId != null) {
            return;
        }
        geneId = OrganismAndGeneIdAssertionTask.getGeneIdFromNetworkName(network);
        if (geneId != null) {
            logger.info((Object)("[Enrichment Table] Using column [" + geneId + "] for enrichment "));
        } else {
            CyNetworkViewManager cyNetworkViewManager = (CyNetworkViewManager)registrar.getService(CyNetworkViewManager.class);
            VisualMappingManager visualMappingManager = (VisualMappingManager)registrar.getService(VisualMappingManager.class);
            Collection views = cyNetworkViewManager.getNetworkViews(network);
            boolean isGeneSetFromStyle = false;
            for (CyNetworkView view : views) {
                VisualStyle visualStyle = visualMappingManager.getVisualStyle(view);
                VisualMappingFunction mappingFunction = visualStyle.getVisualMappingFunction(BasicVisualLexicon.NODE_LABEL);
                if (mappingFunction == null) continue;
                isGeneSetFromStyle = true;
                geneId = mappingFunction.getMappingColumnName();
                logger.info((Object)("[Enrichment Table] Using column [" + mappingFunction.getMappingColumnName() + "] for enrichment "));
                break;
            }
            if (!isGeneSetFromStyle) {
                geneId = "name";
                logger.info((Object)"[Enrichment Table] Using default column [name] for enrichment ");
            }
        }
    }

    private static List<String> getList(CyNetwork network, String columnName) {
        Optional<CyColumn> cyColumn = Optional.ofNullable(network.getDefaultNetworkTable().getColumn(columnName));
        return cyColumn.map(column -> Arrays.stream(((String)column.getValues(String.class).get(0)).split(",")).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static String getGeneIdFromNetworkName(CyNetwork network) {
        String networkName;
        String geneId = null;
        CyColumn networkNameColumn = network.getDefaultNetworkTable().getColumn("name");
        if (networkNameColumn != null && networkNameColumn.getValues(String.class) != null && !networkNameColumn.getValues(String.class).isEmpty() && (networkName = (String)networkNameColumn.getValues(String.class).get(0)).contains("STRING")) {
            geneId = "display name";
        }
        return geneId;
    }

    public void run(TaskMonitor taskMonitor) {
        taskMonitor.setTitle("Organism and Gene id assertion");
    }

    private static enum OrganismNetworkEntry {
        STRINGAPP("species"),
        NDEX("organism"),
        IntAct("IntAct::species");

        private final String columnName;

        private OrganismNetworkEntry(String columnName) {
            this.columnName = columnName;
        }

        public String toString() {
            return this.columnName;
        }
    }
}

