/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.BoundedDouble;
import org.cytoscape.work.util.ListMultipleSelection;
import org.nrnb.gsoc.enrichment.constants.EVIDENCE_CODES;
import org.nrnb.gsoc.enrichment.model.EnrichmentTerm;
import org.nrnb.gsoc.enrichment.ui.EnrichmentCytoPanel;
import org.nrnb.gsoc.enrichment.ui.EnrichmentTableModel;
import org.nrnb.gsoc.enrichment.utils.ModelUtils;
import org.nrnb.gsoc.enrichment.utils.SessionUtils;
import org.nrnb.gsoc.enrichment.utils.ViewUtils;

public class FilterEnrichmentTableTask
extends AbstractTask
implements ObservableTask {
    @Tunable(description="Select categories", tooltip="Select the enrichment categories to show in the table", longDescription="Select the enrichment categories to show in the table. Use \"All\" to remove the filtering.", exampleStringValue="GO Process", gravity=1.0)
    public ListMultipleSelection<EnrichmentTerm.TermSource> categories = new ListMultipleSelection(EnrichmentTerm.TermSource.getValues());
    @Tunable(description="Select evidence code", tooltip="Select the evidence codes to show in the table. If multiple codes are selected, those terms which contains all the selected codes will be present in result", exampleStringValue="GO:0005737", gravity=1.0)
    public ListMultipleSelection<String> evidenceCodes;
    @Tunable(description="Remove redundant terms", tooltip="Removes terms whose enriched genes significantly overlap with already selected terms", longDescription="Removes terms whose enriched genes significantly overlap with already selected terms", exampleStringValue="true", gravity=8.0)
    public boolean removeOverlapping;
    @Tunable(description="Redundancy cutoff", tooltip="<html>This is the maximum Jaccard similarity that will be allowed <br/>between a less significant term and a more significant term such that <br/>the less significant term is kept in the list</html>", longDescription="This is the maximum Jaccard similarity that will be allowed between a less significant term and a more significant term such that the less significant term is kept in the list", exampleStringValue="0.5", params="slider=true", dependsOn="removeOverlapping=true", gravity=9.0)
    public BoundedDouble overlapCutoff = new BoundedDouble(Double.valueOf(0.0), Double.valueOf(0.5), Double.valueOf(1.0), false, false);
    private CyApplicationManager applicationManager;
    private EnrichmentCytoPanel enrichmentPanel;
    private CyNetwork network;
    private CyTable filteredEnrichmentTable;
    private CyServiceRegistrar registrar;
    private List<EnrichmentTerm.TermSource> categoryFilter = EnrichmentTerm.TermSource.getValues();
    private final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");

    public FilterEnrichmentTableTask(CyServiceRegistrar registrar, EnrichmentCytoPanel panel) {
        this.registrar = registrar;
        this.applicationManager = (CyApplicationManager)registrar.getService(CyApplicationManager.class);
        this.network = this.applicationManager.getCurrentNetwork();
        this.enrichmentPanel = panel;
        this.filteredEnrichmentTable = ModelUtils.getEnrichmentTable(registrar, this.network, EnrichmentTerm.TermSource.ALL.getTable());
        this.setCategoriesAndEvidenceCodesAtStartup();
        List<String> evidenceCodesEnum = EVIDENCE_CODES.stringValue();
        this.categories.setSelectedValues(SessionUtils.getSelectedCategories(this.network, this.filteredEnrichmentTable));
        this.evidenceCodes = new ListMultipleSelection(evidenceCodesEnum);
        this.evidenceCodes.setSelectedValues(SessionUtils.getSelectedEvidenceCode(this.network, this.filteredEnrichmentTable));
        this.removeOverlapping = SessionUtils.getRemoveRedundantStatus(this.network, this.filteredEnrichmentTable);
        this.overlapCutoff.setValue((Comparable)Double.valueOf(SessionUtils.getRemoveRedundantCutoff(this.network, this.filteredEnrichmentTable)));
    }

    private void setCategoriesAndEvidenceCodesAtStartup() {
        String termSource3;
        EnrichmentTerm.TermSource termSource2;
        List<EnrichmentTerm.TermSource> selectedCategories = SessionUtils.getSelectedCategories(this.network, this.filteredEnrichmentTable);
        if (Objects.isNull(selectedCategories)) {
            SessionUtils.setSelectedCategories(this.network, this.filteredEnrichmentTable, Collections.emptyList());
        } else if (!selectedCategories.isEmpty() && Objects.isNull((Object)(termSource2 = selectedCategories.get(0)))) {
            SessionUtils.setSelectedCategories(this.network, this.filteredEnrichmentTable, Collections.emptyList());
        }
        List<String> selectedEvidenceCodes = SessionUtils.getSelectedEvidenceCode(this.network, this.filteredEnrichmentTable);
        if (Objects.isNull(selectedEvidenceCodes)) {
            SessionUtils.setSelectedEvidenceCode(this.network, this.filteredEnrichmentTable, Collections.emptyList());
        } else if (!selectedEvidenceCodes.isEmpty() && (Objects.isNull(termSource3 = selectedEvidenceCodes.get(0)) || termSource3.isEmpty())) {
            SessionUtils.setSelectedEvidenceCode(this.network, this.filteredEnrichmentTable, Collections.emptyList());
        }
        try {
            boolean termSource3 = SessionUtils.getRemoveRedundantStatus(this.network, this.filteredEnrichmentTable);
        }
        catch (NullPointerException exception) {
            SessionUtils.setRemoveRedundantStatus(this.network, this.filteredEnrichmentTable, false);
        }
        try {
            double exception = SessionUtils.getRemoveRedundantCutoff(this.network, this.filteredEnrichmentTable);
        }
        catch (NullPointerException exception) {
            SessionUtils.setRemoveRedundantCutoff(this.network, this.filteredEnrichmentTable, 0.5);
        }
    }

    public void run(TaskMonitor monitor) throws Exception {
        EnrichmentTableModel tableModel;
        monitor.setTitle("Filter Enrichment table");
        this.logger.info((Object)("Filtering results based on selected value: categories: " + this.categories.getSelectedValues() + " , evidence code: " + this.evidenceCodes.getSelectedValues()));
        List categoryList = this.categories.getSelectedValues();
        ArrayList<String> evidenceList = new ArrayList<String>(this.evidenceCodes.getSelectedValues());
        SessionUtils.setRemoveRedundantStatus(this.network, this.filteredEnrichmentTable, this.removeOverlapping);
        SessionUtils.setRemoveRedundantCutoff(this.network, this.filteredEnrichmentTable, (Double)this.overlapCutoff.getValue());
        SessionUtils.setSelectedEvidenceCode(this.network, this.filteredEnrichmentTable, evidenceList);
        SessionUtils.setSelectedCategories(this.network, this.filteredEnrichmentTable, categoryList);
        if (this.enrichmentPanel == null) {
            CySwingApplication swingApplication = (CySwingApplication)this.registrar.getService(CySwingApplication.class);
            CytoPanel cytoPanel = swingApplication.getCytoPanel(CytoPanelName.SOUTH);
            if (cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment") != -1) {
                this.enrichmentPanel = (EnrichmentCytoPanel)cytoPanel.getComponentAt(cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"));
            } else {
                return;
            }
        }
        if ((tableModel = this.enrichmentPanel.getTableModel()) == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Unable to find enrichment table!");
            this.logger.error((Object)"Unable to find enrichment table!");
            return;
        }
        tableModel.filter(categoryList, evidenceList, this.removeOverlapping, (Double)this.overlapCutoff.getValue());
        if (this.enrichmentPanel.getIsChartEnabled()) {
            ViewUtils.resetCharts(this.applicationManager, this.registrar, tableModel);
            this.enrichmentPanel.drawCharts();
        }
        this.logger.info((Object)"Filtering results completed");
    }

    public <R> R getResults(Class<? extends R> clzz) {
        if (clzz.equals(String.class)) {
            if (this.filteredEnrichmentTable != null) {
                return (R)("\"EnrichmentTable\": " + this.filteredEnrichmentTable.getSUID());
            }
            return (R)"";
        }
        if (clzz.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.filteredEnrichmentTable != null) {
                    return "{\"EnrichmentTable\": " + this.filteredEnrichmentTable.getSUID() + "}";
                }
                return "{}";
            };
            return (R)res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class, String.class);
    }

    @ProvidesTitle
    public String getTitle() {
        return "Filter Enrichment table";
    }
}

