/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.tasks;

import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.nrnb.gsoc.enrichment.model.EnrichmentTerm;
import org.nrnb.gsoc.enrichment.tasks.ExportEnrichmentTableTask;
import org.nrnb.gsoc.enrichment.ui.EnrichmentCytoPanel;
import org.nrnb.gsoc.enrichment.utils.ModelUtils;

public class ExportEnrichmentTableTaskFactory
extends AbstractNetworkTaskFactory {
    final CyServiceRegistrar registrar;
    final CytoPanel cytoPanel;
    EnrichmentCytoPanel panel;

    public ExportEnrichmentTableTaskFactory(CyServiceRegistrar registrar) {
        this.registrar = registrar;
        CySwingApplication swingApplication = (CySwingApplication)registrar.getService(CySwingApplication.class);
        this.cytoPanel = swingApplication.getCytoPanel(CytoPanelName.SOUTH);
        if (this.cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment") > 0) {
            this.panel = (EnrichmentCytoPanel)this.cytoPanel.getComponentAt(this.cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"));
        }
    }

    public boolean isReady(CyNetwork network) {
        return ModelUtils.getEnrichmentTables(this.registrar, network).size() > 0;
    }

    public TaskIterator createTaskIterator(CyNetwork network) {
        return new TaskIterator(new Task[]{new ExportEnrichmentTableTask(this.registrar, network, this.panel, ModelUtils.getEnrichmentTable(this.registrar, network, EnrichmentTerm.TermSource.ALL.getTable()))});
    }
}

