/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.tasks;

import java.io.File;
import org.apache.log4j.Logger;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.write.ExportTableTaskFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.nrnb.gsoc.enrichment.ui.EnrichmentCytoPanel;

public class ExportEnrichmentTableTask
extends AbstractTask {
    private EnrichmentCytoPanel enrichmentPanel;
    private CyTable selectedTable;
    private final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");
    @Tunable(description="Save Table as", params="input=false", tooltip="<html>Note: for convenience spaces are replaced by underscores.</html>", gravity=2.0)
    public File prefix = null;
    final CyServiceRegistrar registrar;
    final CyNetwork network;

    public ExportEnrichmentTableTask(CyServiceRegistrar registrar, CyNetwork network, EnrichmentCytoPanel panel, CyTable table) {
        this.registrar = registrar;
        this.enrichmentPanel = panel;
        this.selectedTable = table;
        this.network = network;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Export Enrichment table");
        ExportTableTaskFactory exportTF = (ExportTableTaskFactory)this.registrar.getService(ExportTableTaskFactory.class);
        if (this.network == null) {
            return;
        }
        if (this.selectedTable != null && this.prefix != null) {
            this.logger.info((Object)("Starting Exporting Table with File name: " + this.prefix.getName()));
            File file = new File(this.prefix.getAbsolutePath());
            taskMonitor.showMessage(TaskMonitor.Level.INFO, "export table " + this.selectedTable + " to " + file.getAbsolutePath());
            TaskIterator ti = exportTF.createTaskIterator(this.selectedTable, file);
            this.insertTasksAfterCurrentTask(ti);
        }
        this.logger.info((Object)"Finished Exporting Table");
    }

    @ProvidesTitle
    public String getTitle() {
        return "Export Enrichment table";
    }
}

